/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.iri.impl;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.Violation;

public class Main {
    private static final Class<?>[] noParams = new Class[0];
    private static final Object[] noObjects = new Object[0];
    private static final Class<?>[] strParams = new Class[]{String.class};
    private boolean usedASpec = false;
    private IRIFactory factory = new IRIFactory();
    private InputStream in = System.in;
    private String specs;

    public void main(String[] args) {
        block12: {
            try {
                int i;
                for (i = 0; i < args.length; ++i) {
                    if (args[i].charAt(0) != '-') continue;
                    try {
                        Method m3 = Main.class.getDeclaredMethod(args[i].substring(1), noParams);
                        m3.invoke((Object)this, noObjects);
                        continue;
                    }
                    catch (NoSuchMethodException e2) {
                        Method m4;
                        try {
                            m4 = this.getClass().getDeclaredMethod(args[i].substring(1), strParams);
                        }
                        catch (NoSuchMethodException e1) {
                            System.err.println("Unknown option: " + args[i]);
                            this.help();
                            return;
                        }
                        m4.invoke((Object)this, (Object[])new String[]{args[i + 1]});
                        ++i;
                    }
                }
                if (!this.usedASpec) {
                    this.iri();
                }
                this.factory.useSchemeSpecificRules("*", true);
                if (i < args.length) {
                    while (i < args.length) {
                        this.check(args[i]);
                        ++i;
                    }
                    break block12;
                }
                LineNumberReader rdr = new LineNumberReader(new InputStreamReader(this.in));
                while (true) {
                    String line;
                    if ((line = rdr.readLine()) == null) {
                        return;
                    }
                    this.check(line);
                }
            }
            catch (Exception e3) {
                throw new RuntimeException(e3);
            }
        }
    }

    private void check(String string) {
        IRI iri2 = this.factory.create(string);
        if (iri2.hasViolation(true)) {
            System.out.println("n: " + string);
            Iterator<Violation> it = iri2.violations(true);
            while (it.hasNext()) {
                Violation v = it.next();
                System.out.println(v.getLongMessage());
            }
        } else {
            System.out.println("y: " + string);
        }
    }

    private void help() {
    }

    private void iri() {
        this.used("IRI", 0);
        this.factory.useSpecificationIRI(true);
    }

    private void uri() {
        this.used("URI", 0);
        this.factory.useSpecificationURI(true);
    }

    private void xml() {
        this.used("XML - systemID", 0);
        this.factory.useSpecificationXMLSystemID(true);
    }

    private void schema() {
        this.used("XML Schema - anyURI", 0);
        this.factory.useSpecificationXMLSchema(true);
    }

    private void xlink() {
        this.used("XLink - href attribute", 0);
        this.factory.useSpecificationXLink(true);
    }

    private void used(String string, int i) {
        this.usedASpec = true;
        this.specs = this.specs == null ? string : this.specs + ", " + string;
    }

    private void rdf() {
        this.used("RDF URI Reference", 0);
        this.factory.useSpecificationRDF(true);
    }

    private void f(String file) {
    }
}

