/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormatVariant;
import org.apache.jena.riot.RDFLanguages;

public class RDFFormat {
    public static RDFFormatVariant PRETTY = new RDFFormatVariant("pretty");
    public static RDFFormatVariant BLOCKS = new RDFFormatVariant("blocks");
    public static RDFFormatVariant FLAT = new RDFFormatVariant("flat");
    public static RDFFormatVariant ASCII = new RDFFormatVariant("ascii");
    public static RDFFormatVariant UTF8 = new RDFFormatVariant("utf-8");
    public static final RDFFormatVariant ValueEncoding = new RDFFormatVariant("Value");
    public static RDFFormat TURTLE_PRETTY;
    public static RDFFormat TURTLE;
    public static RDFFormat TTL;
    public static RDFFormat TURTLE_BLOCKS;
    public static RDFFormat TURTLE_FLAT;
    public static RDFFormat NTRIPLES_UTF8;
    public static RDFFormat NTRIPLES;
    public static RDFFormat NT;
    public static RDFFormat NTRIPLES_ASCII;
    public static RDFFormat NQUADS_UTF8;
    public static RDFFormat NQUADS;
    public static RDFFormat NQ;
    public static RDFFormat NQUADS_ASCII;
    public static RDFFormat TRIG_PRETTY;
    public static RDFFormat TRIG;
    public static RDFFormat TRIG_BLOCKS;
    public static RDFFormat TRIG_FLAT;
    public static RDFFormat JSONLD_PRETTY;
    public static RDFFormat JSONLD;
    public static RDFFormat JSONLD_FLAT;
    public static RDFFormatVariant ABBREV;
    public static RDFFormatVariant PLAIN;
    public static RDFFormat RDFXML_PRETTY;
    public static RDFFormat RDFXML_ABBREV;
    public static RDFFormat RDFXML;
    public static RDFFormat RDFXML_PLAIN;
    public static RDFFormat RDFJSON;
    public static final RDFFormat RDF_THRIFT;
    public static final RDFFormat RDF_THRIFT_VALUES;
    public static RDFFormat RDFNULL;
    private final Lang lang;
    private final RDFFormatVariant variant;

    public RDFFormat(Lang lang) {
        this(lang, null);
    }

    public RDFFormat(Lang lang, RDFFormatVariant variant) {
        this.lang = lang;
        this.variant = variant;
    }

    public Lang getLang() {
        return this.lang;
    }

    public RDFFormatVariant getVariant() {
        return this.variant;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lang == null ? 0 : this.lang.hashCode());
        result = 31 * result + (this.variant == null ? 0 : this.variant.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RDFFormat other = (RDFFormat)obj;
        if (!Lib.equal(this.lang, other.lang)) {
            return false;
        }
        return Lib.equal(this.variant, other.variant);
    }

    public String toString() {
        if (this.variant == null) {
            return this.lang.getName();
        }
        return this.lang.getName() + "/" + this.variant;
    }

    static {
        TURTLE = TURTLE_PRETTY = new RDFFormat(Lang.TURTLE, PRETTY);
        TTL = TURTLE_PRETTY;
        TURTLE_BLOCKS = new RDFFormat(Lang.TURTLE, BLOCKS);
        TURTLE_FLAT = new RDFFormat(Lang.TURTLE, FLAT);
        NT = NTRIPLES = (NTRIPLES_UTF8 = new RDFFormat(Lang.NTRIPLES, UTF8));
        NTRIPLES_ASCII = new RDFFormat(Lang.NTRIPLES, ASCII);
        NQ = NQUADS = (NQUADS_UTF8 = new RDFFormat(Lang.NQUADS, UTF8));
        NQUADS_ASCII = new RDFFormat(Lang.NQUADS, ASCII);
        TRIG = TRIG_PRETTY = new RDFFormat(Lang.TRIG, PRETTY);
        TRIG_BLOCKS = new RDFFormat(Lang.TRIG, BLOCKS);
        TRIG_FLAT = new RDFFormat(Lang.TRIG, FLAT);
        JSONLD = JSONLD_PRETTY = new RDFFormat(Lang.JSONLD, PRETTY);
        JSONLD_FLAT = new RDFFormat(Lang.JSONLD, FLAT);
        ABBREV = new RDFFormatVariant("pretty");
        PLAIN = new RDFFormatVariant("plain");
        RDFXML_ABBREV = RDFXML_PRETTY = new RDFFormat(Lang.RDFXML, ABBREV);
        RDFXML = RDFXML_PRETTY;
        RDFXML_PLAIN = new RDFFormat(Lang.RDFXML, PLAIN);
        RDFJSON = new RDFFormat(Lang.RDFJSON);
        RDF_THRIFT = new RDFFormat(RDFLanguages.THRIFT);
        RDF_THRIFT_VALUES = new RDFFormat(RDFLanguages.THRIFT, ValueEncoding);
        RDFNULL = new RDFFormat(Lang.RDFNULL);
    }
}

