/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.riot.writer.WriterStreamRDFBase;

abstract class WriterStreamRDFBatched
extends WriterStreamRDFBase {
    private Node currentSubject;
    private Node currentGraph;
    private List<Triple> batchTriples;
    private List<Quad> batchQuads;

    public WriterStreamRDFBatched(OutputStream output) {
        super(output);
    }

    public WriterStreamRDFBatched(Writer output) {
        super(output);
    }

    public WriterStreamRDFBatched(IndentedWriter output) {
        super(output);
    }

    @Override
    protected final void startData() {
        this.reset();
    }

    @Override
    protected final void endData() {
        this.flush();
    }

    private void flush() {
        this.finishBatchTriples(this.currentSubject);
        this.finishBatchQuad(this.currentGraph, this.currentSubject);
        this.finalizeRun();
    }

    @Override
    protected final void reset() {
        this.currentSubject = null;
        this.currentGraph = null;
        this.batchTriples = null;
        this.batchQuads = null;
    }

    @Override
    protected final void print(Quad quad) {
        Node g2 = quad.getGraph();
        Node s2 = quad.getSubject();
        if (!Lib.equal(g2, this.currentGraph) || !Lib.equal(s2, this.currentSubject)) {
            if (this.currentSubject != null) {
                if (this.currentGraph == null) {
                    this.finishBatchTriples(this.currentSubject);
                } else {
                    this.finishBatchQuad(this.currentGraph, this.currentSubject);
                }
            }
            this.startBatchQuad(g2, s2);
            this.currentGraph = g2;
            this.currentSubject = s2;
        }
        this.processQuad(quad);
    }

    @Override
    protected final void print(Triple triple) {
        Node s2 = triple.getSubject();
        if (!Lib.equal(s2, this.currentSubject)) {
            if (this.currentSubject != null) {
                this.finishBatchTriples(this.currentSubject);
            }
            this.startBatchTriple(s2);
            this.currentGraph = null;
            this.currentSubject = s2;
        }
        this.processTriple(triple);
    }

    private void startBatchTriple(Node subject) {
        this.batchTriples = new ArrayList<Triple>();
    }

    private void processTriple(Triple triple) {
        this.batchTriples.add(triple);
    }

    private void finishBatchTriples(Node subject) {
        if (this.batchTriples != null && this.batchTriples.size() > 0) {
            this.printBatchTriples(this.currentSubject, this.batchTriples);
            this.batchTriples.clear();
        }
    }

    private void startBatchQuad(Node graph, Node subject) {
        this.batchQuads = new ArrayList<Quad>();
    }

    private void processQuad(Quad Quad2) {
        this.batchQuads.add(Quad2);
    }

    private void finishBatchQuad(Node graph, Node subject) {
        if (this.batchQuads != null && this.batchQuads.size() > 0) {
            this.printBatchQuads(this.currentGraph, this.currentSubject, this.batchQuads);
            this.batchQuads.clear();
        }
    }

    protected abstract void printBatchQuads(Node var1, Node var2, List<Quad> var3);

    protected abstract void printBatchTriples(Node var1, List<Triple> var2);

    protected abstract void finalizeRun();
}

