/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.entity.InputStreamEntity;
import org.fcrepo.client.FcrepoClient;
import org.fcrepo.client.RequestBuilder;

public abstract class BodyRequestBuilder
extends RequestBuilder {
    protected BodyRequestBuilder(URI uri, FcrepoClient client) {
        super(uri, client);
    }

    protected BodyRequestBuilder body(InputStream stream) {
        return this.body(stream, null);
    }

    protected BodyRequestBuilder body(InputStream stream, String contentType) {
        if (stream != null) {
            String type = contentType;
            if (type == null) {
                type = "application/octet-stream";
            }
            ((HttpEntityEnclosingRequestBase)this.request).setEntity(new InputStreamEntity(stream));
            this.request.addHeader("Content-Type", type);
        }
        return this;
    }

    protected BodyRequestBuilder body(File file, String contentType) throws IOException {
        return this.body(new FileInputStream(file), contentType);
    }

    protected BodyRequestBuilder digest(String digest) {
        if (digest != null) {
            this.request.addHeader("digest", "sha1=" + digest);
        }
        return this;
    }

    public BodyRequestBuilder ifUnmodifiedSince(String modified) {
        if (modified != null) {
            this.request.setHeader("If-Unmodified-Since", modified);
        }
        return this;
    }

    protected BodyRequestBuilder ifMatch(String etag) {
        if (etag != null) {
            this.request.setHeader("If-Match", etag);
        }
        return this;
    }
}

