/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.fcrepo.client.CopyBuilder;
import org.fcrepo.client.DeleteBuilder;
import org.fcrepo.client.FcrepoHttpClientBuilder;
import org.fcrepo.client.FcrepoOperationFailedException;
import org.fcrepo.client.FcrepoResponse;
import org.fcrepo.client.GetBuilder;
import org.fcrepo.client.HeadBuilder;
import org.fcrepo.client.MoveBuilder;
import org.fcrepo.client.OptionsBuilder;
import org.fcrepo.client.PatchBuilder;
import org.fcrepo.client.PostBuilder;
import org.fcrepo.client.PutBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FcrepoClient {
    private CloseableHttpClient httpclient;
    private Boolean throwExceptionOnFailure = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(FcrepoClient.class);

    public static FcrepoClientBuilder client() {
        return new FcrepoClientBuilder();
    }

    protected FcrepoClient(String username, String password, String host, Boolean throwExceptionOnFailure) {
        FcrepoHttpClientBuilder client = new FcrepoHttpClientBuilder(username, password, host);
        this.throwExceptionOnFailure = throwExceptionOnFailure;
        this.httpclient = client.build();
    }

    public PutBuilder put(URI url) throws FcrepoOperationFailedException {
        return new PutBuilder(url, this);
    }

    public PatchBuilder patch(URI url) throws FcrepoOperationFailedException {
        return new PatchBuilder(url, this);
    }

    public PostBuilder post(URI url) throws FcrepoOperationFailedException {
        return new PostBuilder(url, this);
    }

    public DeleteBuilder delete(URI url) throws FcrepoOperationFailedException {
        return new DeleteBuilder(url, this);
    }

    public CopyBuilder copy(URI source, URI destination) throws FcrepoOperationFailedException {
        return new CopyBuilder(source, destination, this);
    }

    public MoveBuilder move(URI source, URI destination) throws FcrepoOperationFailedException {
        return new MoveBuilder(source, destination, this);
    }

    public GetBuilder get(URI url) throws FcrepoOperationFailedException {
        return new GetBuilder(url, this);
    }

    public HeadBuilder head(URI url) throws FcrepoOperationFailedException {
        return new HeadBuilder(url, this);
    }

    public OptionsBuilder options(URI url) throws FcrepoOperationFailedException {
        return new OptionsBuilder(url, this);
    }

    public FcrepoResponse executeRequest(URI url, HttpRequestBase request) throws FcrepoOperationFailedException {
        LOGGER.debug("Fcrepo {} request to resource {}", (Object)request.getMethod(), (Object)url);
        CloseableHttpResponse response = this.executeRequest(request);
        return this.fcrepoGenericResponse(url, response, this.throwExceptionOnFailure);
    }

    private CloseableHttpResponse executeRequest(HttpRequestBase request) throws FcrepoOperationFailedException {
        try {
            return this.httpclient.execute(request);
        }
        catch (IOException ex) {
            LOGGER.debug("HTTP Operation failed: ", ex);
            throw new FcrepoOperationFailedException(request.getURI(), -1, ex.getMessage());
        }
    }

    private FcrepoResponse fcrepoGenericResponse(URI url, CloseableHttpResponse response, Boolean throwExceptionOnFailure) throws FcrepoOperationFailedException {
        int status = response.getStatusLine().getStatusCode();
        Map<String, List<String>> headers = FcrepoClient.getHeaders(response);
        if (status >= 200 && status < 400 || !throwExceptionOnFailure.booleanValue()) {
            return new FcrepoResponse(url, status, headers, FcrepoClient.getEntityContent(response));
        }
        this.free(response);
        throw new FcrepoOperationFailedException(url, status, response.getStatusLine().getReasonPhrase());
    }

    private void free(CloseableHttpResponse response) {
        try {
            response.close();
        }
        catch (IOException e2) {
            LOGGER.warn("Unable to close HTTP response.", e2);
        }
    }

    private static InputStream getEntityContent(HttpResponse response) {
        try {
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                return null;
            }
            return entity.getContent();
        }
        catch (IOException ex) {
            LOGGER.debug("Unable to extract HttpEntity response into an InputStream: ", ex);
            return null;
        }
    }

    private static Map<String, List<String>> getHeaders(HttpResponse response) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        for (Header header : response.getAllHeaders()) {
            List<String> values;
            if (headers.containsKey(header.getName())) {
                values = (List)headers.get(header.getName());
            } else {
                values = new ArrayList();
                headers.put(header.getName(), values);
            }
            values.add(header.getValue());
        }
        return headers;
    }

    public static class FcrepoClientBuilder {
        private String authUser;
        private String authPassword;
        private String authHost;
        private boolean throwExceptionOnFailure;

        public FcrepoClientBuilder credentials(String username, String password) {
            this.authUser = username;
            this.authPassword = password;
            return this;
        }

        public FcrepoClientBuilder authScope(String authHost) {
            this.authHost = authHost;
            return this;
        }

        public FcrepoClientBuilder throwExceptionOnFailure() {
            this.throwExceptionOnFailure = true;
            return this;
        }

        public FcrepoClient build() {
            return new FcrepoClient(this.authUser, this.authPassword, this.authHost, this.throwExceptionOnFailure);
        }
    }
}

