/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import org.apache.http.client.methods.HttpRequestBase;
import org.fcrepo.client.BodyRequestBuilder;
import org.fcrepo.client.FcrepoClient;
import org.fcrepo.client.FcrepoOperationFailedException;
import org.fcrepo.client.HttpMethods;

public class PostBuilder
extends BodyRequestBuilder {
    public PostBuilder(URI uri, FcrepoClient client) {
        super(uri, client);
    }

    @Override
    protected HttpRequestBase createRequest() {
        return HttpMethods.POST.createRequest(this.targetUri);
    }

    @Override
    public PostBuilder body(InputStream stream, String contentType) {
        return (PostBuilder)super.body(stream, contentType);
    }

    @Override
    public PostBuilder body(File file, String contentType) throws IOException {
        return (PostBuilder)super.body(file, contentType);
    }

    @Override
    public PostBuilder body(InputStream stream) {
        return (PostBuilder)super.body(stream);
    }

    @Override
    public PostBuilder digest(String digest) {
        return (PostBuilder)super.digest(digest);
    }

    public PostBuilder filename(String filename) throws FcrepoOperationFailedException {
        if (filename != null) {
            try {
                String encodedFilename = URLEncoder.encode(filename, "utf-8");
                String disposition = "attachment; filename=\"" + encodedFilename + "\"";
                this.request.addHeader("Content-Disposition", disposition);
            }
            catch (UnsupportedEncodingException e2) {
                throw new FcrepoOperationFailedException(this.request.getURI(), -1, e2.getMessage());
            }
        }
        return this;
    }

    public PostBuilder slug(String slug) {
        if (slug != null) {
            this.request.addHeader("Slug", slug);
        }
        return this;
    }
}

