/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fcrepo.migration.DatastreamVersion;
import org.fcrepo.migration.FedoraObjectHandler;
import org.fcrepo.migration.FedoraObjectVersionHandler;
import org.fcrepo.migration.ObjectInfo;
import org.fcrepo.migration.ObjectProperties;
import org.fcrepo.migration.ObjectReference;
import org.fcrepo.migration.ObjectVersionReference;

public class VersionAbstractionFedoraObjectHandler
implements FedoraObjectHandler {
    private FedoraObjectVersionHandler handler;

    public VersionAbstractionFedoraObjectHandler(FedoraObjectVersionHandler versionHandler) {
        this.handler = versionHandler;
    }

    @Override
    public void processObject(final ObjectReference object) {
        final Map<String, List<DatastreamVersion>> versionMap = this.buildVersionMap(object);
        final ArrayList<String> versionDates = new ArrayList<String>(versionMap.keySet());
        Collections.sort(versionDates);
        ArrayList<ObjectVersionReference> versions = new ArrayList<ObjectVersionReference>();
        for (final String versionDate : versionDates) {
            versions.add(new ObjectVersionReference(){

                @Override
                public ObjectReference getObject() {
                    return object;
                }

                @Override
                public ObjectInfo getObjectInfo() {
                    return object.getObjectInfo();
                }

                @Override
                public ObjectProperties getObjectProperties() {
                    return object.getObjectProperties();
                }

                @Override
                public String getVersionDate() {
                    return versionDate;
                }

                @Override
                public List<DatastreamVersion> listChangedDatastreams() {
                    return (List)versionMap.get(versionDate);
                }

                @Override
                public boolean isLastVersion() {
                    return ((String)versionDates.get(versionDates.size() - 1)).equals(versionDate);
                }

                @Override
                public boolean isFirstVersion() {
                    return ((String)versionDates.get(0)).equals(versionDate);
                }

                @Override
                public int getVersionIndex() {
                    return versionDates.indexOf(versionDate);
                }

                @Override
                public boolean wasDatastreamChanged(String dsId) {
                    for (DatastreamVersion v : this.listChangedDatastreams()) {
                        if (!v.getDatastreamInfo().getDatastreamId().equals(dsId)) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        this.handler.processObjectVersions(versions);
    }

    private Map<String, List<DatastreamVersion>> buildVersionMap(ObjectReference object) {
        HashMap<String, List<DatastreamVersion>> versionMap = new HashMap<String, List<DatastreamVersion>>();
        for (String dsId : object.listDatastreamIds()) {
            for (DatastreamVersion v : object.getDatastreamVersions(dsId)) {
                String date2 = v.getCreated();
                ArrayList<DatastreamVersion> versionsForDate = (ArrayList<DatastreamVersion>)versionMap.get(date2);
                if (versionsForDate == null) {
                    versionsForDate = new ArrayList<DatastreamVersion>();
                    versionMap.put(date2, versionsForDate);
                }
                versionsForDate.add(v);
            }
        }
        return versionMap;
    }
}

