/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.handlers;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.modify.request.QuadAcc;
import com.hp.hpl.jena.sparql.modify.request.QuadDataAcc;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataInsert;
import com.hp.hpl.jena.sparql.modify.request.UpdateDeleteWhere;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.fcrepo.migration.DatastreamVersion;
import org.fcrepo.migration.ExternalContentURLMapper;
import org.fcrepo.migration.Fedora4Client;
import org.fcrepo.migration.FedoraObjectVersionHandler;
import org.fcrepo.migration.MigrationIDMapper;
import org.fcrepo.migration.ObjectProperty;
import org.fcrepo.migration.ObjectReference;
import org.fcrepo.migration.ObjectVersionReference;
import org.fcrepo.migration.foxml.DC;
import org.fcrepo.migration.foxml.NamespacePrefixMapper;
import org.fcrepo.migration.urlmappers.SelfReferencingURLMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicObjectVersionHandler
implements FedoraObjectVersionHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(BasicObjectVersionHandler.class);
    private static int suffix = 0;
    private Fedora4Client f4client;
    private MigrationIDMapper idMapper;
    private boolean importExternal;
    private boolean importRedirect;
    private ExternalContentURLMapper externalContentUrlMapper;
    private NamespacePrefixMapper namespacePrefixMapper;
    private boolean skipDisseminators = false;
    private Properties customPropertyMapping;

    public BasicObjectVersionHandler(Fedora4Client client, MigrationIDMapper idMapper, String localFedoraServer, NamespacePrefixMapper namespacePrefixMapper) {
        this.f4client = client;
        this.idMapper = idMapper;
        this.externalContentUrlMapper = new SelfReferencingURLMapper(localFedoraServer, idMapper);
        this.namespacePrefixMapper = namespacePrefixMapper;
        ErrorHandlerFactory.setDefaultErrorHandler((ErrorHandler)ErrorHandlerFactory.errorHandlerWarn);
    }

    public void setImportExternal(boolean value) {
        this.importExternal = value;
    }

    public void setImportRedirect(boolean value) {
        this.importRedirect = value;
    }

    public void setCustomPropertyMapping(File propertiesFile) {
        this.customPropertyMapping = new Properties();
        try (FileInputStream fis = new FileInputStream(propertiesFile);){
            this.customPropertyMapping.load(fis);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("The file, \"" + propertiesFile.getAbsolutePath() + "\" , specified in the 'customPropertyMapping' property was not found!", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error access the file, \"" + propertiesFile.getAbsolutePath() + "\" , specified in the 'customPropertyMapping' property!", e);
        }
    }

    public void setSkipDisseminators(boolean skip) {
        this.skipDisseminators = skip;
    }

    @Override
    public void processObjectVersions(Iterable<ObjectVersionReference> versions) {
        String objectPath = null;
        try {
            for (ObjectVersionReference version : versions) {
                LOGGER.debug("Considering object " + version.getObjectInfo().getPid() + " version at " + version.getVersionDate() + ".");
                if (objectPath == null) {
                    if (!this.skipDisseminators && version.getObject().hadFedora2Disseminators()) {
                        throw new RuntimeException("Fedora 2 disseminators are not supported, set \"skipDisseminators\" to true to migration this object without the disseminators!");
                    }
                    objectPath = this.idMapper.mapObjectPath(version.getObjectInfo().getPid());
                    if (!this.f4client.exists(objectPath)) {
                        this.f4client.createPlaceholder(objectPath);
                    } else if (!this.f4client.isPlaceholder(objectPath)) {
                        LOGGER.warn(objectPath + " already exists, skipping migration of " + version.getObject().getObjectInfo().getPid() + "!");
                        return;
                    }
                }
                QuadDataAcc triplesToInsert = new QuadDataAcc();
                QuadAcc triplesToRemove = new QuadAcc();
                for (DatastreamVersion v : this.withRELSINTLast(version.listChangedDatastreams())) {
                    LOGGER.debug("Considering changed datastream version " + v.getVersionId());
                    String dsPath = this.idMapper.mapDatastreamPath(v.getDatastreamInfo().getObjectInfo().getPid(), v.getDatastreamInfo().getDatastreamId());
                    if (v.getDatastreamInfo().getDatastreamId().equals("DC")) {
                        this.migrateDc(v, triplesToRemove, triplesToInsert);
                        continue;
                    }
                    if (v.getDatastreamInfo().getDatastreamId().equals("RELS-EXT")) {
                        this.migrateRelsExt(v, triplesToRemove, triplesToInsert);
                        continue;
                    }
                    if (v.getDatastreamInfo().getDatastreamId().equals("RELS-INT")) {
                        this.migrateRelsInt(v);
                        continue;
                    }
                    if (v.getDatastreamInfo().getControlGroup().equals("E") && !this.importExternal || v.getDatastreamInfo().getControlGroup().equals("R") && !this.importRedirect) {
                        this.f4client.createOrUpdateRedirectNonRDFResource(dsPath, this.externalContentUrlMapper.mapURL(v.getExternalOrRedirectURL()));
                        this.updateDatastreamProperties(version.getObject(), v, dsPath);
                        continue;
                    }
                    this.f4client.createOrUpdateNonRDFResource(dsPath, v.getContent(), v.getMimeType());
                    this.updateDatastreamProperties(version.getObject(), v, dsPath);
                }
                this.updateObjectProperties(version, objectPath, triplesToRemove, triplesToInsert);
                this.f4client.createVersionSnapshot(objectPath, "imported-version-" + String.valueOf(version.getVersionIndex()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<DatastreamVersion> withRELSINTLast(List<DatastreamVersion> orig) {
        ArrayList<DatastreamVersion> versionsWithRELSINTLast = new ArrayList<DatastreamVersion>(orig);
        for (int i = 0; i < versionsWithRELSINTLast.size(); ++i) {
            if (!((DatastreamVersion)versionsWithRELSINTLast.get(i)).getDatastreamInfo().getDatastreamId().equals("RELS-INT")) continue;
            versionsWithRELSINTLast.add((DatastreamVersion)versionsWithRELSINTLast.remove(i));
            break;
        }
        return versionsWithRELSINTLast;
    }

    protected boolean isDateProperty(String uri) {
        return uri.equals("info:fedora/fedora-system:def/model#createdDate") || uri.equals("info:fedora/fedora-system:def/view#lastModifiedDate") || uri.equals("http://www.loc.gov/premis/rdf/v1#hasDateCreatedByApplication") || uri.equals("http://www.loc.gov/premis/rdf/v1#hasEventDateTime");
    }

    protected void updateObjectProperties(ObjectVersionReference version, String objectPath, QuadAcc triplesToRemove, QuadDataAcc triplesToInsert) {
        if (version.isFirstVersion()) {
            String now = this.getCurrentTimeInXSDDateTime();
            if (now != null) {
                this.addDateEvent(triplesToInsert, "http://id.loc.gov/vocabulary/preservation/eventType/mig", this.getCurrentTimeInXSDDateTime());
            }
            this.mapProperty("info:fedora/fedora-system:def/model#PID", version.getObject().getObjectInfo().getPid(), triplesToRemove, triplesToInsert, true);
        }
        if (version.isLastVersion()) {
            for (ObjectProperty objectProperty : version.getObjectProperties().listProperties()) {
                this.mapProperty(objectProperty.getName(), objectProperty.getValue(), triplesToRemove, triplesToInsert, true);
            }
        }
        if (!triplesToInsert.getQuads().isEmpty() && !triplesToRemove.getQuads().isEmpty()) {
            this.updateResourceProperties(objectPath, triplesToRemove, triplesToInsert, false);
        }
    }

    protected void mapProperty(String origPred, String obj, QuadAcc triplesToRemove, QuadDataAcc triplesToInsert, Boolean isLiteral) {
        String pred = origPred;
        if (this.customPropertyMapping != null && this.customPropertyMapping.containsKey(pred)) {
            pred = this.customPropertyMapping.getProperty(pred);
        } else {
            if (pred.equals("info:fedora/fedora-system:def/model#createdDate")) {
                this.updateDateTriple(triplesToRemove, triplesToInsert, "http://fedora.info/definitions/v4/repository#created", obj);
                return;
            }
            if (pred.equals("info:fedora/fedora-system:def/view#lastModifiedDate")) {
                this.updateDateTriple(triplesToRemove, triplesToInsert, "http://fedora.info/definitions/v4/repository#lastModified", obj);
                return;
            }
        }
        if (this.isDateProperty(origPred)) {
            this.updateDateTriple(triplesToRemove, triplesToInsert, pred, obj);
        } else if (isLiteral.booleanValue()) {
            this.updateLiteralTriple(triplesToRemove, triplesToInsert, pred, obj);
        } else {
            this.updateUriTriple(triplesToRemove, triplesToInsert, pred, obj);
        }
    }

    protected void updateDatastreamProperties(ObjectReference obj, DatastreamVersion v, String dsPath) {
        QuadDataAcc triplesToInsert = new QuadDataAcc();
        QuadAcc triplesToRemove = new QuadAcc();
        String createdDate = v.getCreated();
        if (v.isFirstVersionIn(obj)) {
            String now = this.getCurrentTimeInXSDDateTime();
            if (now != null) {
                this.addDateEvent(triplesToInsert, "http://id.loc.gov/vocabulary/preservation/eventType/mig", this.getCurrentTimeInXSDDateTime());
            }
            if (createdDate != null) {
                LOGGER.debug("Setting created date to " + createdDate + "...");
                this.updateDateTriple(triplesToRemove, triplesToInsert, "http://fedora.info/definitions/v4/repository#created", createdDate);
            }
        }
        if (v.isLastVersionIn(obj)) {
            String formatUri;
            String state;
            String label;
            String dsid = v.getDatastreamInfo().getDatastreamId();
            if (dsid != null) {
                this.updateLiteralTriple(triplesToRemove, triplesToInsert, "http://purl.org/dc/terms/identifier", dsid);
            }
            if (createdDate != null) {
                this.updateDateTriple(triplesToRemove, triplesToInsert, "http://fedora.info/definitions/v4/repository#lastModified", createdDate);
            }
            if ((label = v.getLabel()) != null) {
                this.updateLiteralTriple(triplesToRemove, triplesToInsert, "http://purl.org/dc/terms/title", label);
            }
            if ((state = v.getDatastreamInfo().getState()) != null) {
                this.updateLiteralTriple(triplesToRemove, triplesToInsert, "http://fedora.info/definitions/1/0/access/objState", state);
            }
            if ((formatUri = v.getFormatUri()) != null) {
                this.updateLiteralTriple(triplesToRemove, triplesToInsert, "http://www.loc.gov/premis/rdf/v1#formatDesignation", formatUri);
            }
        }
        if (!triplesToInsert.getQuads().isEmpty() && !triplesToRemove.getQuads().isEmpty()) {
            this.updateResourceProperties(dsPath, triplesToRemove, triplesToInsert, true);
        }
    }

    protected void migrateRelsExt(DatastreamVersion v, QuadAcc triplesToRemove, QuadDataAcc triplesToInsert) throws IOException {
        String objectUri = "info:fedora/" + v.getDatastreamInfo().getObjectInfo().getPid();
        Model m = ModelFactory.createDefaultModel();
        m.read(v.getContent(), null);
        StmtIterator statementIt = m.listStatements();
        while (statementIt.hasNext()) {
            Statement s = statementIt.nextStatement();
            if (s.getSubject().getURI().equals(objectUri)) {
                String predicateUri = s.getPredicate().getURI();
                if (s.getObject().isLiteral()) {
                    this.mapProperty(predicateUri, s.getObject().asLiteral().getString(), triplesToRemove, triplesToInsert, true);
                    continue;
                }
                if (s.getObject().isURIResource()) {
                    this.mapProperty(predicateUri, s.getObject().asResource().getURI(), triplesToRemove, triplesToInsert, false);
                    continue;
                }
                throw new RuntimeException("No current handling for non-URI, non-Literal subjects in Fedora RELS-INT.");
            }
            throw new RuntimeException("Non-resource subject found: " + s.getSubject().getURI());
        }
    }

    protected void migrateRelsInt(DatastreamVersion v) throws IOException, RuntimeException {
        Model m = ModelFactory.createDefaultModel();
        m.read(v.getContent(), null);
        StmtIterator statementIt = m.listStatements();
        while (statementIt.hasNext()) {
            Statement s = statementIt.nextStatement();
            String dsUri = s.getSubject().getURI();
            String[] splitUri = dsUri.split("/");
            String dsId = splitUri[splitUri.length - 1];
            String dsPath = this.idMapper.mapDatastreamPath(v.getDatastreamInfo().getObjectInfo().getPid(), dsId);
            if (!this.f4client.exists(dsPath)) {
                this.f4client.createNonRDFPlaceholder(dsPath);
                LOGGER.warn("The datastream \"" + dsId + "\" referenced in the RDF datastream \"" + v.getDatastreamInfo().getDatastreamId() + "\" on " + v.getDatastreamInfo().getObjectInfo().getPid() + " did not exist at " + v.getCreated() + ", making a placeholder!");
            }
            QuadDataAcc triplesToInsert = new QuadDataAcc();
            QuadAcc triplesToRemove = new QuadAcc();
            String pred = s.getPredicate().getURI();
            if (s.getObject().isLiteral()) {
                this.mapProperty(pred, s.getObject().asLiteral().getString(), triplesToRemove, triplesToInsert, true);
            } else if (s.getObject().isURIResource()) {
                this.mapProperty(pred, s.getObject().asResource().getURI(), triplesToRemove, triplesToInsert, false);
            } else {
                throw new RuntimeException("No current handling for non-URI, non-Literal subjects in Fedora RELS-INT.");
            }
            this.updateResourceProperties(dsPath, triplesToRemove, triplesToInsert, true);
        }
    }

    protected void migrateDc(DatastreamVersion v, QuadAcc triplesToRemove, QuadDataAcc triplesToInsert) throws IOException, RuntimeException {
        try {
            DC dc = DC.parseDC(v.getContent());
            for (String uri : dc.getRepresentedElementURIs()) {
                triplesToRemove.addTriple(new Triple(NodeFactory.createURI((String)""), NodeFactory.createURI((String)uri), NodeFactory.createVariable((String)"o")));
                for (String value : dc.getValuesForURI(uri)) {
                    triplesToInsert.addTriple(new Triple(NodeFactory.createURI((String)""), NodeFactory.createURI((String)uri), NodeFactory.createLiteral((String)value)));
                    LOGGER.debug("Adding " + uri + " value " + value);
                }
            }
        }
        catch (JAXBException e) {
            throw new RuntimeException("Error parsing DC datastream " + v.getVersionId());
        }
    }

    protected void updateResourceProperties(String path, QuadAcc triplesToRemove, QuadDataAcc triplesToInsert, boolean isNonRDF) throws RuntimeException {
        try {
            UpdateRequest updateRequest = UpdateFactory.create();
            this.namespacePrefixMapper.setPrefixes(updateRequest);
            updateRequest.add((Update)new UpdateDeleteWhere(triplesToRemove));
            updateRequest.add((Update)new UpdateDataInsert(triplesToInsert));
            ByteArrayOutputStream sparqlUpdate = new ByteArrayOutputStream();
            updateRequest.output(new IndentedWriter((OutputStream)sparqlUpdate));
            LOGGER.trace("SPARQL: " + sparqlUpdate.toString("UTF-8"));
            if (isNonRDF) {
                this.f4client.updateNonRDFResourceProperties(path, sparqlUpdate.toString("UTF-8"));
            } else {
                this.f4client.updateResourceProperties(path, sparqlUpdate.toString("UTF-8"));
            }
            suffix = 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void updateLiteralTriple(QuadAcc triplesToRemove, QuadDataAcc triplesToInsert, String predicate, String object) {
        triplesToRemove.addTriple(new Triple(NodeFactory.createURI((String)""), NodeFactory.createURI((String)predicate), NodeFactory.createVariable((String)("o" + String.valueOf(suffix)))));
        triplesToInsert.addTriple(new Triple(NodeFactory.createURI((String)""), NodeFactory.createURI((String)predicate), NodeFactory.createLiteral((String)object)));
        ++suffix;
    }

    protected void updateUriTriple(QuadAcc triplesToRemove, QuadDataAcc triplesToInsert, String predicate, String object) {
        String newObjectUri = this.resolveInternalURI(object);
        triplesToRemove.addTriple(new Triple(NodeFactory.createURI((String)""), NodeFactory.createURI((String)predicate), NodeFactory.createVariable((String)("o" + String.valueOf(suffix)))));
        triplesToInsert.addTriple(new Triple(NodeFactory.createURI((String)""), NodeFactory.createURI((String)predicate), NodeFactory.createURI((String)newObjectUri)));
        ++suffix;
    }

    protected String resolveInternalURI(String uri) {
        if (uri.startsWith("info:fedora/")) {
            String path = this.idMapper.mapObjectPath(uri.substring("info:fedora/".length()));
            this.f4client.createPlaceholder(path);
            return this.f4client.getRepositoryUrl() + path;
        }
        return uri;
    }

    protected void updateDateTriple(QuadAcc triplesToRemove, QuadDataAcc triplesToInsert, String predicate, String object) {
        triplesToRemove.addTriple(new Triple(NodeFactory.createURI((String)""), NodeFactory.createURI((String)predicate), NodeFactory.createVariable((String)("o" + String.valueOf(suffix)))));
        triplesToInsert.addTriple(new Triple(NodeFactory.createURI((String)""), NodeFactory.createURI((String)predicate), NodeFactory.createLiteral((String)object, (RDFDatatype)XSDDatatype.XSDdateTime)));
        ++suffix;
    }

    protected void addDateEvent(QuadDataAcc triplesToInsert, String eventTypeURI, String object) {
        String eventPred = "http://www.loc.gov/premis/rdf/v1#hasEvent";
        String eventTypePred = "http://www.loc.gov/premis/rdf/v1#hasEventType";
        String eventDatePred = "http://www.loc.gov/premis/rdf/v1#hasEventDateTime";
        Node bnode = NodeFactory.createAnon();
        triplesToInsert.addTriple(new Triple(NodeFactory.createURI((String)""), NodeFactory.createURI((String)"http://www.loc.gov/premis/rdf/v1#hasEvent"), bnode));
        triplesToInsert.addTriple(new Triple(bnode, NodeFactory.createURI((String)"http://www.loc.gov/premis/rdf/v1#hasEventType"), NodeFactory.createURI((String)eventTypeURI)));
        triplesToInsert.addTriple(new Triple(bnode, NodeFactory.createURI((String)"http://www.loc.gov/premis/rdf/v1#hasEventDateTime"), NodeFactory.createLiteral((String)object, (RDFDatatype)XSDDatatype.XSDdateTime)));
    }

    protected String getCurrentTimeInXSDDateTime() {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(new Date());
            XMLGregorianCalendar now = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
            return now.toString();
        }
        catch (DatatypeConfigurationException e) {
            LOGGER.error("Error converting date object to proper format!", (Throwable)e);
            return null;
        }
    }
}

