/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmdline.ArgDecl;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import arq.cmdline.ModBase;
import com.hp.hpl.jena.shared.uuid.JenaUUID;
import com.hp.hpl.jena.shared.uuid.UUID_V1_Gen;
import com.hp.hpl.jena.shared.uuid.UUID_V4_Gen;

public class juuid
extends CmdGeneral {
    ModJUUID modJUUID = new ModJUUID();
    int number = 1;
    boolean resetEachTime = false;
    int uuidType = 0;
    boolean asURN = false;
    boolean asURI = false;
    boolean asPlain = false;
    static ArgDecl argDeclNum = new ArgDecl(true, "num", "n");
    static ArgDecl argDeclReset = new ArgDecl(false, "reset", new String[0]);
    static ArgDecl argDeclGen = new ArgDecl(true, "gen", "scheme", "type", "ver");
    static ArgDecl argDeclURN = new ArgDecl(false, "urn", new String[0]);
    static ArgDecl argDeclURI = new ArgDecl(false, "uri", new String[0]);
    static ArgDecl argDeclPlain = new ArgDecl(false, "plain", new String[0]);

    public static void main(String[] argv) {
        new juuid(argv).mainAndExit();
    }

    private juuid(String[] argv) {
        super(argv);
        super.addModule(this.modJUUID);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " [--num=N] [--reset] [--type={1|4}]";
    }

    @Override
    protected void exec() {
        if (this.uuidType == 1) {
            JenaUUID.setFactory(new UUID_V1_Gen());
        }
        if (this.uuidType == 4) {
            JenaUUID.setFactory(new UUID_V4_Gen());
        }
        for (int i = 0; i < this.number; ++i) {
            if (this.resetEachTime && i != 0) {
                JenaUUID.reset();
            }
            JenaUUID uuid2 = JenaUUID.generate();
            String str2 = null;
            if (this.asURN) {
                str2 = uuid2.asURN();
            } else if (this.asURI) {
                str2 = uuid2.asURI();
            } else if (this.asPlain) {
                str2 = uuid2.asString();
            }
            if (str2 == null) {
                str2 = uuid2.asString();
            }
            System.out.println(str2);
        }
    }

    @Override
    protected String getCommandName() {
        return "uuid";
    }

    @Override
    protected void processModulesAndArgs() {
    }

    class ModJUUID
    extends ModBase {
        ModJUUID() {
        }

        @Override
        public void registerWith(CmdGeneral cmdLine) {
            cmdLine.add(argDeclNum);
            cmdLine.add(argDeclReset);
            cmdLine.add(argDeclGen);
            cmdLine.add(argDeclURN);
            cmdLine.add(argDeclURI);
            cmdLine.add(argDeclPlain);
        }

        @Override
        public void processArgs(CmdArgModule cmdLine) {
            String numStr = null;
            if (juuid.this.getNumPositional() > 1) {
                juuid.this.cmdError("Too many positional arguments");
            }
            if (cmdLine.contains(argDeclNum)) {
                if (juuid.this.getNumPositional() != 0) {
                    juuid.this.cmdError("--num and positional arguments don't go together");
                }
                numStr = juuid.this.getValue(argDeclNum);
            }
            if (numStr == null && cmdLine.getNumPositional() == 1) {
                numStr = cmdLine.getPositionalArg(0);
            }
            if (numStr != null) {
                try {
                    juuid.this.number = Integer.parseInt(numStr);
                    if (juuid.this.number < 0 || juuid.this.number > 10000) {
                        cmdLine.cmdError("Number out of range:" + numStr);
                    }
                }
                catch (NumberFormatException e2) {
                    cmdLine.cmdError("Bad argument: " + numStr);
                }
            }
            juuid.this.resetEachTime = cmdLine.contains(argDeclReset);
            if (juuid.this.contains(argDeclGen)) {
                String s2 = juuid.this.getValue(argDeclGen);
                if (s2.equalsIgnoreCase("time") || s2.equalsIgnoreCase("1")) {
                    juuid.this.uuidType = 1;
                } else if (s2.equalsIgnoreCase("random") || s2.equalsIgnoreCase("rand") || s2.equalsIgnoreCase("4")) {
                    juuid.this.uuidType = 4;
                } else {
                    juuid.this.cmdError("Unrecognized UUID scheme: " + s2);
                }
            }
            if (juuid.this.contains(argDeclURN) || juuid.this.contains(argDeclURI) || juuid.this.contains(argDeclPlain)) {
                juuid.this.asURN = juuid.this.contains(argDeclURN);
                juuid.this.asURI = juuid.this.contains(argDeclURI);
                juuid.this.asPlain = juuid.this.contains(argDeclPlain);
            } else {
                juuid.this.asURN = true;
                juuid.this.asURI = false;
                juuid.this.asPlain = false;
            }
        }
    }
}

