/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.base.UnsafeAccess;
import com.github.benmanes.caffeine.cache.FWA;
import com.github.benmanes.caffeine.cache.Node;
import java.lang.ref.ReferenceQueue;

class FWAR<K, V>
extends FWA<K, V> {
    protected static final long WRITE_TIME_OFFSET = UnsafeAccess.objectFieldOffset(FWAR.class, "writeTime");
    volatile long writeTime;

    FWAR() {
    }

    FWAR(K key, ReferenceQueue<K> keyReferenceQueue, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now2) {
        super(key, keyReferenceQueue, value, valueReferenceQueue, weight, now2);
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, now2);
    }

    FWAR(Object keyReference, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now2) {
        super(keyReference, value, valueReferenceQueue, weight, now2);
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, now2);
    }

    @Override
    public final long getWriteTime() {
        return UnsafeAccess.UNSAFE.getLong(this, WRITE_TIME_OFFSET);
    }

    @Override
    public final void setWriteTime(long writeTime) {
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, writeTime);
    }

    @Override
    public final boolean casWriteTime(long expect, long update2) {
        return this.writeTime == expect && UnsafeAccess.UNSAFE.compareAndSwapLong(this, WRITE_TIME_OFFSET, expect, update2);
    }

    @Override
    public Node<K, V> newNode(K key, ReferenceQueue<K> keyReferenceQueue, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now2) {
        return new FWAR<K, V>(key, keyReferenceQueue, value, valueReferenceQueue, weight, now2);
    }

    @Override
    public Node<K, V> newNode(Object keyReference, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now2) {
        return new FWAR<K, V>(keyReference, value, valueReferenceQueue, weight, now2);
    }
}

