/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import com.hp.hpl.jena.n3.N3JenaWriter;
import com.hp.hpl.jena.n3.N3JenaWriterCommon;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;

public class N3JenaWriterPP
extends N3JenaWriterCommon {
    protected final boolean doObjectListsAsLists = this.getBooleanValue("objectLists", true);
    protected Set<Resource> rdfLists = null;
    protected Set<Resource> rdfListsAll = null;
    protected Set<Resource> rdfListsDone = null;
    protected Set<RDFNode> oneRefObjects = null;
    protected Set<Resource> oneRefDone = null;
    protected boolean allowDeep = true;
    protected static final String objectListSep = " , ";

    @Override
    protected void prepare(Model model) {
        this.prepareLists(model);
        this.prepareOneRefBNodes(model);
    }

    protected void prepareLists(Model model) {
        HashSet<Resource> thisListAll = new HashSet<Resource>();
        StmtIterator listTailsIter = model.listStatements(null, RDF.rest, RDF.nil);
        while (listTailsIter.hasNext()) {
            boolean isOK;
            Resource listElement = listTailsIter.nextStatement().getSubject();
            Resource validListHead = null;
            while (isOK = this.checkListElement(listElement)) {
                if (N3JenaWriter.DEBUG) {
                    this.out.println("# RDF list all: " + this.formatResource(listElement));
                }
                validListHead = listElement;
                thisListAll.add(listElement);
                StmtIterator sPrev = model.listStatements(null, RDF.rest, listElement);
                if (!sPrev.hasNext()) break;
                listElement = sPrev.nextStatement().getSubject();
                if (!sPrev.hasNext()) continue;
                if (!N3JenaWriter.DEBUG) break;
                this.out.println("# RDF shared tail from " + this.formatResource(listElement));
                break;
            }
            if (N3JenaWriter.DEBUG) {
                this.out.println("# Collection list head: " + this.formatResource(validListHead));
            }
            this.rdfListsAll.addAll(thisListAll);
            if (validListHead == null) continue;
            this.rdfLists.add(validListHead);
        }
        listTailsIter.close();
    }

    protected boolean checkListElement(Resource listElement) {
        if (!listElement.isAnon()) {
            return false;
        }
        if (!listElement.hasProperty(RDF.rest) || !listElement.hasProperty(RDF.first)) {
            if (N3JenaWriter.DEBUG) {
                this.out.println("# RDF list element does not have required properties: " + this.formatResource(listElement));
            }
            return false;
        }
        int numProp = this.countProperties(listElement);
        if (numProp == 2) {
            return true;
        }
        if (N3JenaWriter.DEBUG) {
            this.out.println("# RDF list element does not right number of properties: " + this.formatResource(listElement));
        }
        return false;
    }

    protected void prepareOneRefBNodes(Model model) {
        NodeIterator objIter = model.listObjects();
        while (objIter.hasNext()) {
            RDFNode n = objIter.nextNode();
            if (this.testOneRefBNode(n)) {
                this.oneRefObjects.add(n);
            }
            objIter.close();
            if (!N3JenaWriter.DEBUG) continue;
            this.out.println("# RDF Lists      = " + this.rdfLists.size());
            this.out.println("# RDF ListsAll   = " + this.rdfListsAll.size());
            this.out.println("# oneRefObjects  = " + this.oneRefObjects.size());
        }
    }

    protected boolean testOneRefBNode(RDFNode n) {
        if (!(n instanceof Resource)) {
            return false;
        }
        Resource obj = (Resource)n;
        if (!obj.isAnon()) {
            return false;
        }
        if (this.rdfListsAll.contains(obj)) {
            return false;
        }
        StmtIterator pointsToIter = obj.getModel().listStatements(null, null, obj);
        if (!pointsToIter.hasNext()) {
            throw new JenaException("N3: found object with no arcs!");
        }
        Statement s2 = pointsToIter.nextStatement();
        if (pointsToIter.hasNext()) {
            return false;
        }
        if (N3JenaWriter.DEBUG) {
            this.out.println("# OneRef: " + this.formatResource(obj));
        }
        return true;
    }

    @Override
    protected ClosableIterator<Property> preparePropertiesForSubject(Resource r) {
        HashSet<Property> seen = new HashSet<Property>();
        boolean hasTypes = false;
        TreeMap<String, Property> tmp1 = new TreeMap<String, Property>();
        TreeMap<String, Property> tmp2 = new TreeMap<String, Property>();
        StmtIterator sIter = r.listProperties();
        while (sIter.hasNext()) {
            Property p = sIter.nextStatement().getPredicate();
            if (seen.contains(p)) continue;
            seen.add(p);
            if (p.equals(RDF.type)) {
                hasTypes = true;
                continue;
            }
            if (p.getURI().startsWith(RDF.getURI()) || p.getURI().startsWith(RDFS.getURI())) {
                tmp1.put(p.getURI(), p);
                continue;
            }
            tmp2.put(p.getURI(), p);
        }
        sIter.close();
        ExtendedIterator<Property> eIter = null;
        if (hasTypes) {
            eIter = new SingletonIterator<Property>(RDF.type);
        }
        ExtendedIterator eIter2 = WrappedIterator.create(tmp1.values().iterator());
        eIter = eIter == null ? eIter2 : eIter.andThen(eIter2);
        eIter2 = WrappedIterator.create(tmp2.values().iterator());
        eIter = eIter == null ? eIter2 : eIter.andThen(eIter2);
        return eIter;
    }

    @Override
    protected boolean skipThisSubject(Resource subj) {
        return this.rdfListsAll.contains(subj) || this.oneRefObjects.contains(subj);
    }

    @Override
    protected void startWriting() {
        this.allocateDatastructures();
    }

    @Override
    protected void finishWriting() {
        for (Resource r : this.rdfLists) {
            if (this.rdfListsDone.contains(r)) continue;
            this.out.println();
            if (N3JenaWriter.DEBUG) {
                this.out.println("# RDF List");
            }
            this.writeListUnpretty(r);
        }
        this.oneRefObjects.removeAll(this.oneRefDone);
        for (RDFNode oneRefObject : this.oneRefObjects) {
            this.out.println();
            if (N3JenaWriter.DEBUG) {
                this.out.println("# One ref");
            }
            this.allowDeep = false;
            this.writeOneGraphNode((Resource)oneRefObject);
            this.allowDeep = true;
        }
        this.out.flush();
        this.clearDatastructures();
    }

    @Override
    protected void writeObjectList(Resource subject, Property property) {
        String propStr = this.formatProperty(property);
        StmtIterator sIter = subject.listProperties(property);
        HashSet<RDFNode> simple = new HashSet<RDFNode>();
        HashSet<RDFNode> complex = new HashSet<RDFNode>();
        while (sIter.hasNext()) {
            Statement stmt = sIter.nextStatement();
            RDFNode obj = stmt.getObject();
            if (this.isSimpleObject(obj)) {
                simple.add(obj);
                continue;
            }
            complex.add(obj);
        }
        sIter.close();
        int simpleSize = simple.size();
        int complexSize = complex.size();
        if (simple.size() > 0) {
            RDFNode n;
            Iterator iter;
            String padSp = null;
            if (propStr.length() + this.minGap <= this.widePropertyLen) {
                padSp = N3JenaWriterPP.pad(this.calcPropertyPadding(propStr));
            }
            if (this.doObjectListsAsLists) {
                this.out.print(propStr);
                this.out.incIndent(this.indentObject);
                if (padSp != null) {
                    this.out.print(padSp);
                } else {
                    this.out.println();
                }
                iter = simple.iterator();
                while (iter.hasNext()) {
                    n = (RDFNode)iter.next();
                    this.writeObject(n);
                    if (!iter.hasNext()) continue;
                    this.out.print(objectListSep);
                }
                this.out.decIndent(this.indentObject);
            } else {
                iter = simple.iterator();
                while (iter.hasNext()) {
                    this.out.print(propStr);
                    this.out.incIndent(this.indentObject);
                    if (padSp != null) {
                        this.out.print(padSp);
                    } else {
                        this.out.println();
                    }
                    n = (RDFNode)iter.next();
                    this.writeObject(n);
                    this.out.decIndent(this.indentObject);
                    if (!iter.hasNext()) continue;
                    this.out.println(" ;");
                }
            }
        }
        if (complex.size() > 0) {
            if (simple.size() > 0) {
                this.out.println(" ;");
            }
            int padding = -1;
            String padSp = null;
            int tmp = propStr.length();
            if (propStr.length() + this.minGap <= this.propertyCol) {
                padding = this.calcPropertyPadding(propStr);
                padSp = N3JenaWriterPP.pad(padding);
            }
            Iterator iter = complex.iterator();
            while (iter.hasNext()) {
                int thisIndent = this.indentObject;
                this.out.incIndent(thisIndent);
                this.out.print(propStr);
                if (padSp != null) {
                    this.out.print(padSp);
                } else {
                    this.out.println();
                }
                RDFNode n = (RDFNode)iter.next();
                this.writeObject(n);
                this.out.decIndent(thisIndent);
                if (!iter.hasNext()) continue;
                this.out.println(" ;");
            }
        }
    }

    protected boolean isSimpleObject(RDFNode node) {
        if (node instanceof Literal) {
            return true;
        }
        Resource rObj = (Resource)node;
        return !this.allowDeep || !this.oneRefObjects.contains(rObj);
    }

    @Override
    protected void writeObject(RDFNode node) {
        if (node instanceof Literal) {
            this.writeLiteral((Literal)node);
            return;
        }
        Resource rObj = (Resource)node;
        if (this.allowDeep && !this.isSimpleObject(rObj)) {
            this.oneRefDone.add(rObj);
            ClosableIterator<Property> iter = this.preparePropertiesForSubject(rObj);
            if (!iter.hasNext()) {
                this.out.print("[]");
            } else {
                this.out.print("[ ");
                this.out.incIndent(2);
                this.writePropertiesForSubject(rObj, iter);
                this.out.decIndent(2);
                this.out.println();
                this.out.print("]");
            }
            iter.close();
            return;
        }
        if (this.rdfLists.contains(rObj) && this.countArcsTo(rObj) <= 1) {
            this.writeList(rObj);
            return;
        }
        this.out.print(this.formatResource(rObj));
    }

    protected void writeList(Resource resource) {
        this.out.print("(");
        this.out.incIndent(2);
        boolean listFirst = true;
        Iterator<RDFNode> iter = this.rdfListIterator(resource);
        while (iter.hasNext()) {
            if (!listFirst) {
                this.out.print(" ");
            }
            listFirst = false;
            RDFNode n = iter.next();
            this.writeObject(n);
        }
        this.out.print(")");
        this.out.decIndent(2);
        this.rdfListsDone.add(resource);
    }

    protected void writeListUnpretty(Resource r) {
        Statement s2;
        StmtIterator sIter = r.getModel().listStatements(r, null, (RDFNode)null);
        while (sIter.hasNext()) {
            s2 = (Statement)sIter.next();
            this.writeStatement(s2);
        }
        sIter = r.getModel().listStatements(r, RDF.rest, (RDFNode)null);
        while (sIter.hasNext()) {
            s2 = (Statement)sIter.next();
            RDFNode nextNode = s2.getObject();
            if (nextNode instanceof Resource) {
                Resource r2 = (Resource)nextNode;
                this.writeListUnpretty(r2);
                continue;
            }
            this.writeStatement(s2);
        }
    }

    private void writeStatement(Statement s2) {
        this.out.print(this.formatResource(s2.getSubject()));
        this.out.print(" ");
        this.out.print(this.formatResource(s2.getPredicate()));
        this.out.print(" ");
        this.out.print(this.formatNode(s2.getObject()));
        this.out.println(" .");
    }

    protected void allocateDatastructures() {
        this.rdfLists = new HashSet<Resource>();
        this.rdfListsAll = new HashSet<Resource>();
        this.rdfListsDone = new HashSet<Resource>();
        this.oneRefObjects = new HashSet<RDFNode>();
        this.oneRefDone = new HashSet<Resource>();
    }

    protected void clearDatastructures() {
        this.rdfLists = null;
        this.rdfListsAll = null;
        this.rdfListsDone = null;
        this.oneRefObjects = null;
        this.oneRefDone = null;
    }
}

