/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.FunctionalProperty;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.impl.AbstractProfile;
import com.hp.hpl.jena.ontology.impl.OWLProfile;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class OWLDLProfile
extends OWLProfile {
    protected static Object[][] s_supportsCheckData = new Object[][]{{AllDifferent.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.AllDifferent.asNode());
        }
    }}, {AnnotationProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            Iterator<Resource> i = ((OntModel)((Object)g2)).getProfile().getAnnotationProperties();
            while (i.hasNext()) {
                if (!i.next().asNode().equals(n)) continue;
                return true;
            }
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.AnnotationProperty.asNode());
        }
    }}, {OntClass.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph eg) {
            Graph g2 = eg.asGraph();
            return this.hasType(n, eg, new Resource[]{OWL.Class, OWL.Restriction, RDFS.Class, RDFS.Datatype}) || n.equals(OWL.Thing.asNode()) || n.equals(OWL.Nothing.asNode()) || g2.contains(Node.ANY, RDFS.domain.asNode(), n) || g2.contains(Node.ANY, RDFS.range.asNode(), n) || g2.contains(n, OWL.intersectionOf.asNode(), Node.ANY) || g2.contains(n, OWL.unionOf.asNode(), Node.ANY) || g2.contains(n, OWL.complementOf.asNode(), Node.ANY);
        }
    }}, {DatatypeProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {ObjectProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return this.hasType(n, g2, new Resource[]{OWL.ObjectProperty, OWL.TransitiveProperty, OWL.SymmetricProperty, OWL.InverseFunctionalProperty});
        }
    }}, {FunctionalProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.FunctionalProperty.asNode());
        }
    }}, {InverseFunctionalProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.InverseFunctionalProperty.asNode()) && !g2.asGraph().contains(n, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {RDFList.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return n.equals(RDF.nil.asNode()) || g2.asGraph().contains(n, RDF.type.asNode(), RDF.List.asNode());
        }
    }}, {OntProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return this.hasType(n, g2, new Resource[]{RDF.Property, OWL.ObjectProperty, OWL.DatatypeProperty, OWL.AnnotationProperty, OWL.TransitiveProperty, OWL.SymmetricProperty, OWL.InverseFunctionalProperty, OWL.FunctionalProperty});
        }
    }}, {Ontology.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.Ontology.asNode());
        }
    }}, {Restriction.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode());
        }
    }}, {AllValuesFromRestriction.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLDLProfile.containsSome(g2, n, OWL.allValuesFrom) && OWLDLProfile.containsSome(g2, n, OWL.onProperty);
        }
    }}, {SomeValuesFromRestriction.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLDLProfile.containsSome(g2, n, OWL.someValuesFrom) && OWLDLProfile.containsSome(g2, n, OWL.onProperty);
        }
    }}, {HasValueRestriction.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLDLProfile.containsSome(g2, n, OWL.hasValue) && OWLDLProfile.containsSome(g2, n, OWL.onProperty);
        }
    }}, {CardinalityRestriction.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLDLProfile.containsSome(g2, n, OWL.cardinality) && OWLDLProfile.containsSome(g2, n, OWL.onProperty);
        }
    }}, {MinCardinalityRestriction.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLDLProfile.containsSome(g2, n, OWL.minCardinality) && OWLDLProfile.containsSome(g2, n, OWL.onProperty);
        }
    }}, {MaxCardinalityRestriction.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLDLProfile.containsSome(g2, n, OWL.maxCardinality) && OWLDLProfile.containsSome(g2, n, OWL.onProperty);
        }
    }}, {SymmetricProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.SymmetricProperty.asNode()) && !g2.asGraph().contains(n, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {TransitiveProperty.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return g2.asGraph().contains(n, RDF.type.asNode(), OWL.TransitiveProperty.asNode()) && !g2.asGraph().contains(n, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {Individual.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            if (n.isURI() || n.isBlank()) {
                return !this.hasType(n, g2, new Resource[]{RDFS.Class, RDF.Property, OWL.Class, OWL.ObjectProperty, OWL.DatatypeProperty, OWL.TransitiveProperty, OWL.FunctionalProperty, OWL.InverseFunctionalProperty});
            }
            return false;
        }
    }}, {DataRange.class, new OWLProfile.SupportsCheck(){

        @Override
        public boolean doCheck(Node n, EnhGraph g2) {
            return n.isBlank() && g2.asGraph().contains(n, RDF.type.asNode(), OWL.DataRange.asNode());
        }
    }}};
    private static HashMap<Class<?>, OWLProfile.SupportsCheck> s_supportsChecks = new HashMap();

    @Override
    public String getLabel() {
        return "OWL DL";
    }

    public static boolean containsSome(EnhGraph g2, Node n, Property p) {
        return AbstractProfile.containsSome(g2, n, p);
    }

    @Override
    protected Map<Class<?>, OWLProfile.SupportsCheck> getCheckTable() {
        return s_supportsChecks;
    }

    static {
        for (Object[] aS_supportsCheckData : s_supportsCheckData) {
            s_supportsChecks.put((Class)aS_supportsCheckData[0], (OWLProfile.SupportsCheck)aS_supportsCheckData[1]);
        }
    }
}

