/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class OntologyImpl
extends OntResourceImpl
implements Ontology {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new OntologyImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to Ontology");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile2 = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile2 != null && profile2.isSupported(node, eg, Ontology.class);
        }
    };

    public OntologyImpl(Node n, EnhGraph g2) {
        super(n, g2);
    }

    @Override
    public void setImport(Resource res) {
        this.setPropertyValue(this.getProfile().IMPORTS(), "IMPORTS", res);
    }

    @Override
    public void addImport(Resource res) {
        this.addPropertyValue(this.getProfile().IMPORTS(), "IMPORTS", res);
    }

    @Override
    public OntResource getImport() {
        return this.objectAsResource(this.getProfile().IMPORTS(), "IMPORTS");
    }

    @Override
    public ExtendedIterator<OntResource> listImports() {
        return this.listAs(this.getProfile().IMPORTS(), "IMPORTS", OntResource.class);
    }

    @Override
    public boolean imports(Resource res) {
        return this.hasPropertyValue(this.getProfile().IMPORTS(), "IMPORTS", res);
    }

    @Override
    public void removeImport(Resource res) {
        this.removePropertyValue(this.getProfile().IMPORTS(), "IMPORTS", res);
    }

    @Override
    public void setBackwardCompatibleWith(Resource res) {
        this.setPropertyValue(this.getProfile().BACKWARD_COMPATIBLE_WITH(), "BACKWARD_COMPATIBLE_WITH", res);
    }

    @Override
    public void addBackwardCompatibleWith(Resource res) {
        this.addPropertyValue(this.getProfile().BACKWARD_COMPATIBLE_WITH(), "BACKWARD_COMPATIBLE_WITH", res);
    }

    @Override
    public OntResource getBackwardCompatibleWith() {
        return this.objectAsResource(this.getProfile().BACKWARD_COMPATIBLE_WITH(), "BACKWARD_COMPATIBLE_WITH");
    }

    @Override
    public ExtendedIterator<OntResource> listBackwardCompatibleWith() {
        return this.listAs(this.getProfile().BACKWARD_COMPATIBLE_WITH(), "BACKWARD_COMPATIBLE_WITH", OntResource.class);
    }

    @Override
    public boolean isBackwardCompatibleWith(Resource res) {
        return this.hasPropertyValue(this.getProfile().BACKWARD_COMPATIBLE_WITH(), "BACKWARD_COMPATIBLE_WITH", res);
    }

    @Override
    public void removeBackwardCompatibleWith(Resource res) {
        this.removePropertyValue(this.getProfile().BACKWARD_COMPATIBLE_WITH(), "BACKWARD_COMPATIBLE_WITH", res);
    }

    @Override
    public void setPriorVersion(Resource res) {
        this.setPropertyValue(this.getProfile().PRIOR_VERSION(), "PRIOR_VERSION", res);
    }

    @Override
    public void addPriorVersion(Resource res) {
        this.addPropertyValue(this.getProfile().PRIOR_VERSION(), "PRIOR_VERSION", res);
    }

    @Override
    public OntResource getPriorVersion() {
        return this.objectAsResource(this.getProfile().PRIOR_VERSION(), "PRIOR_VERSION");
    }

    @Override
    public ExtendedIterator<OntResource> listPriorVersion() {
        return this.listAs(this.getProfile().PRIOR_VERSION(), "PRIOR_VERSION", OntResource.class);
    }

    @Override
    public boolean hasPriorVersion(Resource res) {
        return this.hasPropertyValue(this.getProfile().PRIOR_VERSION(), "PRIOR_VERSION", res);
    }

    @Override
    public void removePriorVersion(Resource res) {
        this.removePropertyValue(this.getProfile().PRIOR_VERSION(), "PRIOR_VERSION", res);
    }

    @Override
    public void setIncompatibleWith(Resource res) {
        this.setPropertyValue(this.getProfile().INCOMPATIBLE_WITH(), "INCOMPATIBLE_WITH", res);
    }

    @Override
    public void addIncompatibleWith(Resource res) {
        this.addPropertyValue(this.getProfile().INCOMPATIBLE_WITH(), "INCOMPATIBLE_WITH", res);
    }

    @Override
    public OntResource getIncompatibleWith() {
        return this.objectAsResource(this.getProfile().INCOMPATIBLE_WITH(), "INCOMPATIBLE_WITH");
    }

    @Override
    public ExtendedIterator<OntResource> listIncompatibleWith() {
        return this.listAs(this.getProfile().INCOMPATIBLE_WITH(), "INCOMPATIBLE_WITH", OntResource.class);
    }

    @Override
    public boolean isIncompatibleWith(Resource res) {
        return this.hasPropertyValue(this.getProfile().INCOMPATIBLE_WITH(), "INCOMPATIBLE_WITH", res);
    }

    @Override
    public void removeIncompatibleWith(Resource res) {
        this.removePropertyValue(this.getProfile().INCOMPATIBLE_WITH(), "INCOMPATIBLE_WITH", res);
    }
}

