/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Variable;

public class Node_RuleVariable
extends Node_Variable {
    protected int index;
    protected Node value;
    protected boolean isRef = true;
    public static final Node_RuleVariable WILD = new Node_RuleVariable("*", -1);

    public Node_RuleVariable(String label, int index) {
        super(label);
        this.index = index;
        this.value = this;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void simpleBind(Node node) {
        this.value = node;
        this.isRef = node instanceof Node_RuleVariable;
    }

    public Node deref() {
        Node_RuleVariable var = this;
        while (var.isRef) {
            if (var.value == var) {
                return var;
            }
            var = (Node_RuleVariable)var.value;
        }
        return var.value;
    }

    public Node getRawBoundValue() {
        return this.value;
    }

    public void unbind() {
        this.isRef = true;
        this.value = this;
    }

    public boolean isUnbound() {
        return this.isRef && this.value == this;
    }

    public Node_RuleVariable cloneNode() {
        return new Node_RuleVariable(this.getName(), this.index);
    }

    @Override
    public String toString() {
        if (this.getName() == null) {
            return "*";
        }
        return this.getName();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Node_RuleVariable) {
            String name = this.getName();
            if (name == null) {
                return this == o;
            }
            return name.equals(((Node_RuleVariable)o).getName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        String name = this.getName();
        if (name == null) {
            return 50087;
        }
        return name.hashCode();
    }

    @Override
    public boolean sameValueAs(Object o) {
        return o instanceof Node_RuleVariable;
    }

    public static boolean sameNodeAs(Node n, Node m3) {
        if (n instanceof Node_RuleVariable) {
            if (m3 instanceof Node_RuleVariable) {
                return ((Node_RuleVariable)n).getIndex() == ((Node_RuleVariable)m3).getIndex();
            }
            return false;
        }
        return n.sameValueAs(m3);
    }
}

