/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.impl.OWLRuleTranslationHook;
import com.hp.hpl.jena.shared.impl.JenaParameters;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLFBRuleReasoner
extends FBRuleReasoner {
    protected static final String RULE_FILE = "etc/owl-fb.rules";
    protected static List<Rule> ruleSet;
    protected static FBRuleInfGraph staticPreload;
    protected static Logger logger;

    public OWLFBRuleReasoner(ReasonerFactory factory) {
        super(OWLFBRuleReasoner.loadRules(), factory);
    }

    private OWLFBRuleReasoner(OWLFBRuleReasoner parent, InfGraph schemaGraph) {
        super(parent.rules, schemaGraph, parent.factory);
    }

    public static List<Rule> loadRules() {
        if (ruleSet == null) {
            ruleSet = OWLFBRuleReasoner.loadRules(RULE_FILE);
        }
        return ruleSet;
    }

    @Override
    public Reasoner bindSchema(Graph tbox) throws ReasonerException {
        this.checkArgGraph(tbox);
        if (this.schemaGraph != null) {
            throw new ReasonerException("Can only bind one schema at a time to an OWLRuleReasoner");
        }
        FBRuleInfGraph graph = new FBRuleInfGraph(this, this.rules, this.getPreload(), tbox);
        graph.addPreprocessingHook(new OWLRuleTranslationHook());
        graph.prepare();
        return new OWLFBRuleReasoner(this, graph);
    }

    @Override
    public InfGraph bind(Graph data) throws ReasonerException {
        this.checkArgGraph(data);
        FBRuleInfGraph graph = null;
        InfGraph schemaArg = this.schemaGraph == null ? this.getPreload() : (FBRuleInfGraph)this.schemaGraph;
        List<Rule> baseRules = ((FBRuleInfGraph)schemaArg).getRules();
        graph = new FBRuleInfGraph(this, baseRules, schemaArg);
        graph.addPreprocessingHook(new OWLRuleTranslationHook());
        graph.setDerivationLogging(this.recordDerivations);
        graph.setTraceOn(this.traceOn);
        graph.rebind(data);
        graph.setDatatypeRangeValidation(true);
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized InfGraph getPreload() {
        Class<OWLFBRuleReasoner> clazz = OWLFBRuleReasoner.class;
        synchronized (OWLFBRuleReasoner.class) {
            if (staticPreload == null) {
                boolean prior = JenaParameters.enableFilteringOfHiddenInfNodes;
                try {
                    JenaParameters.enableFilteringOfHiddenInfNodes = true;
                    staticPreload = new FBRuleInfGraph(this, this.rules, null);
                    staticPreload.prepare();
                }
                finally {
                    JenaParameters.enableFilteringOfHiddenInfNodes = prior;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return staticPreload;
        }
    }

    private void checkArgGraph(Graph g2) {
        if (JenaParameters.enableOWLRuleOverOWLRuleWarnings && g2 instanceof InfGraph && ((InfGraph)g2).getReasoner() instanceof OWLFBRuleReasoner) {
            logger.warn("Creating OWL rule reasoner working over another OWL rule reasoner");
        }
    }

    static {
        logger = LoggerFactory.getLogger(OWLFBRuleReasoner.class);
    }
}

