/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.impl.GenericChoiceFrame;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreter;

public class GenericTripleMatchFrame
extends GenericChoiceFrame {
    Node_RuleVariable subjectVar;
    Node_RuleVariable predicateVar;
    Node_RuleVariable objectVar;
    Functor objectFunctor;
    TriplePattern goal;

    public boolean bindResult(Triple triple, LPInterpreter interpreter) {
        if (this.objectVar != null) {
            interpreter.bind(this.objectVar, triple.getObject());
        }
        int mark = interpreter.trail.size();
        if (this.objectFunctor != null && !this.functorMatch(triple, interpreter)) {
            interpreter.unwindTrail(mark);
            return false;
        }
        if (this.subjectVar != null && !interpreter.unify(this.subjectVar, triple.getSubject())) {
            interpreter.unwindTrail(mark);
            return false;
        }
        if (this.predicateVar != null && !interpreter.unify(this.predicateVar, triple.getPredicate())) {
            interpreter.unwindTrail(mark);
            return false;
        }
        return true;
    }

    public boolean functorMatch(Triple t, LPInterpreter interpreter) {
        Node o = t.getObject();
        if (!Functor.isFunctor(o)) {
            return false;
        }
        Functor f = (Functor)o.getLiteralValue();
        if (!f.getName().equals(this.objectFunctor.getName())) {
            return false;
        }
        if (f.getArgLength() != this.objectFunctor.getArgLength()) {
            return false;
        }
        Node[] fargs = f.getArgs();
        Node[] oFargs = this.objectFunctor.getArgs();
        for (int i = 0; i < fargs.length; ++i) {
            if (interpreter.unify(oFargs[i], fargs[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void init(LPInterpreter interpreter) {
        super.init(interpreter);
        Node s2 = LPInterpreter.deref(interpreter.argVars[0]);
        this.subjectVar = s2 instanceof Node_RuleVariable ? (Node_RuleVariable)s2 : null;
        Node p = LPInterpreter.deref(interpreter.argVars[1]);
        this.predicateVar = p instanceof Node_RuleVariable ? (Node_RuleVariable)p : null;
        Node o = LPInterpreter.deref(interpreter.argVars[2]);
        Node_RuleVariable node_RuleVariable = this.objectVar = o instanceof Node_RuleVariable ? (Node_RuleVariable)o : null;
        if (Functor.isFunctor(o)) {
            this.objectFunctor = (Functor)o.getLiteralValue();
            this.goal = new TriplePattern(s2, p, null);
        } else {
            this.objectFunctor = null;
            this.goal = new TriplePattern(s2, p, o);
        }
    }
}

