/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared;

import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.WrappedGraph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.RandomOrderIterator;

public class RandomOrderGraph
extends WrappedGraph {
    private final int bufsz;

    public static Graph createDefaultGraph() {
        return new RandomOrderGraph(Factory.createDefaultGraph());
    }

    public static Model createDefaultModel() {
        return ModelFactory.createModelForGraph(RandomOrderGraph.createDefaultGraph());
    }

    public RandomOrderGraph(int bufsz, Graph base) {
        super(base);
        this.bufsz = bufsz;
    }

    public RandomOrderGraph(Graph base) {
        this(10, base);
    }

    @Override
    public ExtendedIterator<Triple> find(TripleMatch m3) {
        return new RandomOrderIterator<Triple>(this.bufsz, super.find(m3));
    }

    @Override
    public ExtendedIterator<Triple> find(Node s2, Node p, Node o) {
        return new RandomOrderIterator<Triple>(this.bufsz, super.find(s2, p, o));
    }

    @Override
    public Capabilities getCapabilities() {
        return new MyCapabilities(super.getCapabilities());
    }

    private class MyCapabilities
    implements Capabilities {
        private Capabilities parentCapabilities;

        public MyCapabilities(Capabilities parentCapabilities) {
            this.parentCapabilities = parentCapabilities;
        }

        @Override
        public boolean sizeAccurate() {
            return this.parentCapabilities.sizeAccurate();
        }

        @Override
        public boolean addAllowed() {
            return this.parentCapabilities.addAllowed();
        }

        @Override
        public boolean addAllowed(boolean everyTriple) {
            return this.parentCapabilities.addAllowed(everyTriple);
        }

        @Override
        public boolean deleteAllowed() {
            return this.parentCapabilities.deleteAllowed();
        }

        @Override
        public boolean deleteAllowed(boolean everyTriple) {
            return this.parentCapabilities.deleteAllowed(everyTriple);
        }

        @Override
        public boolean canBeEmpty() {
            return this.parentCapabilities.canBeEmpty();
        }

        @Override
        public boolean findContractSafe() {
            return this.parentCapabilities.findContractSafe();
        }

        @Override
        public boolean handlesLiteralTyping() {
            return this.parentCapabilities.handlesLiteralTyping();
        }

        @Override
        public boolean iteratorRemoveAllowed() {
            return false;
        }
    }
}

