/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.uuid;

import com.hp.hpl.jena.shared.uuid.Bits;
import com.hp.hpl.jena.shared.uuid.JenaUUID;
import com.hp.hpl.jena.shared.uuid.LibUUID;
import com.hp.hpl.jena.shared.uuid.UUIDFactory;
import com.hp.hpl.jena.shared.uuid.UUID_V1;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Locale;

public class UUID_V1_Gen
implements UUIDFactory {
    static final int versionHere = 1;
    static final int variantHere = 2;
    static final long maskTimeLow = -4294967296L;
    static final long maskTimeMid = 0xFFFF0000L;
    static final long maskTimeHigh = 4095L;
    static final long maskVersion = 61440L;
    static final long maskVariant = -4611686018427387904L;
    static final long maskClockSeq = 0x3FFF000000000000L;
    static final long maskNode = 0xFFFFFFFFFFFFL;
    long gregorianTime = 0L;
    static final long UUIDS_PER_TICK = 100L;
    long uuids_this_tick = 101L;
    int clockSeq = 0;
    private static final int CLOCK_BITS = 8;
    long node = 0L;
    private long lastTime = 0L;
    private long DELAY = 10L;

    public UUID_V1_Gen() {
        this.reset();
    }

    @Override
    public void reset() {
        this.setInitialState();
        this.setTime();
    }

    @Override
    public JenaUUID generate() {
        return this.generateV1();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID_V1 generateV1() {
        long timestamp = 0L;
        UUID_V1_Gen uUID_V1_Gen = this;
        synchronized (uUID_V1_Gen) {
            if (this.uuids_this_tick >= 100L) {
                this.setTime();
            }
            timestamp = this.gregorianTime + this.uuids_this_tick;
            ++this.uuids_this_tick;
        }
        return this.generate(timestamp);
    }

    @Override
    public JenaUUID parse(String s2) throws JenaUUID.UUIDFormatException {
        if ((s2 = s2.toLowerCase(Locale.ENGLISH)).length() != 36) {
            throw new JenaUUID.UUIDFormatException("UUID string is not 36 chars long: it's " + s2.length() + " [" + s2 + "]");
        }
        if (s2.charAt(8) != '-' && s2.charAt(13) != '-' && s2.charAt(18) != '-' && s2.charAt(23) != '-') {
            throw new JenaUUID.UUIDFormatException("String does not have dashes in the right places: " + s2);
        }
        UUID_V1 u = UUID_V1_Gen.parse$(s2);
        if (u.getVersion() != 1) {
            throw new JenaUUID.UUIDFormatException("Wrong version (Expected: 1Got: " + u.getVersion() + "): " + s2);
        }
        if (u.getVariant() != 2) {
            throw new JenaUUID.UUIDFormatException("Wrong version (Expected: 2Got: " + u.getVariant() + "): " + s2);
        }
        return u;
    }

    static UUID_V1 parse$(String s2) {
        int x = (int)Bits.unpack(s2, 19, 23);
        int variant = x >>> 14;
        int clockSeq = x & 0x3FFF;
        long timeHigh = Bits.unpack(s2, 15, 18);
        long timeMid = Bits.unpack(s2, 9, 13);
        long timeLow = Bits.unpack(s2, 0, 8);
        long node = Bits.unpack(s2, 24, 36);
        int version2 = (int)Bits.unpack(s2, 14, 15);
        return UUID_V1_Gen.generate(version2, variant, timeHigh, timeMid, timeLow, clockSeq, node);
    }

    private static String unparse(UUID_V1 uuid2) {
        int _variant = uuid2.getVariant();
        int _version = uuid2.getVersion();
        long timeHigh = uuid2.getTimeHigh();
        long timeMid = uuid2.getTimeMid();
        long timeLow = uuid2.getTimeLow();
        long node = uuid2.getNode();
        long clockSeq = uuid2.getClockSequence();
        StringBuffer sBuff = new StringBuffer();
        JenaUUID.toHex(sBuff, timeLow, 4);
        sBuff.append('-');
        JenaUUID.toHex(sBuff, timeMid, 2);
        sBuff.append('-');
        JenaUUID.toHex(sBuff, (long)(_version << 12) | timeHigh, 2);
        sBuff.append('-');
        JenaUUID.toHex(sBuff, (long)_variant << 14 | clockSeq, 2);
        sBuff.append('-');
        JenaUUID.toHex(sBuff, node, 6);
        return sBuff.toString();
    }

    private UUID_V1 generate(long timestamp) {
        return UUID_V1_Gen.generate(1, 2, timestamp, this.clockSeq, this.node);
    }

    static UUID_V1 generate(int version2, int variant, long timestamp, long clockSeq, long node) {
        long timeHigh = timestamp >>> 48;
        long timeMid = timestamp >>> 32 & 0xFFFFL;
        long timeLow = timestamp & 0xFFFFFFFFL;
        return UUID_V1_Gen.generate(version2, variant, timeHigh, timeMid, timeLow, clockSeq, node);
    }

    private static UUID_V1 generate(int version2, int variant, long timeHigh, long timeMid, long timeLow, long clockSeq, long node) {
        long mostSigBits = timeLow << 32 | timeMid << 16 | (long)(version2 << 12) | timeHigh;
        long leastSigBits = (long)variant << 62 | clockSeq << 48 | node;
        return new UUID_V1(mostSigBits, leastSigBits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTime() {
        long time = 0L;
        UUID_V1_Gen uUID_V1_Gen = this;
        synchronized (uUID_V1_Gen) {
            if (this.lastTime == 0L) {
                this.lastTime = System.currentTimeMillis();
            }
            boolean done = false;
            while (!done) {
                time = System.currentTimeMillis();
                if (time < this.lastTime + this.DELAY) {
                    try {
                        Thread.sleep(this.DELAY);
                    }
                    catch (InterruptedException e2) {}
                    continue;
                }
                done = true;
            }
        }
        this.lastTime = time;
        this.uuids_this_tick = 0L;
        this.gregorianTime = time * 10L + 122192928000000000L;
    }

    private void setInitialState() {
        long random = LibUUID.makeRandom().nextLong();
        this.clockSeq = 0;
        this.clockSeq = (int)Bits.unpack(random, 48, 56);
        try {
            NetworkInterface ni;
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            byte[] hwAddr = null;
            while (en.hasMoreElements() && ((ni = en.nextElement()) == null || ni.isLoopback() || ni.isPointToPoint() || ni.isVirtual() || (hwAddr = ni.getHardwareAddress()) == null)) {
            }
            if (hwAddr != null && hwAddr.length > 4) {
                this.node = 0L;
                for (byte bv : hwAddr) {
                    this.node = this.node << 8 | (long)(bv & 0xFF);
                }
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.node = Bits.unpack(random, 0, 47);
        this.node = Bits.set(this.node, 47);
    }
}

