/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.DatasetGraphBase;
import com.hp.hpl.jena.sparql.core.Quad;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;

public abstract class DatasetGraphBaseFind
extends DatasetGraphBase {
    protected DatasetGraphBaseFind() {
    }

    @Override
    public Iterator<Quad> find(Node g2, Node s2, Node p, Node o) {
        if (Quad.isDefaultGraph(g2)) {
            return this.findInDftGraph(s2, p, o);
        }
        if (!DatasetGraphBaseFind.isWildcard(g2)) {
            return this.findNG(g2, s2, p, o);
        }
        return this.findAny(s2, p, o);
    }

    @Override
    public Iterator<Quad> findNG(Node g2, Node s2, Node p, Node o) {
        Iterator<Quad> qIter = Quad.isUnionGraph(g2) ? this.findInAnyNamedGraphs(s2, p, o) : (!DatasetGraphBaseFind.isWildcard(g2) ? this.findInSpecificNamedGraph(g2, s2, p, o) : this.findInAnyNamedGraphs(s2, p, o));
        if (qIter == null) {
            return Iter.nullIterator();
        }
        return qIter;
    }

    protected Iterator<Quad> findAny(Node s2, Node p, Node o) {
        Iterator<Quad> iter1 = this.findInDftGraph(s2, p, o);
        Iterator<Quad> iter2 = this.findInAnyNamedGraphs(s2, p, o);
        if (iter1 == null && iter2 == null) {
            return Iter.nullIterator();
        }
        return Iter.append(iter1, iter2);
    }

    protected abstract Iterator<Quad> findInDftGraph(Node var1, Node var2, Node var3);

    protected abstract Iterator<Quad> findInSpecificNamedGraph(Node var1, Node var2, Node var3, Node var4);

    protected abstract Iterator<Quad> findInAnyNamedGraphs(Node var1, Node var2, Node var3);
}

