/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphWrapper;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.graph.GraphReadOnly;
import java.util.HashMap;
import java.util.Map;

public class DatasetGraphReadOnly
extends DatasetGraphWrapper {
    private Graph dftGraph = null;
    private Map<Node, Graph> namedGraphs = new HashMap<Node, Graph>();

    public DatasetGraphReadOnly(DatasetGraph dsg) {
        super(dsg);
    }

    @Override
    public Graph getDefaultGraph() {
        if (this.dftGraph == null) {
            this.dftGraph = new GraphReadOnly(super.getDefaultGraph());
        }
        return this.dftGraph;
    }

    @Override
    public Graph getGraph(Node graphNode) {
        if (this.namedGraphs.containsKey(graphNode)) {
            if (!super.containsGraph(graphNode)) {
                this.namedGraphs.remove(graphNode);
                return null;
            }
            return this.namedGraphs.get(graphNode);
        }
        Graph g2 = super.getGraph(graphNode);
        if (g2 == null) {
            return null;
        }
        g2 = new GraphReadOnly(g2);
        this.namedGraphs.put(graphNode, g2);
        return g2;
    }

    @Override
    public void setDefaultGraph(Graph g2) {
        throw new UnsupportedOperationException("read-only dataset");
    }

    @Override
    public void addGraph(Node graphName, Graph graph) {
        throw new UnsupportedOperationException("read-only dataset");
    }

    @Override
    public void removeGraph(Node graphName) {
        throw new UnsupportedOperationException("read-only dataset");
    }

    @Override
    public void add(Quad quad) {
        throw new UnsupportedOperationException("read-only dataset");
    }

    @Override
    public void delete(Quad quad) {
        throw new UnsupportedOperationException("read-only dataset");
    }

    @Override
    public void deleteAny(Node g2, Node s2, Node p, Node o) {
        throw new UnsupportedOperationException("read-only dataset");
    }
}

