/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.SystemARQ;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.riot.other.GLib;

public class GraphView
extends GraphBase
implements Sync {
    private final DatasetGraph dsg;
    private final Node gn;

    public static GraphView createDefaultGraph(DatasetGraph dsg) {
        return new GraphView(dsg, Quad.defaultGraphNodeGenerated);
    }

    public static GraphView createNamedGraph(DatasetGraph dsg, Node graphIRI) {
        return new GraphView(dsg, graphIRI);
    }

    public static GraphView createUnionGraph(DatasetGraph dsg) {
        return new GraphView(dsg, Quad.unionGraph);
    }

    protected GraphView(DatasetGraph dsg, Node gn) {
        this.dsg = dsg;
        this.gn = gn;
    }

    public Node getGraphName() {
        return this.gn == Quad.defaultGraphNodeGenerated ? null : this.gn;
    }

    public DatasetGraph getDataset() {
        return this.dsg;
    }

    protected final boolean isDefaultGraph() {
        return GraphView.isDefaultGraph(this.gn);
    }

    protected final boolean isUnionGraph() {
        return GraphView.isUnionGraph(this.gn);
    }

    protected static final boolean isDefaultGraph(Node gn) {
        return gn == null || Quad.isDefaultGraph(gn);
    }

    protected static final boolean isUnionGraph(Node gn) {
        return Quad.isUnionGraph(gn);
    }

    @Override
    protected PrefixMapping createPrefixMapping() {
        return new PrefixMappingImpl();
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m3) {
        if (m3 == null) {
            m3 = Triple.ANY;
        }
        Node s2 = m3.getMatchSubject();
        Node p = m3.getMatchPredicate();
        Node o = m3.getMatchObject();
        return this.graphBaseFind(s2, p, o);
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(Node s2, Node p, Node o) {
        if (Quad.isUnionGraph(this.gn)) {
            return this.graphUnionFind(s2, p, o);
        }
        Node g2 = GraphView.graphNode(this.gn);
        Iter<Triple> iter = GLib.quads2triples(this.dsg.find(g2, s2, p, o));
        return WrappedIterator.createNoRemove(iter);
    }

    private static Node graphNode(Node gn) {
        return gn == null ? Quad.defaultGraphNodeGenerated : gn;
    }

    protected ExtendedIterator<Triple> graphUnionFind(Node s2, Node p, Node o) {
        Node g2 = GraphView.graphNode(this.gn);
        Iterator<Quad> iterQuads = this.getDataset().find(g2, s2, p, o);
        Iterator<Triple> iter = GLib.quads2triples(iterQuads);
        iter = Iter.distinct(iter);
        return WrappedIterator.createNoRemove(iter);
    }

    @Override
    public void performAdd(Triple t) {
        Node g2 = GraphView.graphNode(this.gn);
        if (Quad.isUnionGraph(g2)) {
            throw new GraphViewException("Can't update the default union graph of a dataset");
        }
        Node s2 = t.getSubject();
        Node p = t.getPredicate();
        Node o = t.getObject();
        this.dsg.add(g2, s2, p, o);
    }

    @Override
    public void performDelete(Triple t) {
        Node g2 = GraphView.graphNode(this.gn);
        if (Quad.isUnionGraph(g2)) {
            throw new GraphViewException("Can't update the default union graph of a dataset");
        }
        Node s2 = t.getSubject();
        Node p = t.getPredicate();
        Node o = t.getObject();
        this.dsg.delete(g2, s2, p, o);
    }

    @Override
    public void sync() {
        SystemARQ.sync(this.dsg);
    }

    static class GraphViewException
    extends JenaException {
        public GraphViewException() {
        }

        public GraphViewException(String message) {
            super(message);
        }

        public GraphViewException(Throwable cause) {
            super(cause);
        }

        public GraphViewException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

