/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.http;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.engine.http.Params;
import com.hp.hpl.jena.sparql.engine.http.QueryExceptionHTTP;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DecompressingHttpClient;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;
import org.apache.jena.atlas.web.auth.SimpleAuthenticator;
import org.apache.jena.riot.web.HttpOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpQuery
extends Params {
    static final Logger log = LoggerFactory.getLogger(HttpQuery.class.getName());
    public static int urlLimit = 2048;
    String serviceURL;
    String contentTypeResult = "application/sparql-results+xml";
    static final Object noValue = new Object();
    private HttpAuthenticator authenticator = null;
    private int responseCode = 0;
    private String responseMessage = null;
    private boolean forcePOST = false;
    private String queryString = null;
    private boolean serviceParams = false;
    private final Pattern queryParamPattern = Pattern.compile(".+[&|\\?]query=.*");
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private boolean allowGZip = false;
    private boolean allowDeflate = false;
    private HttpClient client;
    private boolean requireClientShutdown = true;

    public HttpQuery(String serviceURL) {
        this.init(serviceURL);
    }

    public HttpQuery(URL url) {
        this.init(url.toString());
    }

    private void init(String serviceURL) {
        if (log.isTraceEnabled()) {
            log.trace("URL: " + serviceURL);
        }
        if (serviceURL.indexOf(63) >= 0) {
            this.serviceParams = true;
        }
        if (this.queryParamPattern.matcher(serviceURL).matches()) {
            throw new QueryExecException("SERVICE URL overrides the 'query' SPARQL protocol parameter");
        }
        this.serviceURL = serviceURL;
    }

    private String getQueryString() {
        if (this.queryString == null) {
            this.queryString = super.httpString();
        }
        return this.queryString;
    }

    public void setAccept(String contentType) {
        this.contentTypeResult = contentType;
    }

    public String getContentType() {
        return this.contentTypeResult;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setAllowGZip(boolean allow) {
        this.allowGZip = allow;
    }

    public void setAllowDeflate(boolean allow) {
        this.allowDeflate = allow;
    }

    public void setBasicAuthentication(String user, char[] password) {
        this.setAuthenticator(new SimpleAuthenticator(user, password));
    }

    public void setAuthenticator(HttpAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public boolean shouldShutdownClient() {
        return this.requireClientShutdown;
    }

    public boolean usesPOST() {
        if (this.forcePOST) {
            return true;
        }
        String s2 = this.getQueryString();
        return this.serviceURL.length() + s2.length() >= urlLimit;
    }

    public void setForcePOST() {
        this.forcePOST = true;
    }

    public void setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public InputStream exec() throws QueryExceptionHTTP {
        try {
            if (this.usesPOST()) {
                return this.execPost();
            }
            return this.execGet();
        }
        catch (QueryExceptionHTTP httpEx) {
            log.trace("Exception in exec", httpEx);
            throw httpEx;
        }
        catch (JenaException jEx) {
            log.trace("JenaException in exec", jEx);
            throw jEx;
        }
    }

    private InputStream execGet() throws QueryExceptionHTTP {
        URL target = null;
        String qs = this.getQueryString();
        ARQ.getHttpRequestLogger().trace(qs);
        try {
            target = this.count() == 0 ? new URL(this.serviceURL) : new URL(this.serviceURL + (this.serviceParams ? "&" : "?") + qs);
        }
        catch (MalformedURLException malEx) {
            throw new QueryExceptionHTTP(0, "Malformed URL: " + malEx);
        }
        log.trace("GET " + target.toExternalForm());
        try {
            TypedInputStream stream;
            this.selectClient();
            this.client.getParams().setLongParameter("http.conn-manager.timeout", TimeUnit.SECONDS.toMillis(10L));
            if (this.connectTimeout > 0) {
                this.client.getParams().setIntParameter("http.connection.timeout", this.connectTimeout);
            }
            if (this.readTimeout > 0) {
                this.client.getParams().setIntParameter("http.socket.timeout", this.readTimeout);
            }
            BasicHttpContext context = new BasicHttpContext();
            if (this.allowGZip || this.allowDeflate) {
                HttpOp.applyAuthentication((AbstractHttpClient)this.client, this.serviceURL, context, this.authenticator);
                this.client = new DecompressingHttpClient(this.client);
            }
            if ((stream = HttpOp.execHttpGet(target.toString(), this.contentTypeResult, this.client, context, this.authenticator)) == null) {
                throw new QueryExceptionHTTP(404);
            }
            return this.execCommon(stream);
        }
        catch (HttpException httpEx) {
            try {
                if (httpEx.getResponseCode() == 414) {
                    return this.execPost();
                }
                throw httpEx;
            }
            catch (HttpException httpEx2) {
                throw this.rewrap(httpEx2);
            }
        }
    }

    private InputStream execPost() throws QueryExceptionHTTP {
        URL target = null;
        try {
            target = new URL(this.serviceURL);
        }
        catch (MalformedURLException malEx) {
            throw new QueryExceptionHTTP(0, "Malformed URL: " + malEx);
        }
        log.trace("POST " + target.toExternalForm());
        ARQ.getHttpRequestLogger().trace(target.toExternalForm());
        try {
            TypedInputStream stream;
            this.selectClient();
            this.client.getParams().setLongParameter("http.conn-manager.timeout", TimeUnit.SECONDS.toMillis(10L));
            if (this.connectTimeout > 0) {
                this.client.getParams().setIntParameter("http.connection.timeout", this.connectTimeout);
            }
            if (this.readTimeout > 0) {
                this.client.getParams().setIntParameter("http.socket.timeout", this.readTimeout);
            }
            BasicHttpContext context = new BasicHttpContext();
            if (this.allowGZip || this.allowDeflate) {
                HttpOp.applyAuthentication((AbstractHttpClient)this.client, this.serviceURL, context, this.authenticator);
                this.client = new DecompressingHttpClient(this.client);
            }
            if ((stream = HttpOp.execHttpPostFormStream(this.serviceURL, this, this.contentTypeResult, this.client, context, this.authenticator)) == null) {
                throw new QueryExceptionHTTP(404);
            }
            return this.execCommon(stream);
        }
        catch (HttpException httpEx) {
            throw this.rewrap(httpEx);
        }
    }

    private QueryExceptionHTTP rewrap(HttpException httpEx) {
        this.responseCode = httpEx.getResponseCode();
        if (this.responseCode != -1) {
            String responseLine = httpEx.getStatusLine() != null ? httpEx.getStatusLine() : "No Status Line";
            return new QueryExceptionHTTP(this.responseCode, "HTTP " + this.responseCode + " error making the query: " + responseLine, httpEx.getCause());
        }
        if (httpEx.getMessage() != null) {
            return new QueryExceptionHTTP("Unexpected error making the query: " + httpEx.getMessage(), httpEx.getCause());
        }
        if (httpEx.getCause() != null) {
            return new QueryExceptionHTTP("Unexpected error making the query, see cause for further details", httpEx.getCause());
        }
        return new QueryExceptionHTTP("Unexpected error making the query", httpEx);
    }

    private void selectClient() {
        this.client = HttpOp.getDefaultHttpClient();
        if (this.client == null || this.authenticator != null && !HttpOp.getUseDefaultClientWithAuthentication()) {
            this.client = new SystemDefaultHttpClient();
        } else {
            this.requireClientShutdown = false;
        }
    }

    private InputStream execCommon(TypedInputStream stream) throws QueryExceptionHTTP {
        this.responseCode = 200;
        this.responseMessage = "OK";
        this.contentTypeResult = stream.getContentType();
        if (this.contentTypeResult != null && this.contentTypeResult.contains(";")) {
            this.contentTypeResult = this.contentTypeResult.substring(0, this.contentTypeResult.indexOf(59));
        }
        return stream;
    }

    public String toString() {
        String s2 = this.httpString();
        if (s2 != null && s2.length() > 0) {
            return this.serviceURL + "?" + s2;
        }
        return this.serviceURL;
    }
}

