/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.graph;

import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.AllCapabilities;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphSPARQL
extends GraphBase
implements Graph {
    private static Logger log = LoggerFactory.getLogger(GraphSPARQL.class);
    private DatasetGraph dataset;
    private QueryEngineFactory factory;

    public GraphSPARQL(DatasetGraph dataset, QueryEngineFactory factory) {
        this.dataset = dataset;
        this.factory = factory;
    }

    public GraphSPARQL(DatasetGraph dataset, String uri) {
        this(dataset, NodeFactory.createURI(uri));
    }

    public GraphSPARQL(DatasetGraph dsg, Node gn) {
        this.dataset = DatasetGraphFactory.create(dsg);
        this.dataset.setDefaultGraph(dsg.getGraph(gn));
        this.factory = null;
    }

    public GraphSPARQL(Graph graph) {
        this(graph, null);
    }

    public GraphSPARQL(Graph graph, QueryEngineFactory factory) {
        this.dataset = DatasetGraphFactory.createOneGraph(graph);
        this.factory = factory;
    }

    private DatasetGraph toDSG(DatasetGraph dataset, Node graphNode) {
        Graph graph = graphNode == null ? dataset.getDefaultGraph() : dataset.getGraph(graphNode);
        DatasetGraph dsGraph = DatasetGraphFactory.create(graph);
        return dsGraph;
    }

    @Override
    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new AllCapabilities(){

                @Override
                public boolean handlesLiteralTyping() {
                    return false;
                }
            };
        }
        return this.capabilities;
    }

    public DatasetGraph getDataset() {
        return this.dataset;
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m3) {
        Node s2 = m3.getMatchSubject();
        Var sVar = null;
        if (s2 == null) {
            sVar = Var.alloc("s");
            s2 = sVar;
        }
        Node p = m3.getMatchPredicate();
        Var pVar = null;
        if (p == null) {
            pVar = Var.alloc("p");
            p = pVar;
        }
        Node o = m3.getMatchObject();
        Var oVar = null;
        if (o == null) {
            oVar = Var.alloc("o");
            o = oVar;
        }
        Triple triple = new Triple(s2, p, o);
        BasicPattern pattern = new BasicPattern();
        pattern.add(triple);
        OpBGP op = new OpBGP(pattern);
        Plan plan = this.factory.create(op, this.getDataset(), BindingRoot.create(), null);
        QueryIterator qIter = plan.iterator();
        ArrayList<Triple> triples = new ArrayList<Triple>();
        while (qIter.hasNext()) {
            Binding b = qIter.nextBinding();
            Node sResult = s2;
            Node pResult = p;
            Node oResult = o;
            if (sVar != null) {
                sResult = b.get(sVar);
            }
            if (pVar != null) {
                pResult = b.get(pVar);
            }
            if (oVar != null) {
                oResult = b.get(oVar);
            }
            Triple resultTriple = new Triple(sResult, pResult, oResult);
            if (log.isDebugEnabled()) {
                log.debug("  " + resultTriple);
            }
            triples.add(resultTriple);
        }
        qIter.close();
        return WrappedIterator.createNoRemove(triples.iterator());
    }
}

