/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.mgt;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.path.Path;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.writers.WriterNode;
import com.hp.hpl.jena.sparql.util.Context;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.StrUtils;
import org.slf4j.Logger;

public class Explain {
    public static boolean MultiLineMode = true;
    public static final Logger logExec = ARQ.getExecLogger();
    public static final Logger logInfo = ARQ.getInfoLogger();
    private static final boolean MultiLinesForOps = true;
    private static final boolean MultiLinesForPatterns = true;

    public static void explain(Query query2, Context context) {
        Explain.explain("Query", query2, context);
    }

    public static void explain(String message, Query query2, Context context) {
        if (Explain.explaining(InfoLevel.INFO, logExec, context)) {
            IndentedLineBuffer iBuff = new IndentedLineBuffer();
            iBuff.incIndent();
            query2.serialize(iBuff);
            String x = iBuff.asString();
            Explain._explain(logExec, message, x, true);
        }
    }

    public static void explain(Op op, Context context) {
        Explain.explain("Algebra", op, context);
    }

    public static void explain(String message, Op op, Context context) {
        if (Explain.explaining(InfoLevel.FINE, logExec, context)) {
            try (IndentedLineBuffer iBuff = new IndentedLineBuffer();){
                iBuff.incIndent();
                op.output(iBuff);
                String x = iBuff.asString();
                Explain._explain(logExec, message, x, true);
            }
        }
    }

    public static void explain(BasicPattern bgp, Context context) {
        Explain.explain("BGP", bgp, context);
    }

    public static void explain(String message, BasicPattern bgp, Context context) {
        if (Explain.explaining(InfoLevel.ALL, logExec, context)) {
            try (IndentedLineBuffer iBuff = new IndentedLineBuffer();){
                iBuff.incIndent();
                Explain.formatTriples(iBuff, bgp);
                iBuff.flush();
                String str2 = iBuff.toString();
                Explain._explain(logExec, message, str2, false);
            }
        }
    }

    public static void explain(String message, QuadPattern quads, Context context) {
        if (Explain.explaining(InfoLevel.ALL, logExec, context)) {
            try (IndentedLineBuffer iBuff = new IndentedLineBuffer();){
                iBuff.incIndent();
                Explain.formatQuads(iBuff, quads);
                iBuff.flush();
                String str2 = iBuff.toString();
                Explain._explain(logExec, message, str2, false);
            }
        }
    }

    private static void formatQuads(IndentedLineBuffer out, QuadPattern quads) {
        SerializationContext sCxt = SSE.sCxt(SSE.defaultPrefixMapWrite);
        boolean first = true;
        for (Quad qp : quads) {
            if (first) {
                first = false;
            }
            out.print("(");
            if (qp.getGraph() == null) {
                out.print("_");
            } else {
                WriterNode.output((IndentedWriter)out, qp.getGraph(), sCxt);
            }
            out.print(" ");
            WriterNode.output((IndentedWriter)out, qp.getSubject(), sCxt);
            out.print(" ");
            WriterNode.output((IndentedWriter)out, qp.getPredicate(), sCxt);
            out.print(" ");
            WriterNode.output((IndentedWriter)out, qp.getObject(), sCxt);
            out.print(")");
            out.println();
        }
    }

    private static void formatTriples(IndentedLineBuffer out, BasicPattern triples) {
        SerializationContext sCxt = SSE.sCxt(SSE.defaultPrefixMapWrite);
        boolean first = true;
        for (Triple qp : triples) {
            if (first) {
                first = false;
            }
            out.print("(");
            WriterNode.output((IndentedWriter)out, qp.getSubject(), sCxt);
            out.print(" ");
            WriterNode.output((IndentedWriter)out, qp.getPredicate(), sCxt);
            out.print(" ");
            WriterNode.output((IndentedWriter)out, qp.getObject(), sCxt);
            out.print(")");
            out.println();
        }
    }

    private static void _explain(Logger logger, String reason, String explanation, boolean newlineAlways) {
        while (explanation.endsWith("\n") || explanation.endsWith("\r")) {
            explanation = StrUtils.chop(explanation);
        }
        explanation = newlineAlways || explanation.contains("\n") ? reason + "\n" + explanation : reason + " :: " + explanation;
        Explain._explain(logger, explanation);
    }

    private static void _explain(Logger logger, String explanation) {
        logger.info(explanation);
    }

    public static void explain(Context context, String message) {
        if (Explain.explaining(InfoLevel.INFO, logInfo, context)) {
            Explain._explain(logInfo, message);
        }
    }

    public static void explain(Context context, String format, Object ... args) {
        if (Explain.explaining(InfoLevel.INFO, logInfo, context)) {
            String str2 = String.format(format, args);
            Explain._explain(logInfo, str2);
        }
    }

    public static boolean explaining(InfoLevel level, Logger logger, Context context) {
        if (!Explain._explaining(level, context)) {
            return false;
        }
        return logger.isInfoEnabled();
    }

    private static boolean _explaining(InfoLevel level, Context context) {
        if (level == InfoLevel.NONE) {
            return false;
        }
        Object x = context.get(ARQ.symLogExec, null);
        if (x == null) {
            return false;
        }
        if (level.level() == InfoLevel.NONE.level()) {
            return false;
        }
        if (x instanceof InfoLevel) {
            InfoLevel z = (InfoLevel)((Object)x);
            if (z == InfoLevel.NONE) {
                return false;
            }
            return z.level() >= level.level();
        }
        if (x instanceof String) {
            String s2 = (String)x;
            if (s2.equalsIgnoreCase("info")) {
                return level.equals((Object)InfoLevel.INFO);
            }
            if (s2.equalsIgnoreCase("fine")) {
                return level.equals((Object)InfoLevel.FINE) || level.equals((Object)InfoLevel.INFO);
            }
            if (s2.equalsIgnoreCase("all")) {
                return true;
            }
            if (s2.equalsIgnoreCase("true")) {
                return true;
            }
            if (s2.equalsIgnoreCase("none")) {
                return false;
            }
        }
        return Boolean.TRUE.equals(x);
    }

    public static void explain(Node s2, Path path, Node o, Context context) {
        Explain.explain("Path", s2, path, o, context);
    }

    public static void explain(String message, Node s2, Path path, Node o, Context context) {
        if (Explain.explaining(InfoLevel.ALL, logExec, context)) {
            String str2 = s2 + " " + path + " " + o;
            Explain._explain(logExec, message, str2, false);
        }
    }

    public static enum InfoLevel {
        INFO{

            @Override
            public int level() {
                return 10;
            }
        }
        ,
        FINE{

            @Override
            public int level() {
                return 20;
            }
        }
        ,
        ALL{

            @Override
            public int level() {
                return 30;
            }
        }
        ,
        NONE{

            @Override
            public int level() {
                return -1;
            }
        };


        public abstract int level();

        public static InfoLevel get(String name) {
            if ("ALL".equalsIgnoreCase(name)) {
                return ALL;
            }
            if ("FINE".equalsIgnoreCase(name)) {
                return FINE;
            }
            if ("INFO".equalsIgnoreCase(name)) {
                return INFO;
            }
            if ("NONE".equalsIgnoreCase(name)) {
                return NONE;
            }
            return null;
        }
    }
}

