/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify.request;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.modify.request.Target;
import com.hp.hpl.jena.sparql.modify.request.UpdateAdd;
import com.hp.hpl.jena.sparql.modify.request.UpdateBinaryOp;
import com.hp.hpl.jena.sparql.modify.request.UpdateClear;
import com.hp.hpl.jena.sparql.modify.request.UpdateCopy;
import com.hp.hpl.jena.sparql.modify.request.UpdateCreate;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataDelete;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataInsert;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataWriter;
import com.hp.hpl.jena.sparql.modify.request.UpdateDeleteWhere;
import com.hp.hpl.jena.sparql.modify.request.UpdateDrop;
import com.hp.hpl.jena.sparql.modify.request.UpdateDropClear;
import com.hp.hpl.jena.sparql.modify.request.UpdateLoad;
import com.hp.hpl.jena.sparql.modify.request.UpdateModify;
import com.hp.hpl.jena.sparql.modify.request.UpdateMove;
import com.hp.hpl.jena.sparql.modify.request.UpdateVisitor;
import com.hp.hpl.jena.sparql.serializer.FormatterElement;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.riot.out.SinkQuadBracedOutput;

public class UpdateWriterVisitor
implements UpdateVisitor {
    protected static final int BLOCK_INDENT = 2;
    protected final IndentedWriter out;
    protected final SerializationContext sCxt;

    public UpdateWriterVisitor(IndentedWriter out, SerializationContext sCxt) {
        this.out = out;
        this.sCxt = sCxt;
    }

    protected void visitDropClear(String name, UpdateDropClear update2) {
        this.out.ensureStartOfLine();
        this.out.print(name);
        this.out.print(" ");
        if (update2.isSilent()) {
            this.out.print("SILENT ");
        }
        this.printTarget(update2.getTarget());
    }

    protected void printTarget(Target target) {
        if (target.isAll()) {
            this.out.print("ALL");
        } else if (target.isAllNamed()) {
            this.out.print("NAMED");
        } else if (target.isDefault()) {
            this.out.print("DEFAULT");
        } else if (target.isOneNamedGraph()) {
            this.out.print("GRAPH ");
            String s2 = FmtUtils.stringForNode(target.getGraph(), this.sCxt);
            this.out.print(s2);
        } else {
            this.out.print("Target BROKEN");
            throw new ARQException("Malformed Target");
        }
    }

    @Override
    public void visit(UpdateDrop update2) {
        this.visitDropClear("DROP", update2);
    }

    @Override
    public void visit(UpdateClear update2) {
        this.visitDropClear("CLEAR", update2);
    }

    @Override
    public void visit(UpdateCreate update2) {
        this.out.ensureStartOfLine();
        this.out.print("CREATE");
        this.out.print(" ");
        if (update2.isSilent()) {
            this.out.print("SILENT ");
        }
        this.out.print("GRAPH");
        this.out.print(" ");
        String s2 = FmtUtils.stringForNode(update2.getGraph(), this.sCxt);
        this.out.print(s2);
    }

    @Override
    public void visit(UpdateLoad update2) {
        this.out.ensureStartOfLine();
        this.out.print("LOAD");
        this.out.print(" ");
        if (update2.getSilent()) {
            this.out.print("SILENT ");
        }
        this.outputStringAsURI(update2.getSource());
        if (update2.getDest() != null) {
            this.out.print(" INTO GRAPH ");
            this.output(update2.getDest());
        }
    }

    protected void outputStringAsURI(String uriStr) {
        String x = FmtUtils.stringForURI(uriStr, this.sCxt);
        this.out.print(x);
    }

    protected void printTargetUpdate2(Target target) {
        if (target.isDefault()) {
            this.out.print("DEFAULT");
        } else if (target.isOneNamedGraph()) {
            String s2 = FmtUtils.stringForNode(target.getGraph(), this.sCxt);
            this.out.print(s2);
        } else {
            this.out.print("Target BROKEN / Update2");
            throw new ARQException("Malformed Target / Update2");
        }
    }

    protected void printUpdate2(UpdateBinaryOp update2, String name) {
        this.out.print(name);
        if (update2.getSilent()) {
            this.out.print(" SILENT");
        }
        this.out.print(" ");
        this.printTargetUpdate2(update2.getSrc());
        this.out.print(" TO ");
        this.printTargetUpdate2(update2.getDest());
    }

    @Override
    public void visit(UpdateAdd update2) {
        this.printUpdate2(update2, "ADD");
    }

    @Override
    public void visit(UpdateCopy update2) {
        this.printUpdate2(update2, "COPY");
    }

    @Override
    public void visit(UpdateMove update2) {
        this.printUpdate2(update2, "MOVE");
    }

    @Override
    public Sink<Quad> createInsertDataSink() {
        UpdateDataWriter udw = new UpdateDataWriter(UpdateDataWriter.UpdateMode.INSERT, this.out, this.sCxt);
        udw.open();
        return udw;
    }

    @Override
    public void visit(UpdateDataInsert update2) {
        Iter.sendToSink(update2.getQuads(), this.createInsertDataSink());
    }

    @Override
    public Sink<Quad> createDeleteDataSink() {
        UpdateDataWriter udw = new UpdateDataWriter(UpdateDataWriter.UpdateMode.DELETE, this.out, this.sCxt);
        udw.open();
        return udw;
    }

    @Override
    public void visit(UpdateDataDelete update2) {
        Iter.sendToSink(update2.getQuads(), this.createDeleteDataSink());
    }

    protected void outputQuadsBraced(List<Quad> quads) {
        if (quads.size() == 0) {
            this.out.print("{ }");
            return;
        }
        SinkQuadBracedOutput sink = new SinkQuadBracedOutput(this.out, this.sCxt);
        sink.open();
        Iter.sendToSink(quads, sink);
    }

    protected void output(Node node) {
        String $ = FmtUtils.stringForNode(node, this.sCxt);
        this.out.print($);
    }

    @Override
    public void visit(UpdateDeleteWhere update2) {
        this.out.ensureStartOfLine();
        this.out.println("DELETE WHERE ");
        this.outputQuadsBraced(update2.getQuads());
    }

    @Override
    public void visit(UpdateModify update2) {
        this.out.ensureStartOfLine();
        if (update2.getWithIRI() != null) {
            this.out.print("WITH ");
            this.output(update2.getWithIRI());
        }
        if (update2.hasDeleteClause()) {
            List<Quad> deleteQuads = update2.getDeleteQuads();
            this.out.ensureStartOfLine();
            this.out.print("DELETE ");
            this.outputQuadsBraced(deleteQuads);
        }
        if (update2.hasInsertClause()) {
            List<Quad> insertQuads = update2.getInsertQuads();
            this.out.ensureStartOfLine();
            this.out.print("INSERT ");
            this.outputQuadsBraced(insertQuads);
        }
        if (!update2.hasInsertClause() && !update2.hasDeleteClause()) {
            this.out.ensureStartOfLine();
            this.out.println("INSERT { }");
        }
        for (Node x : update2.getUsing()) {
            this.out.ensureStartOfLine();
            this.out.print("USING ");
            this.output(x);
        }
        for (Node x : update2.getUsingNamed()) {
            this.out.ensureStartOfLine();
            this.out.print("USING NAMED ");
            this.output(x);
        }
        Element el = update2.getWherePattern();
        this.out.ensureStartOfLine();
        this.out.print("WHERE");
        this.out.incIndent(2);
        this.out.newline();
        if (el != null) {
            FormatterElement fmtElement = this.prepareElementFormatter();
            fmtElement.visitAsGroup(el);
        } else {
            this.out.print("{}");
        }
        this.out.decIndent(2);
    }

    protected FormatterElement prepareElementFormatter() {
        return new FormatterElement(this.out, this.sCxt);
    }
}

