/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.api.io;

import at.favre.lib.bytes.Bytes;
import edu.wisc.library.ocfl.api.exception.FixityCheckException;
import edu.wisc.library.ocfl.api.exception.OcflJavaException;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.util.Enforce;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FixityCheckInputStream
extends DigestInputStream {
    private boolean enabled = true;
    private final String expectedDigestValue;

    public FixityCheckInputStream(InputStream inputStream, DigestAlgorithm digestAlgorithm, String expectedDigestValue) {
        super(inputStream, digestAlgorithm.getMessageDigest());
        this.expectedDigestValue = Enforce.notBlank(expectedDigestValue, "expectedDigestValue cannot be blank");
    }

    public FixityCheckInputStream(InputStream inputStream, String digestAlgorithm, String expectedDigestValue) {
        super(inputStream, FixityCheckInputStream.messageDigest(digestAlgorithm));
        this.expectedDigestValue = Enforce.notBlank(expectedDigestValue, "expectedDigestValue cannot be blank");
    }

    public void checkFixity() {
        String actualDigest;
        if (this.enabled && !this.expectedDigestValue.equalsIgnoreCase(actualDigest = Bytes.wrap(this.digest.digest()).encodeHex())) {
            throw new FixityCheckException(String.format("Expected %s digest: %s; Actual: %s", this.digest.getAlgorithm(), this.expectedDigestValue, actualDigest));
        }
    }

    public String getExpectedDigestValue() {
        return this.expectedDigestValue;
    }

    public FixityCheckInputStream enableFixityCheck(boolean enabled) {
        this.on(enabled);
        return this;
    }

    @Override
    public void on(boolean on) {
        this.enabled = on;
        super.on(on);
    }

    @Override
    public String toString() {
        return "[Fixity Check Input Stream] expected: " + this.expectedDigestValue + "; actual: " + this.digest.toString();
    }

    private static MessageDigest messageDigest(String digestAlgorithm) {
        try {
            return MessageDigest.getInstance(digestAlgorithm);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new OcflJavaException(e2);
        }
    }
}

