/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core;

import edu.wisc.library.ocfl.api.OcflConfig;
import edu.wisc.library.ocfl.api.OcflFileRetriever;
import edu.wisc.library.ocfl.api.OcflObjectUpdater;
import edu.wisc.library.ocfl.api.OcflOption;
import edu.wisc.library.ocfl.api.OcflRepository;
import edu.wisc.library.ocfl.api.exception.AlreadyExistsException;
import edu.wisc.library.ocfl.api.exception.NotFoundException;
import edu.wisc.library.ocfl.api.exception.ObjectOutOfSyncException;
import edu.wisc.library.ocfl.api.exception.OcflIOException;
import edu.wisc.library.ocfl.api.exception.OcflStateException;
import edu.wisc.library.ocfl.api.model.FileChangeHistory;
import edu.wisc.library.ocfl.api.model.FileDetails;
import edu.wisc.library.ocfl.api.model.ObjectDetails;
import edu.wisc.library.ocfl.api.model.ObjectVersionId;
import edu.wisc.library.ocfl.api.model.OcflObjectVersion;
import edu.wisc.library.ocfl.api.model.OcflObjectVersionFile;
import edu.wisc.library.ocfl.api.model.VersionDetails;
import edu.wisc.library.ocfl.api.model.VersionInfo;
import edu.wisc.library.ocfl.api.model.VersionNum;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.DefaultOcflObjectUpdater;
import edu.wisc.library.ocfl.core.ObjectPaths;
import edu.wisc.library.ocfl.core.inventory.AddFileProcessor;
import edu.wisc.library.ocfl.core.inventory.InventoryMapper;
import edu.wisc.library.ocfl.core.inventory.InventoryUpdater;
import edu.wisc.library.ocfl.core.inventory.SidecarMapper;
import edu.wisc.library.ocfl.core.lock.ObjectLock;
import edu.wisc.library.ocfl.core.model.Inventory;
import edu.wisc.library.ocfl.core.model.RevisionNum;
import edu.wisc.library.ocfl.core.model.Version;
import edu.wisc.library.ocfl.core.path.ContentPathMapper;
import edu.wisc.library.ocfl.core.path.constraint.ContentPathConstraintProcessor;
import edu.wisc.library.ocfl.core.path.mapper.LogicalPathMapper;
import edu.wisc.library.ocfl.core.storage.OcflStorage;
import edu.wisc.library.ocfl.core.util.DigestUtil;
import edu.wisc.library.ocfl.core.util.FileUtil;
import edu.wisc.library.ocfl.core.util.ResponseMapper;
import edu.wisc.library.ocfl.core.util.UncheckedFiles;
import edu.wisc.library.ocfl.core.validation.InventoryValidator;
import edu.wisc.library.ocfl.core.validation.ObjectValidator;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Clock;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOcflRepository
implements OcflRepository {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOcflRepository.class);
    protected final OcflStorage storage;
    protected final InventoryMapper inventoryMapper;
    protected final Path workDir;
    protected final ObjectLock objectLock;
    protected final ObjectValidator objectValidator;
    protected final ResponseMapper responseMapper;
    protected final InventoryUpdater.Builder inventoryUpdaterBuilder;
    protected final AddFileProcessor.Builder addFileProcessorBuilder;
    protected final OcflConfig config;
    private Clock clock;
    private boolean closed = false;

    public DefaultOcflRepository(OcflStorage storage, Path workDir, ObjectLock objectLock, InventoryMapper inventoryMapper, LogicalPathMapper logicalPathMapper, ContentPathConstraintProcessor contentPathConstraintProcessor, OcflConfig config) {
        this.storage = Enforce.notNull(storage, "storage cannot be null");
        this.workDir = Enforce.notNull(workDir, "workDir cannot be null");
        this.objectLock = Enforce.notNull(objectLock, "objectLock cannot be null");
        this.inventoryMapper = Enforce.notNull(inventoryMapper, "inventoryMapper cannot be null");
        this.config = Enforce.notNull(config, "config cannot be null");
        this.inventoryUpdaterBuilder = InventoryUpdater.builder().contentPathMapperBuilder(ContentPathMapper.builder().logicalPathMapper(logicalPathMapper).contentPathConstraintProcessor(contentPathConstraintProcessor));
        this.objectValidator = new ObjectValidator(inventoryMapper);
        this.responseMapper = new ResponseMapper();
        this.clock = Clock.systemUTC();
        this.addFileProcessorBuilder = AddFileProcessor.builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectVersionId putObject(ObjectVersionId objectVersionId, Path path, VersionInfo versionInfo, OcflOption ... options) {
        this.ensureOpen();
        Enforce.notNull(objectVersionId, "objectId cannot be null");
        Enforce.notNull(path, "path cannot be null");
        LOG.debug("Putting object at <{}> into OCFL repo under id <{}>", (Object)path, (Object)objectVersionId.getObjectId());
        Inventory inventory = this.loadInventoryWithDefault(objectVersionId);
        this.ensureNoMutableHead(inventory);
        this.enforceObjectVersionForUpdate(objectVersionId, inventory);
        InventoryUpdater inventoryUpdater = this.inventoryUpdaterBuilder.buildBlankState(inventory);
        Path stagingDir = this.createStagingDir(objectVersionId.getObjectId());
        Path contentDir = this.createStagingContentDir(inventory, stagingDir);
        AddFileProcessor fileProcessor = this.addFileProcessorBuilder.build(inventoryUpdater, contentDir, inventory.getDigestAlgorithm());
        fileProcessor.processPath(path, options);
        Inventory newInventory = this.buildNewInventory(inventoryUpdater, versionInfo);
        try {
            this.writeNewVersion(newInventory, stagingDir);
            ObjectVersionId objectVersionId2 = ObjectVersionId.version(objectVersionId.getObjectId(), newInventory.getHead());
            return objectVersionId2;
        }
        finally {
            FileUtil.safeDeleteDirectory(stagingDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectVersionId updateObject(ObjectVersionId objectVersionId, VersionInfo versionInfo, Consumer<OcflObjectUpdater> objectUpdater) {
        this.ensureOpen();
        Enforce.notNull(objectVersionId, "objectId cannot be null");
        Enforce.notNull(objectUpdater, "objectUpdater cannot be null");
        LOG.debug("Update object <{}>", (Object)objectVersionId.getObjectId());
        Inventory inventory = this.loadInventoryWithDefault(objectVersionId);
        this.ensureNoMutableHead(inventory);
        this.enforceObjectVersionForUpdate(objectVersionId, inventory);
        Path stagingDir = this.createStagingDir(objectVersionId.getObjectId());
        Path contentDir = this.createStagingContentDir(inventory, stagingDir);
        InventoryUpdater inventoryUpdater = this.inventoryUpdaterBuilder.buildCopyState(inventory);
        AddFileProcessor addFileProcessor = this.addFileProcessorBuilder.build(inventoryUpdater, contentDir, inventory.getDigestAlgorithm());
        DefaultOcflObjectUpdater updater = new DefaultOcflObjectUpdater(inventory, inventoryUpdater, contentDir, addFileProcessor);
        try {
            objectUpdater.accept(updater);
            Inventory newInventory = this.buildNewInventory(inventoryUpdater, versionInfo);
            this.writeNewVersion(newInventory, stagingDir);
            ObjectVersionId objectVersionId2 = ObjectVersionId.version(objectVersionId.getObjectId(), newInventory.getHead());
            return objectVersionId2;
        }
        finally {
            FileUtil.safeDeleteDirectory(stagingDir);
        }
    }

    @Override
    public void getObject(ObjectVersionId objectVersionId, Path outputPath) {
        this.ensureOpen();
        Enforce.notNull(objectVersionId, "objectId cannot be null");
        this.ensureOutputPath(outputPath);
        LOG.debug("Get object <{}> and copy to <{}>", (Object)objectVersionId, (Object)outputPath);
        Inventory inventory = this.requireInventory(objectVersionId);
        VersionNum versionNum = this.requireVersion(objectVersionId, inventory);
        this.getObjectInternal(inventory, versionNum, outputPath);
    }

    @Override
    public OcflObjectVersion getObject(ObjectVersionId objectVersionId) {
        this.ensureOpen();
        Enforce.notNull(objectVersionId, "objectId cannot be null");
        LOG.debug("Get object <{}>", (Object)objectVersionId);
        Inventory inventory = this.requireInventory(objectVersionId);
        VersionNum versionNum = this.requireVersion(objectVersionId, inventory);
        VersionDetails versionDetails = this.createVersionDetails(inventory, versionNum);
        Map<String, OcflFileRetriever> objectStreams = this.storage.getObjectStreams(inventory, versionNum);
        Map<String, OcflObjectVersionFile> files = versionDetails.getFiles().stream().map(file -> new OcflObjectVersionFile((FileDetails)file, (OcflFileRetriever)objectStreams.get(file.getPath()))).collect(Collectors.toMap(OcflObjectVersionFile::getPath, v -> v));
        versionDetails.setFileMap(null);
        return new OcflObjectVersion(versionDetails, files);
    }

    @Override
    public ObjectDetails describeObject(String objectId) {
        this.ensureOpen();
        Enforce.notBlank(objectId, "objectId cannot be blank");
        LOG.debug("Describe object <{}>", (Object)objectId);
        Inventory inventory = this.requireInventory(ObjectVersionId.head(objectId));
        return this.responseMapper.mapInventory(inventory);
    }

    @Override
    public VersionDetails describeVersion(ObjectVersionId objectVersionId) {
        this.ensureOpen();
        Enforce.notNull(objectVersionId, "objectVersionId cannot be null");
        LOG.debug("Describe version <{}>", (Object)objectVersionId);
        Inventory inventory = this.requireInventory(objectVersionId);
        VersionNum versionNum = this.requireVersion(objectVersionId, inventory);
        return this.createVersionDetails(inventory, versionNum);
    }

    @Override
    public FileChangeHistory fileChangeHistory(String objectId, String logicalPath) {
        this.ensureOpen();
        Enforce.notBlank(objectId, "objectId cannot be blank");
        Enforce.notBlank(logicalPath, "logicalPath cannot be blank");
        LOG.debug("Get file change history for object <{}> logical path <{}>", (Object)objectId, (Object)logicalPath);
        Inventory inventory = this.requireInventory(ObjectVersionId.head(objectId));
        FileChangeHistory changeHistory = this.responseMapper.fileChangeHistory(inventory, logicalPath);
        if (changeHistory.getFileChanges().isEmpty()) {
            throw new NotFoundException(String.format("The logical path %s was not found in object %s.", logicalPath, objectId));
        }
        return changeHistory;
    }

    @Override
    public boolean containsObject(String objectId) {
        this.ensureOpen();
        Enforce.notBlank(objectId, "objectId cannot be blank");
        LOG.debug("Contains object <{}>", (Object)objectId);
        return this.storage.containsObject(objectId);
    }

    @Override
    public void purgeObject(String objectId) {
        this.ensureOpen();
        Enforce.notBlank(objectId, "objectId cannot be blank");
        LOG.info("Purge object <{}>", (Object)objectId);
        this.objectLock.doInWriteLock(objectId, () -> this.storage.purgeObject(objectId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectVersionId replicateVersionAsHead(ObjectVersionId objectVersionId, VersionInfo versionInfo) {
        this.ensureOpen();
        Enforce.notNull(objectVersionId, "objectVersionId cannot be null");
        LOG.debug("Replicate version <{}>", (Object)objectVersionId);
        Inventory inventory = this.requireInventory(objectVersionId);
        VersionNum versionNum = this.requireVersion(objectVersionId, inventory);
        this.ensureNoMutableHead(inventory);
        InventoryUpdater inventoryUpdater = this.inventoryUpdaterBuilder.buildCopyState(inventory, versionNum);
        Inventory newInventory = inventoryUpdater.buildNewInventory(this.now(versionInfo), versionInfo);
        Path stagingDir = this.createStagingDir(objectVersionId.getObjectId());
        this.createStagingContentDir(inventory, stagingDir);
        try {
            this.writeNewVersion(newInventory, stagingDir);
            ObjectVersionId objectVersionId2 = ObjectVersionId.version(objectVersionId.getObjectId(), newInventory.getHead());
            return objectVersionId2;
        }
        finally {
            FileUtil.safeDeleteDirectory(stagingDir);
        }
    }

    @Override
    public void rollbackToVersion(ObjectVersionId objectVersionId) {
        this.ensureOpen();
        Enforce.notNull(objectVersionId, "objectVersionId cannot be null");
        LOG.info("Rollback to version <{}>", (Object)objectVersionId);
        Inventory inventory = this.requireInventory(objectVersionId);
        VersionNum versionNum = this.requireVersion(objectVersionId, inventory);
        if (versionNum == inventory.getHead()) {
            LOG.debug("Object {} cannot be rollback to version {} because it is already the head version.", (Object)objectVersionId.getObjectId(), (Object)versionNum);
            return;
        }
        this.objectLock.doInWriteLock(inventory.getId(), () -> this.storage.rollbackToVersion(inventory, versionNum));
    }

    @Override
    public Stream<String> listObjectIds() {
        this.ensureOpen();
        LOG.debug("List object ids");
        return this.storage.listObjectIds();
    }

    @Override
    public void exportVersion(ObjectVersionId objectVersionId, Path outputPath, OcflOption ... options) {
        this.ensureOpen();
        Enforce.notNull(objectVersionId, "objectId cannot be null");
        this.ensureExportPath(outputPath);
        ObjectVersionId exportId = objectVersionId;
        if (objectVersionId.isHead()) {
            Inventory inventory = this.requireInventory(objectVersionId);
            VersionNum headVersion = inventory.getHead();
            exportId = ObjectVersionId.version(objectVersionId.getObjectId(), headVersion);
        }
        LOG.debug("Export <{}> to <{}>", (Object)objectVersionId, (Object)outputPath);
        this.storage.exportVersion(exportId, outputPath);
        if (!OcflOption.contains(OcflOption.NO_VALIDATION, options)) {
            this.objectValidator.validateVersion(outputPath, this.parseInventoryForImport(outputPath, false));
        }
    }

    @Override
    public void exportObject(String objectId, Path outputPath, OcflOption ... options) {
        this.ensureOpen();
        Enforce.notBlank(objectId, "objectId cannot be blank");
        this.ensureExportPath(outputPath);
        Inventory inventory = this.requireInventory(ObjectVersionId.head(objectId));
        LOG.debug("Export <{}> to <{}>", (Object)objectId, (Object)outputPath);
        this.objectLock.doInWriteLock(objectId, () -> this.storage.exportObject(objectId, outputPath));
        if (!OcflOption.contains(OcflOption.NO_VALIDATION, options)) {
            this.objectValidator.validateObject(outputPath, inventory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importVersion(Path versionPath, OcflOption ... options) {
        this.ensureOpen();
        Enforce.notNull(versionPath, "versionPath cannot be null");
        Inventory importInventory = this.createImportVersionInventory(versionPath);
        InventoryValidator.validateShallow(importInventory);
        if (!OcflOption.contains(OcflOption.NO_VALIDATION, options)) {
            this.objectValidator.validateVersion(versionPath, importInventory);
        }
        Path stagingDir = this.createStagingDir(importInventory.getId());
        try {
            this.importToStaging(versionPath, stagingDir, options);
            this.objectLock.doInWriteLock(importInventory.getId(), () -> this.storage.storeNewVersion(importInventory, stagingDir));
        }
        finally {
            FileUtil.safeDeleteDirectory(stagingDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importObject(Path objectPath, OcflOption ... options) {
        this.ensureOpen();
        Enforce.notNull(objectPath, "objectPath cannot be null");
        Inventory inventory = this.parseInventoryForImport(objectPath, true);
        String objectId = inventory.getId();
        if (this.containsObject(objectId)) {
            throw new AlreadyExistsException(String.format("Cannot import object at %s because an object already exists with ID %s.", objectPath, objectId));
        }
        if (OcflOption.contains(OcflOption.NO_VALIDATION, options)) {
            InventoryValidator.validateDeep(inventory);
        } else {
            this.objectValidator.validateObject(objectPath, inventory);
        }
        Path stagingDir = this.createStagingDir(objectId);
        try {
            this.importToStaging(objectPath, stagingDir, options);
            this.objectLock.doInWriteLock(objectId, () -> this.storage.importObject(objectId, stagingDir));
        }
        finally {
            FileUtil.safeDeleteDirectory(stagingDir);
        }
    }

    @Override
    public void close() {
        LOG.debug("Close OCFL repository");
        this.closed = true;
        this.storage.close();
    }

    @Override
    public OcflConfig config() {
        return new OcflConfig(this.config);
    }

    protected Inventory loadInventory(ObjectVersionId objectId) {
        return this.storage.loadInventory(objectId.getObjectId());
    }

    private Inventory loadInventoryWithDefault(ObjectVersionId objectId) {
        Inventory inventory = this.loadInventory(objectId);
        if (inventory == null) {
            inventory = this.createStubInventory(objectId);
        }
        return inventory;
    }

    protected Inventory createStubInventory(ObjectVersionId objectId) {
        String objectRootPath = this.storage.objectRootPath(objectId.getObjectId());
        return Inventory.stubInventory(objectId.getObjectId(), this.config, objectRootPath);
    }

    protected Inventory requireInventory(ObjectVersionId objectId) {
        Inventory inventory = this.loadInventory(objectId);
        if (inventory == null) {
            throw new NotFoundException(String.format("Object %s was not found.", objectId));
        }
        return inventory;
    }

    protected Inventory buildNewInventory(InventoryUpdater inventoryUpdater, VersionInfo versionInfo) {
        return InventoryValidator.validateShallow(inventoryUpdater.buildNewInventory(this.now(versionInfo), versionInfo));
    }

    private void getObjectInternal(Inventory inventory, VersionNum versionNum, Path outputPath) {
        Path stagingDir = this.createStagingDir(inventory.getId());
        try {
            this.storage.reconstructObjectVersion(inventory, versionNum, stagingDir);
            FileUtil.moveDirectory(stagingDir, outputPath);
        }
        catch (FileAlreadyExistsException e2) {
            throw new OcflIOException(e2);
        }
        finally {
            FileUtil.safeDeleteDirectory(stagingDir);
        }
    }

    protected void writeNewVersion(Inventory inventory, Path stagingDir) {
        Inventory finalInventory = this.writeInventory(inventory, stagingDir);
        this.objectLock.doInWriteLock(inventory.getId(), () -> this.storage.storeNewVersion(finalInventory, stagingDir));
    }

    protected Inventory writeInventory(Inventory inventory, Path stagingDir) {
        Path inventoryPath = ObjectPaths.inventoryPath(stagingDir);
        this.inventoryMapper.write(inventoryPath, inventory);
        String inventoryDigest = DigestUtil.computeDigestHex(inventory.getDigestAlgorithm(), inventoryPath);
        SidecarMapper.writeSidecar(inventory, inventoryDigest, stagingDir);
        return inventory.buildFrom().currentDigest(inventoryDigest).build();
    }

    private Inventory createImportVersionInventory(Path versionPath) {
        Inventory importInventory = this.parseInventoryForImport(versionPath, false);
        String objectId = importInventory.getId();
        Inventory existingInventory = this.loadInventory(ObjectVersionId.head(objectId));
        String existingDigest = null;
        this.ensureNoMutableHead(existingInventory);
        if (existingInventory == null) {
            if (!VersionNum.V1.equals(importInventory.getHead())) {
                throw new OcflStateException(String.format("Cannot import object %s version %s from source %s. The object doest not exist in the repository; therefore only v1 may be imported.", objectId, importInventory.getHead(), versionPath));
            }
        } else {
            if (!existingInventory.getHead().nextVersionNum().equals(importInventory.getHead())) {
                throw new OcflStateException(String.format("Cannot import object %s version %s from source %s. The import version must be the next sequential version, and the current version is %s.", objectId, importInventory.getHead(), versionPath, existingInventory.getHead()));
            }
            InventoryValidator.validateCompatibleInventories(importInventory, existingInventory);
            existingDigest = existingInventory.getCurrentDigest();
        }
        String objectRootPath = this.storage.objectRootPath(objectId);
        return importInventory.buildFrom().objectRootPath(objectRootPath).previousDigest(existingDigest).build();
    }

    private Inventory parseInventoryForImport(Path path, boolean lookForMutableHead) {
        Path mutableInventory;
        Path inventoryPath = null;
        Path sidecarPath = null;
        boolean hasMutableHead = false;
        if (lookForMutableHead && Files.exists(mutableInventory = ObjectPaths.mutableHeadInventoryPath(path), new LinkOption[0])) {
            inventoryPath = mutableInventory;
            sidecarPath = ObjectPaths.findInventorySidecarPath(path);
            hasMutableHead = true;
        }
        if (!hasMutableHead) {
            inventoryPath = ObjectPaths.inventoryPath(path);
            sidecarPath = ObjectPaths.findInventorySidecarPath(path);
        }
        Enforce.expressionTrue(Files.exists(inventoryPath, new LinkOption[0]), inventoryPath, "inventory.json must exist");
        Enforce.expressionTrue(Files.exists(sidecarPath, new LinkOption[0]), sidecarPath, "inventory sidecar must exist");
        if (hasMutableHead) {
            return this.inventoryMapper.readMutableHead(path.toString(), SidecarMapper.readDigest(sidecarPath), RevisionNum.R1, inventoryPath);
        }
        return this.inventoryMapper.read(path.toString(), SidecarMapper.readDigest(sidecarPath), inventoryPath);
    }

    private void importToStaging(Path source, Path stagingDir, OcflOption ... options) {
        if (OcflOption.contains(OcflOption.MOVE_SOURCE, options)) {
            UncheckedFiles.delete(stagingDir);
            try {
                FileUtil.moveDirectory(source, stagingDir);
            }
            catch (FileAlreadyExistsException e2) {
                throw new OcflIOException(e2);
            }
        } else {
            FileUtil.recursiveCopy(source, stagingDir, new StandardCopyOption[0]);
        }
    }

    protected void enforceObjectVersionForUpdate(ObjectVersionId objectId, Inventory inventory) {
        if (!objectId.isHead() && !objectId.getVersionNum().equals(inventory.getHead())) {
            throw new ObjectOutOfSyncException(String.format("Cannot update object %s because the HEAD version is %s, but version %s was specified.", objectId.getObjectId(), inventory.getHead(), objectId.getVersionNum()));
        }
    }

    private void ensureNoMutableHead(Inventory inventory) {
        if (inventory != null && inventory.hasMutableHead()) {
            throw new OcflStateException(String.format("Cannot create a new version of object %s because it has an active mutable HEAD.", inventory.getId()));
        }
    }

    private VersionNum requireVersion(ObjectVersionId objectId, Inventory inventory) {
        if (objectId.isHead()) {
            return inventory.getHead();
        }
        if (inventory.getVersion(objectId.getVersionNum()) == null) {
            throw new NotFoundException(String.format("Object %s version %s was not found.", objectId.getObjectId(), objectId.getVersionNum()));
        }
        return objectId.getVersionNum();
    }

    protected Path createStagingDir(String objectId) {
        return FileUtil.createObjectTempDir(this.workDir, objectId);
    }

    private Path createStagingContentDir(Inventory inventory, Path stagingDir) {
        return UncheckedFiles.createDirectories(this.resolveContentDir(inventory, stagingDir));
    }

    protected Path resolveContentDir(Inventory inventory, Path parent) {
        return parent.resolve(inventory.resolveContentDirectory());
    }

    private VersionDetails createVersionDetails(Inventory inventory, VersionNum versionNum) {
        Version version2 = inventory.getVersion(versionNum);
        return this.responseMapper.mapVersion(inventory, versionNum, version2);
    }

    protected OffsetDateTime now(VersionInfo versionInfo) {
        if (versionInfo != null && versionInfo.getCreated() != null) {
            return versionInfo.getCreated();
        }
        return OffsetDateTime.now(this.clock);
    }

    protected void ensureOpen() {
        if (this.closed) {
            throw new OcflStateException(DefaultOcflRepository.class.getName() + " is closed.");
        }
    }

    private void ensureOutputPath(Path outputPath) {
        Enforce.notNull(outputPath, "outputPath cannot be null");
        Enforce.expressionTrue(Files.notExists(outputPath, new LinkOption[0]), outputPath, "outputPath must not exist");
        Enforce.expressionTrue(Files.exists(outputPath.getParent(), new LinkOption[0]), outputPath, "outputPath parent must exist");
        Enforce.expressionTrue(Files.isDirectory(outputPath.getParent(), new LinkOption[0]), outputPath, "outputPath parent must be a directory");
    }

    private void ensureExportPath(Path outputPath) {
        Enforce.notNull(outputPath, "outputPath cannot be null");
        if (Files.exists(outputPath, new LinkOption[0])) {
            Enforce.expressionTrue(Files.isDirectory(outputPath, new LinkOption[0]), outputPath, "outputPath must be a directory");
        }
        UncheckedFiles.createDirectories(outputPath);
    }

    public void setClock(Clock clock) {
        this.clock = Enforce.notNull(clock, "clock cannot be null");
    }
}

