/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.db;

import edu.wisc.library.ocfl.api.exception.OcflJavaException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.db.BaseObjectDetailsDatabase;
import edu.wisc.library.ocfl.core.db.DbType;
import edu.wisc.library.ocfl.core.db.H2ObjectDetailsDatabase;
import edu.wisc.library.ocfl.core.db.ObjectDetailsDatabase;
import edu.wisc.library.ocfl.core.db.PostgresObjectDetailsDatabase;
import edu.wisc.library.ocfl.core.db.TableCreator;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public class ObjectDetailsDatabaseBuilder {
    private boolean storeInventory = true;
    private long waitTime = 10L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private DataSource dataSource;

    public ObjectDetailsDatabaseBuilder storeInventory(boolean storeInventory) {
        this.storeInventory = storeInventory;
        return this;
    }

    public ObjectDetailsDatabaseBuilder waitTime(long waitTime, TimeUnit timeUnit) {
        this.waitTime = Enforce.expressionTrue(waitTime > 0L, waitTime, "waitTime must be greater than 0");
        this.timeUnit = Enforce.notNull(timeUnit, "timeUnit cannot be null");
        return this;
    }

    public ObjectDetailsDatabaseBuilder dataSource(DataSource dataSource) {
        this.dataSource = Enforce.notNull(dataSource, "dataSource cannot be null");
        return this;
    }

    public ObjectDetailsDatabase build() {
        BaseObjectDetailsDatabase database;
        Enforce.notNull(this.dataSource, "dataSource cannot be null");
        DbType dbType = DbType.fromDataSource(this.dataSource);
        switch (dbType) {
            case POSTGRES: {
                database = new PostgresObjectDetailsDatabase(this.dataSource, this.storeInventory, this.waitTime, this.timeUnit);
                break;
            }
            case H2: {
                database = new H2ObjectDetailsDatabase(this.dataSource, this.storeInventory, this.waitTime, this.timeUnit);
                break;
            }
            default: {
                throw new OcflJavaException(String.format("Database type %s is not mapped to an ObjectDetailsDatabase implementation.", new Object[]{dbType}));
            }
        }
        new TableCreator(dbType, this.dataSource).createObjectDetailsTable();
        return database;
    }
}

