/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.extension.storage.layout.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import java.util.Objects;

public class HashedTruncatedNTupleConfig
implements OcflExtensionConfig {
    private DigestAlgorithm digestAlgorithm = DigestAlgorithm.sha256;
    private int tupleSize = 3;
    private int numberOfTuples = 3;
    private boolean shortObjectRoot = false;

    @Override
    @JsonIgnore
    public String getExtensionName() {
        return "0003-hashed-n-tuple-trees";
    }

    @Override
    @JsonIgnore
    public boolean hasParameters() {
        return true;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public HashedTruncatedNTupleConfig setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = Enforce.notNull(digestAlgorithm, "digestAlgorithm cannot be null");
        return this;
    }

    public int getTupleSize() {
        return this.tupleSize;
    }

    public HashedTruncatedNTupleConfig setTupleSize(int tupleSize) {
        this.tupleSize = Enforce.expressionTrue(tupleSize >= 0 && tupleSize <= 32, tupleSize, "tupleSize must be between 0 and 32 inclusive");
        return this;
    }

    public int getNumberOfTuples() {
        return this.numberOfTuples;
    }

    public HashedTruncatedNTupleConfig setNumberOfTuples(int numberOfTuples) {
        this.numberOfTuples = Enforce.expressionTrue(numberOfTuples >= 0 && numberOfTuples <= 32, numberOfTuples, "numberOfTuples must be between 0 and 32 inclusive");
        return this;
    }

    public boolean isShortObjectRoot() {
        return this.shortObjectRoot;
    }

    public HashedTruncatedNTupleConfig setShortObjectRoot(boolean shortObjectRoot) {
        this.shortObjectRoot = shortObjectRoot;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashedTruncatedNTupleConfig that = (HashedTruncatedNTupleConfig)o;
        return this.tupleSize == that.tupleSize && this.numberOfTuples == that.numberOfTuples && this.shortObjectRoot == that.shortObjectRoot && this.digestAlgorithm.equals(that.digestAlgorithm);
    }

    public int hashCode() {
        return Objects.hash(this.digestAlgorithm, this.tupleSize, this.numberOfTuples, this.shortObjectRoot);
    }

    public String toString() {
        return "HashedTruncatedNTupleConfig{digestAlgorithm=" + this.digestAlgorithm.getOcflName() + ", tupleSize=" + this.tupleSize + ", numberOfTuples=" + this.numberOfTuples + ", shortObjectRoot=" + this.shortObjectRoot + "}";
    }
}

