/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.lock;

import edu.wisc.library.ocfl.api.exception.OcflJavaException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.db.DbType;
import edu.wisc.library.ocfl.core.db.TableCreator;
import edu.wisc.library.ocfl.core.lock.H2ObjectLock;
import edu.wisc.library.ocfl.core.lock.InMemoryObjectLock;
import edu.wisc.library.ocfl.core.lock.ObjectLock;
import edu.wisc.library.ocfl.core.lock.PostgresObjectLock;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public class ObjectLockBuilder {
    private long waitTime = 10L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private DataSource dataSource;

    public ObjectLockBuilder waitTime(long waitTime, TimeUnit timeUnit) {
        this.waitTime = Enforce.expressionTrue(waitTime > 0L, waitTime, "waitTime must be greater than 0");
        this.timeUnit = Enforce.notNull(timeUnit, "timeUnit cannot be null");
        return this;
    }

    public ObjectLockBuilder dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public ObjectLock build() {
        if (this.dataSource == null) {
            return this.buildMemLock();
        }
        return this.buildDbLock();
    }

    private ObjectLock buildDbLock() {
        ObjectLock lock;
        Enforce.notNull(this.dataSource, "dataSource cannot be null");
        DbType dbType = DbType.fromDataSource(this.dataSource);
        switch (dbType) {
            case POSTGRES: {
                lock = new PostgresObjectLock(this.dataSource, this.waitTime, this.timeUnit);
                break;
            }
            case H2: {
                lock = new H2ObjectLock(this.dataSource, this.waitTime, this.timeUnit);
                break;
            }
            default: {
                throw new OcflJavaException(String.format("Database type %s is not mapped to an ObjectLock implementation.", new Object[]{dbType}));
            }
        }
        new TableCreator(dbType, this.dataSource).createObjectLockTable();
        return lock;
    }

    private ObjectLock buildMemLock() {
        return new InMemoryObjectLock(this.waitTime, this.timeUnit);
    }
}

