/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.model;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.wisc.library.ocfl.api.OcflConfig;
import edu.wisc.library.ocfl.api.OcflConstants;
import edu.wisc.library.ocfl.api.exception.NotFoundException;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.model.InventoryType;
import edu.wisc.library.ocfl.api.model.VersionNum;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.model.InventoryBuilder;
import edu.wisc.library.ocfl.core.model.PathBiMap;
import edu.wisc.library.ocfl.core.model.RevisionNum;
import edu.wisc.library.ocfl.core.model.Version;
import edu.wisc.library.ocfl.core.util.FileUtil;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

@JsonDeserialize(builder=JacksonBuilder.class)
@JsonPropertyOrder(value={"id", "type", "digestAlgorithm", "head", "contentDirectory", "fixity", "manifest", "versions"})
public class Inventory {
    private final String id;
    private final InventoryType type;
    private final DigestAlgorithm digestAlgorithm;
    private final VersionNum head;
    private final String contentDirectory;
    @JsonIgnore
    private final Map<DigestAlgorithm, PathBiMap> fixityBiMap;
    @JsonIgnore
    private final PathBiMap manifestBiMap;
    private final Map<VersionNum, Version> versions;
    @JsonIgnore
    private final RevisionNum revisionNum;
    @JsonIgnore
    private final boolean mutableHead;
    @JsonIgnore
    private final String objectRootPath;
    @JsonIgnore
    private final String previousDigest;
    @JsonIgnore
    private final String currentDigest;

    public static Inventory stubInventory(String id, OcflConfig config, String objectRootPath) {
        return new Inventory(id, config.getOcflVersion().getInventoryType(), config.getDefaultDigestAlgorithm(), config.getDefaultContentDirectory(), objectRootPath);
    }

    public static InventoryBuilder builder() {
        return new InventoryBuilder();
    }

    public static InventoryBuilder builderFromStub(String id, OcflConfig config, String objectRootPath) {
        return Inventory.stubInventory(id, config, objectRootPath).buildFrom();
    }

    public Inventory(String id, InventoryType type, DigestAlgorithm digestAlgorithm, VersionNum head, String contentDirectory, Map<DigestAlgorithm, Map<String, Set<String>>> fixity, Map<String, Set<String>> manifest, Map<VersionNum, Version> versions, boolean mutableHead, RevisionNum revisionNum, String objectRootPath, String previousDigest, String currentDigest) {
        this.id = Enforce.notBlank(id, "id cannot be blank");
        this.type = Enforce.notNull(type, "type cannot be null");
        this.digestAlgorithm = Enforce.notNull(digestAlgorithm, "digestAlgorithm cannot be null");
        Enforce.expressionTrue(OcflConstants.ALLOWED_DIGEST_ALGORITHMS.contains(digestAlgorithm), digestAlgorithm, "digestAlgorithm must be sha512 or sha256");
        this.head = Enforce.notNull(head, "head cannot be null");
        this.contentDirectory = contentDirectory;
        this.fixityBiMap = Inventory.createFixityBiMap(fixity);
        this.manifestBiMap = PathBiMap.fromFileIdMap(manifest);
        TreeMap tree = new TreeMap(Comparator.naturalOrder());
        tree.putAll(versions);
        this.versions = Collections.unmodifiableMap(tree);
        this.mutableHead = mutableHead;
        this.revisionNum = revisionNum;
        this.objectRootPath = Enforce.notBlank(objectRootPath, "objectRootPath cannot be blank");
        this.previousDigest = previousDigest;
        this.currentDigest = currentDigest;
    }

    private Inventory(String id, InventoryType type, DigestAlgorithm digestAlgorithm, String contentDirectory, String objectRootPath) {
        this.id = Enforce.notBlank(id, "id cannot be blank");
        this.type = Enforce.notNull(type, "type cannot be null");
        this.digestAlgorithm = Enforce.notNull(digestAlgorithm, "digestAlgorithm cannot be null");
        this.head = new VersionNum(0L);
        this.contentDirectory = contentDirectory;
        this.fixityBiMap = Collections.emptyMap();
        this.manifestBiMap = new PathBiMap();
        this.versions = Collections.emptyMap();
        this.mutableHead = false;
        this.revisionNum = null;
        this.objectRootPath = Enforce.notBlank(objectRootPath, "objectRootPath cannot be null");
        this.previousDigest = null;
        this.currentDigest = null;
    }

    public InventoryBuilder buildFrom() {
        return new InventoryBuilder(this);
    }

    public InventoryBuilder buildNextVersionFrom() {
        return this.buildFrom().previousDigest(this.getCurrentDigest()).currentDigest(null);
    }

    private static Map<DigestAlgorithm, PathBiMap> createFixityBiMap(Map<DigestAlgorithm, Map<String, Set<String>>> fixity) {
        HashMap map = new HashMap();
        fixity.forEach((algorithm, values) -> map.put(algorithm, PathBiMap.fromFileIdMap(values)));
        return Collections.unmodifiableMap(map);
    }

    @JsonGetter(value="digestAlgorithm")
    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="head")
    public VersionNum getHead() {
        return this.head;
    }

    @JsonGetter(value="type")
    public InventoryType getType() {
        return this.type;
    }

    @JsonGetter(value="fixity")
    public Map<DigestAlgorithm, Map<String, Set<String>>> getFixity() {
        HashMap<DigestAlgorithm, Map<String, Set<String>>> fixity = new HashMap<DigestAlgorithm, Map<String, Set<String>>>();
        this.fixityBiMap.forEach((algorithm, map) -> fixity.put((DigestAlgorithm)algorithm, map.getFileIdToPaths()));
        return fixity;
    }

    @JsonGetter(value="manifest")
    public Map<String, Set<String>> getManifest() {
        return this.manifestBiMap.getFileIdToPaths();
    }

    @JsonGetter(value="versions")
    public Map<VersionNum, Version> getVersions() {
        return this.versions;
    }

    @JsonGetter(value="contentDirectory")
    public String getContentDirectory() {
        return this.contentDirectory;
    }

    public String resolveContentDirectory() {
        return Objects.requireNonNullElse(this.contentDirectory, "content");
    }

    @JsonIgnore
    public Version getHeadVersion() {
        return this.versions.get(this.head);
    }

    public Version getVersion(VersionNum versionNum) {
        return this.versions.get(versionNum);
    }

    public Version ensureVersion(VersionNum versionNum) {
        Version version2 = this.getVersion(versionNum);
        if (version2 == null) {
            throw new NotFoundException(String.format("Object %s does not contain version %s", this.id, versionNum));
        }
        return version2;
    }

    public boolean manifestContainsFileId(String fileId) {
        return this.manifestBiMap.containsFileId(fileId);
    }

    public String getFileId(String path) {
        return this.manifestBiMap.getFileId(path);
    }

    public String getFileId(Path path) {
        return this.manifestBiMap.getFileId(FileUtil.pathToStringStandardSeparator(path));
    }

    public Set<String> getContentPaths(String fileId) {
        return this.manifestBiMap.getPaths(fileId);
    }

    public String getContentPath(String fileId) {
        Set<String> paths = this.manifestBiMap.getPaths(fileId);
        if (paths.isEmpty()) {
            return null;
        }
        return paths.iterator().next();
    }

    public String ensureContentPath(String fileId) {
        if (!this.manifestContainsFileId(fileId)) {
            throw new NotFoundException(String.format("Missing manifest entry for %s in object %s.", fileId, this.id));
        }
        return this.getContentPath(fileId);
    }

    public String storagePath(String fileId) {
        return FileUtil.pathJoinFailEmpty(this.objectRootPath, this.ensureContentPath(fileId));
    }

    public Set<String> getFileIdsForMatchingFiles(Path path) {
        return this.getFileIdsForMatchingFiles(FileUtil.pathToStringStandardSeparator(path));
    }

    public Set<String> getFileIdsForMatchingFiles(String path) {
        String pathStr = path + "/";
        HashSet<String> set = new HashSet<String>();
        this.manifestBiMap.getPathToFileId().forEach((contentPath, id) -> {
            if (contentPath.startsWith(pathStr)) {
                set.add((String)id);
            }
        });
        return set;
    }

    @JsonIgnore
    public RevisionNum getRevisionNum() {
        return this.revisionNum;
    }

    public boolean hasMutableHead() {
        return this.mutableHead;
    }

    @JsonIgnore
    public String getObjectRootPath() {
        return this.objectRootPath;
    }

    @JsonIgnore
    public String getPreviousDigest() {
        return this.previousDigest;
    }

    @JsonIgnore
    public String getCurrentDigest() {
        return this.currentDigest;
    }

    public VersionNum nextVersionNum() {
        if (this.mutableHead) {
            return this.head;
        }
        return this.head.nextVersionNum();
    }

    public RevisionNum nextRevisionNum() {
        if (this.revisionNum == null) {
            return new RevisionNum(1L);
        }
        return this.revisionNum.nextRevisionNum();
    }

    public Map<DigestAlgorithm, String> getFixityForContentPath(String contentPath) {
        HashMap<DigestAlgorithm, String> fixity = new HashMap<DigestAlgorithm, String>();
        this.fixityBiMap.forEach((algorithm, map) -> {
            if (map.containsPath(contentPath)) {
                fixity.put((DigestAlgorithm)algorithm, map.getFileId(contentPath));
            }
        });
        return fixity;
    }

    public String toString() {
        return "Inventory{id='" + this.id + "', type=" + this.type + ", digestAlgorithm=" + this.digestAlgorithm + ", head=" + this.head + ", contentDirectory='" + this.contentDirectory + "', fixityBiMap=" + this.fixityBiMap + ", manifestBiMap=" + this.manifestBiMap + ", versions=" + this.versions + ", revisionNum=" + this.revisionNum + ", mutableHead=" + this.mutableHead + ", objectRootPath='" + this.objectRootPath + "', previousDigest='" + this.previousDigest + "', currentDigest='" + this.currentDigest + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Inventory inventory = (Inventory)o;
        return this.mutableHead == inventory.mutableHead && this.id.equals(inventory.id) && this.type == inventory.type && this.digestAlgorithm.equals(inventory.digestAlgorithm) && this.head.equals(inventory.head) && Objects.equals(this.contentDirectory, inventory.contentDirectory) && this.fixityBiMap.equals(inventory.fixityBiMap) && this.manifestBiMap.equals(inventory.manifestBiMap) && this.versions.equals(inventory.versions) && Objects.equals(this.revisionNum, inventory.revisionNum) && this.objectRootPath.equals(inventory.objectRootPath) && Objects.equals(this.previousDigest, inventory.previousDigest) && Objects.equals(this.currentDigest, inventory.currentDigest);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.digestAlgorithm, this.head, this.contentDirectory, this.fixityBiMap, this.manifestBiMap, this.versions, this.revisionNum, this.mutableHead, this.objectRootPath, this.previousDigest, this.currentDigest});
    }

    @JsonPOJOBuilder
    public static class JacksonBuilder {
        String id;
        InventoryType type;
        DigestAlgorithm digestAlgorithm;
        VersionNum head;
        String contentDirectory;
        Map<DigestAlgorithm, Map<String, Set<String>>> fixity;
        Map<String, Set<String>> manifest;
        Map<VersionNum, Version> versions;
        boolean mutableHead;
        RevisionNum revisionNum;
        String objectRootPath;
        String previousDigest;
        String currentDigest;

        public void withId(String id) {
            this.id = id;
        }

        public void withType(InventoryType type) {
            this.type = type;
        }

        public void withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            this.digestAlgorithm = digestAlgorithm;
        }

        public void withHead(VersionNum head) {
            this.head = head;
        }

        public void withContentDirectory(String contentDirectory) {
            this.contentDirectory = contentDirectory;
        }

        public void withFixity(Map<DigestAlgorithm, Map<String, Set<String>>> fixity) {
            this.fixity = fixity;
        }

        public void withManifest(Map<String, Set<String>> manifest) {
            this.manifest = manifest;
        }

        public void withVersions(Map<VersionNum, Version> versions) {
            this.versions = versions;
        }

        @JacksonInject(value="mutableHead")
        public void withMutableHead(boolean mutableHead) {
            this.mutableHead = mutableHead;
        }

        @JacksonInject(value="revisionNum")
        public void withRevisionNum(RevisionNum revisionNum) {
            this.revisionNum = revisionNum;
        }

        @JacksonInject(value="objectRootPath")
        public void withObjectRootPath(String objectRootPath) {
            this.objectRootPath = objectRootPath;
        }

        @JacksonInject(value="currentDigest")
        public void withCurrentDigest(String currentDigest) {
            this.currentDigest = currentDigest;
        }

        public Inventory build() {
            return new Inventory(this.id, this.type, this.digestAlgorithm, this.head, this.contentDirectory, this.fixity, this.manifest, this.versions, this.mutableHead, this.revisionNum, this.objectRootPath, this.previousDigest, this.currentDigest);
        }
    }
}

