/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import com.hp.hpl.jena.graph.Node;
import java.util.Iterator;
import org.apache.jena.riot.lang.LangBase;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LangNTuple<X>
extends LangBase
implements Iterator<X> {
    private static Logger log = LoggerFactory.getLogger(LangNTuple.class);
    protected boolean skipOnBadTerm = false;

    protected LangNTuple(Tokenizer tokens2, ParserProfile profile2, StreamRDF dest) {
        super(tokens2, profile2, dest);
    }

    @Override
    public final boolean hasNext() {
        return super.moreTokens();
    }

    @Override
    public final X next() {
        return this.parseOne();
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract X parseOne();

    protected void skipOne(X object, String printForm, long line, long col) {
        this.profile.getHandler().warning("Skip: " + printForm, line, col);
    }

    protected abstract Node tokenAsNode(Token var1);

    protected final void checkIRIOrBNode(Token token) {
        if (token.hasType(TokenType.IRI)) {
            return;
        }
        if (token.hasType(TokenType.BNODE)) {
            return;
        }
        this.exception(token, "Expected BNode or IRI: Got: %s", token);
    }

    protected final void checkIRI(Token token) {
        if (token.hasType(TokenType.IRI)) {
            return;
        }
        this.exception(token, "Expected IRI: Got: %s", token);
    }

    protected final void checkRDFTerm(Token token) {
        switch (token.getType()) {
            case IRI: 
            case BNODE: 
            case STRING2: {
                return;
            }
            case LITERAL_DT: {
                if (this.profile.isStrictMode() && !token.getSubToken1().hasType(TokenType.STRING2)) {
                    this.exception(token, "Illegal single quoted string: %s", token);
                }
                return;
            }
            case LITERAL_LANG: {
                if (this.profile.isStrictMode() && !token.getSubToken1().hasType(TokenType.STRING2)) {
                    this.exception(token, "Illegal single quoted string: %s", token);
                }
                return;
            }
            case STRING1: {
                if (!this.profile.isStrictMode()) break;
                this.exception(token, "Illegal single quoted string: %s", token);
                break;
            }
            default: {
                this.exception(token, "Illegal object: %s", token);
            }
        }
    }

    public boolean getSkipOnBadTerm() {
        return this.skipOnBadTerm;
    }

    public void setSkipOnBadTerm(boolean skipOnBadTerm) {
        this.skipOnBadTerm = skipOnBadTerm;
    }
}

