/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import com.hp.hpl.jena.sparql.lang.ParserBase;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.riot.out.CharSpace;
import org.apache.jena.riot.out.OutputUtils;

public class EscapeStr {
    private final boolean ascii;

    public EscapeStr(CharSpace charSpace) {
        this.ascii = charSpace == CharSpace.ASCII;
    }

    public void writeURI(AWriter w, String s2) {
        if (this.ascii) {
            EscapeStr.stringEsc(w, s2, true, this.ascii);
        } else {
            w.print(s2);
        }
    }

    public void writeStr(AWriter w, String s2) {
        EscapeStr.stringEsc(w, s2, true, this.ascii);
    }

    public void writeStrMultiLine(AWriter w, String s2) {
        EscapeStr.stringEsc(w, s2, false, this.ascii);
    }

    public static String stringEsc(String s2) {
        return EscapeStr.stringEsc(s2, true, false);
    }

    private static String stringEsc(String s2, boolean singleLineString, boolean asciiOnly) {
        IndentedLineBuffer sb = new IndentedLineBuffer();
        EscapeStr.stringEsc(sb, s2, singleLineString, asciiOnly);
        return sb.toString();
    }

    public static void stringEsc(AWriter out, String s2, boolean singleLineString, boolean asciiOnly) {
        int len = s2.length();
        for (int i = 0; i < len; ++i) {
            char c = s2.charAt(i);
            if (c == '\\') {
                out.print('\\');
                out.print(c);
                continue;
            }
            if (singleLineString) {
                if (c == '\"') {
                    out.print("\\\"");
                    continue;
                }
                if (c == '\n') {
                    out.print("\\n");
                    continue;
                }
                if (c == '\t') {
                    out.print("\\t");
                    continue;
                }
                if (c == '\r') {
                    out.print("\\r");
                    continue;
                }
                if (c == '\f') {
                    out.print("\\f");
                    continue;
                }
            }
            if (c >= ' ' && c < '\u007f') {
                out.print(c);
                continue;
            }
            if (!asciiOnly) {
                out.print(c);
                continue;
            }
            out.print("\\u");
            OutputUtils.printHex(out, (int)c, 4);
        }
    }

    public static String unescapeStr(String s2) {
        return EscapeStr.unescape(s2, '\\');
    }

    public static String unescape(String s2, char escape) {
        return ParserBase.unescape(s2, escape, false, -1, -1);
    }
}

