/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.riot.out.CharSpace;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterNT;
import org.apache.jena.riot.system.StreamRDF;

public class WriterStreamRDFPlain
implements StreamRDF {
    protected final AWriter out;
    protected final NodeFormatter nodeFmt;

    public WriterStreamRDFPlain(AWriter w) {
        this(w, CharSpace.UTF8);
    }

    public WriterStreamRDFPlain(AWriter w, CharSpace charSpace) {
        this.out = w;
        this.nodeFmt = new NodeFormatterNT(charSpace);
    }

    @Override
    public void start() {
    }

    @Override
    public void finish() {
        IO.flush(this.out);
    }

    @Override
    public void triple(Triple triple) {
        Node s2 = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        this.format(s2);
        this.out.print(" ");
        this.format(p);
        this.out.print(" ");
        this.format(o);
        this.out.print(" .\n");
    }

    @Override
    public void quad(Quad quad) {
        Node s2 = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        Node g2 = quad.getGraph();
        this.format(s2);
        this.out.print(" ");
        this.format(p);
        this.out.print(" ");
        this.format(o);
        if (WriterStreamRDFPlain.outputGraphSlot(g2)) {
            this.out.print(" ");
            this.format(g2);
        }
        this.out.print(" .\n");
    }

    private void format(Node n) {
        this.nodeFmt.format(this.out, n);
    }

    @Override
    public void base(String base) {
    }

    @Override
    public void prefix(String prefix, String iri2) {
    }

    private static boolean outputGraphSlot(Node g2) {
        return g2 != null && g2 != Quad.tripleInQuad && !Quad.isDefaultGraph(g2);
    }
}

