/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MergeInfo;

public abstract class MergePolicy {
    protected static final double DEFAULT_NO_CFS_RATIO = 1.0;
    protected static final long DEFAULT_MAX_CFS_SEGMENT_SIZE = Long.MAX_VALUE;
    protected double noCFSRatio = 1.0;
    protected long maxCFSSegmentSize = Long.MAX_VALUE;

    public MergePolicy() {
        this(1.0, Long.MAX_VALUE);
    }

    protected MergePolicy(double defaultNoCFSRatio, long defaultMaxCFSSegmentSize) {
        this.noCFSRatio = defaultNoCFSRatio;
        this.maxCFSSegmentSize = defaultMaxCFSSegmentSize;
    }

    public abstract MergeSpecification findMerges(MergeTrigger var1, SegmentInfos var2, IndexWriter var3) throws IOException;

    public abstract MergeSpecification findForcedMerges(SegmentInfos var1, int var2, Map<SegmentCommitInfo, Boolean> var3, IndexWriter var4) throws IOException;

    public abstract MergeSpecification findForcedDeletesMerges(SegmentInfos var1, IndexWriter var2) throws IOException;

    public boolean useCompoundFile(SegmentInfos infos, SegmentCommitInfo mergedInfo, IndexWriter writer) throws IOException {
        if (this.getNoCFSRatio() == 0.0) {
            return false;
        }
        long mergedInfoSize = this.size(mergedInfo, writer);
        if (mergedInfoSize > this.maxCFSSegmentSize) {
            return false;
        }
        if (this.getNoCFSRatio() >= 1.0) {
            return true;
        }
        long totalSize = 0L;
        for (SegmentCommitInfo info : infos) {
            totalSize += this.size(info, writer);
        }
        return (double)mergedInfoSize <= this.getNoCFSRatio() * (double)totalSize;
    }

    protected long size(SegmentCommitInfo info, IndexWriter writer) throws IOException {
        double delRatio;
        long byteSize = info.sizeInBytes();
        int delCount = writer.numDeletedDocs(info);
        double d = delRatio = info.info.maxDoc() <= 0 ? 0.0 : (double)((float)delCount / (float)info.info.maxDoc());
        assert (delRatio <= 1.0);
        return info.info.maxDoc() <= 0 ? byteSize : (long)((double)byteSize * (1.0 - delRatio));
    }

    protected final boolean isMerged(SegmentInfos infos, SegmentCommitInfo info, IndexWriter writer) throws IOException {
        assert (writer != null);
        boolean hasDeletions = writer.numDeletedDocs(info) > 0;
        return !hasDeletions && info.info.dir == writer.getDirectory() && this.useCompoundFile(infos, info, writer) == info.info.getUseCompoundFile();
    }

    public double getNoCFSRatio() {
        return this.noCFSRatio;
    }

    public void setNoCFSRatio(double noCFSRatio) {
        if (noCFSRatio < 0.0 || noCFSRatio > 1.0) {
            throw new IllegalArgumentException("noCFSRatio must be 0.0 to 1.0 inclusive; got " + noCFSRatio);
        }
        this.noCFSRatio = noCFSRatio;
    }

    public final double getMaxCFSSegmentSizeMB() {
        return (double)(this.maxCFSSegmentSize / 1024L) / 1024.0;
    }

    public void setMaxCFSSegmentSizeMB(double v) {
        if (v < 0.0) {
            throw new IllegalArgumentException("maxCFSSegmentSizeMB must be >=0 (got " + v + ")");
        }
        this.maxCFSSegmentSize = (v *= 1048576.0) > 9.223372036854776E18 ? Long.MAX_VALUE : (long)v;
    }

    public static class MergeAbortedException
    extends IOException {
        public MergeAbortedException() {
            super("merge is aborted");
        }

        public MergeAbortedException(String message) {
            super(message);
        }
    }

    public static class MergeException
    extends RuntimeException {
        private Directory dir;

        public MergeException(String message, Directory dir) {
            super(message);
            this.dir = dir;
        }

        public MergeException(Throwable exc, Directory dir) {
            super(exc);
            this.dir = dir;
        }

        public Directory getDirectory() {
            return this.dir;
        }
    }

    public static class MergeSpecification {
        public final List<OneMerge> merges = new ArrayList<OneMerge>();

        public void add(OneMerge merge) {
            this.merges.add(merge);
        }

        public String segString(Directory dir) {
            StringBuilder b = new StringBuilder();
            b.append("MergeSpec:\n");
            int count = this.merges.size();
            for (int i = 0; i < count; ++i) {
                b.append("  ").append(1 + i).append(": ").append(this.merges.get(i).segString());
            }
            return b.toString();
        }
    }

    public static class OneMerge {
        SegmentCommitInfo info;
        boolean registerDone;
        long mergeGen;
        boolean isExternal;
        int maxNumSegments = -1;
        public volatile long estimatedMergeBytes;
        volatile long totalMergeBytes;
        List<SegmentReader> readers;
        public final List<SegmentCommitInfo> segments;
        private final OneMergeProgress mergeProgress;
        volatile long mergeStartNS = -1L;
        public final int totalMaxDoc;
        Throwable error;

        public OneMerge(List<SegmentCommitInfo> segments) {
            if (0 == segments.size()) {
                throw new RuntimeException("segments must include at least one segment");
            }
            this.segments = new ArrayList<SegmentCommitInfo>(segments);
            int count = 0;
            for (SegmentCommitInfo info : segments) {
                count += info.info.maxDoc();
            }
            this.totalMaxDoc = count;
            this.mergeProgress = new OneMergeProgress();
        }

        public void mergeInit() throws IOException {
            this.mergeProgress.setMergeThread(Thread.currentThread());
        }

        public void mergeFinished() throws IOException {
        }

        public CodecReader wrapForMerge(CodecReader reader) throws IOException {
            return reader;
        }

        public void setMergeInfo(SegmentCommitInfo info) {
            this.info = info;
        }

        public SegmentCommitInfo getMergeInfo() {
            return this.info;
        }

        synchronized void setException(Throwable error) {
            this.error = error;
        }

        synchronized Throwable getException() {
            return this.error;
        }

        public String segString() {
            StringBuilder b = new StringBuilder();
            int numSegments = this.segments.size();
            for (int i = 0; i < numSegments; ++i) {
                if (i > 0) {
                    b.append(' ');
                }
                b.append(this.segments.get(i).toString());
            }
            if (this.info != null) {
                b.append(" into ").append(this.info.info.name);
            }
            if (this.maxNumSegments != -1) {
                b.append(" [maxNumSegments=" + this.maxNumSegments + "]");
            }
            if (this.isAborted()) {
                b.append(" [ABORTED]");
            }
            return b.toString();
        }

        public long totalBytesSize() throws IOException {
            return this.totalMergeBytes;
        }

        public int totalNumDocs() throws IOException {
            int total = 0;
            for (SegmentCommitInfo info : this.segments) {
                total += info.info.maxDoc();
            }
            return total;
        }

        public MergeInfo getStoreMergeInfo() {
            return new MergeInfo(this.totalMaxDoc, this.estimatedMergeBytes, this.isExternal, this.maxNumSegments);
        }

        public boolean isAborted() {
            return this.mergeProgress.isAborted();
        }

        public void setAborted() {
            this.mergeProgress.abort();
        }

        public void checkAborted() throws MergeAbortedException {
            if (this.isAborted()) {
                throw new MergeAbortedException("merge is aborted: " + this.segString());
            }
        }

        public OneMergeProgress getMergeProgress() {
            return this.mergeProgress;
        }
    }

    public static class OneMergeProgress {
        private final ReentrantLock pauseLock = new ReentrantLock();
        private final Condition pausing = this.pauseLock.newCondition();
        private final EnumMap<PauseReason, AtomicLong> pauseTimesNS = new EnumMap(PauseReason.class);
        private volatile boolean aborted;
        private Thread owner;

        public OneMergeProgress() {
            for (PauseReason p : PauseReason.values()) {
                this.pauseTimesNS.put(p, new AtomicLong());
            }
        }

        public void abort() {
            this.aborted = true;
            this.wakeup();
        }

        public boolean isAborted() {
            return this.aborted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pauseNanos(long pauseNanos, PauseReason reason, BooleanSupplier condition) throws InterruptedException {
            if (Thread.currentThread() != this.owner) {
                throw new RuntimeException("Only the merge owner thread can call pauseNanos(). This thread: " + Thread.currentThread().getName() + ", owner thread: " + this.owner);
            }
            long start = System.nanoTime();
            AtomicLong timeUpdate = this.pauseTimesNS.get((Object)reason);
            this.pauseLock.lock();
            try {
                while (pauseNanos > 0L && !this.aborted && condition.getAsBoolean()) {
                    pauseNanos = this.pausing.awaitNanos(pauseNanos);
                }
            }
            finally {
                this.pauseLock.unlock();
                timeUpdate.addAndGet(System.nanoTime() - start);
            }
        }

        public void wakeup() {
            this.pauseLock.lock();
            try {
                this.pausing.signalAll();
            }
            finally {
                this.pauseLock.unlock();
            }
        }

        public Map<PauseReason, Long> getPauseTimes() {
            Set<Map.Entry<PauseReason, AtomicLong>> entries = this.pauseTimesNS.entrySet();
            return entries.stream().collect(Collectors.toMap(e2 -> (PauseReason)((Object)((Object)e2.getKey())), e2 -> ((AtomicLong)e2.getValue()).get()));
        }

        final void setMergeThread(Thread owner) {
            assert (this.owner == null);
            this.owner = owner;
        }

        public static enum PauseReason {
            STOPPED,
            PAUSED,
            OTHER;

        }
    }
}

