/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.LRUQueryCache;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.UsageTrackingQueryCachingPolicy;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.ThreadInterruptedException;

public class IndexSearcher {
    private static final Similarity NON_SCORING_SIMILARITY = new Similarity(){

        @Override
        public long computeNorm(FieldInvertState state) {
            throw new UnsupportedOperationException("This Similarity may only be used for searching, not indexing");
        }

        @Override
        public Similarity.SimWeight computeWeight(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
            return new Similarity.SimWeight(){};
        }

        @Override
        public Similarity.SimScorer simScorer(Similarity.SimWeight weight, LeafReaderContext context) throws IOException {
            return new Similarity.SimScorer(){

                @Override
                public float score(int doc, float freq) {
                    return 0.0f;
                }

                @Override
                public float computeSlopFactor(int distance) {
                    return 1.0f;
                }

                @Override
                public float computePayloadFactor(int doc, int start, int end, BytesRef payload) {
                    return 1.0f;
                }
            };
        }
    };
    private static QueryCache DEFAULT_QUERY_CACHE;
    private static QueryCachingPolicy DEFAULT_CACHING_POLICY;
    final IndexReader reader;
    protected final IndexReaderContext readerContext;
    protected final List<LeafReaderContext> leafContexts;
    protected final LeafSlice[] leafSlices;
    private final ExecutorService executor;
    private static final Similarity defaultSimilarity;
    private QueryCache queryCache = DEFAULT_QUERY_CACHE;
    private QueryCachingPolicy queryCachingPolicy = DEFAULT_CACHING_POLICY;
    private Similarity similarity = defaultSimilarity;

    public static Similarity getDefaultSimilarity() {
        return defaultSimilarity;
    }

    public static QueryCache getDefaultQueryCache() {
        return DEFAULT_QUERY_CACHE;
    }

    public static void setDefaultQueryCache(QueryCache defaultQueryCache) {
        DEFAULT_QUERY_CACHE = defaultQueryCache;
    }

    public static QueryCachingPolicy getDefaultQueryCachingPolicy() {
        return DEFAULT_CACHING_POLICY;
    }

    public static void setDefaultQueryCachingPolicy(QueryCachingPolicy defaultQueryCachingPolicy) {
        DEFAULT_CACHING_POLICY = defaultQueryCachingPolicy;
    }

    public IndexSearcher(IndexReader r) {
        this(r, null);
    }

    public IndexSearcher(IndexReader r, ExecutorService executor) {
        this(r.getContext(), executor);
    }

    public IndexSearcher(IndexReaderContext context, ExecutorService executor) {
        assert (context.isTopLevel) : "IndexSearcher's ReaderContext must be topLevel for reader" + context.reader();
        this.reader = context.reader();
        this.executor = executor;
        this.readerContext = context;
        this.leafContexts = context.leaves();
        this.leafSlices = executor == null ? null : this.slices(this.leafContexts);
    }

    public IndexSearcher(IndexReaderContext context) {
        this(context, null);
    }

    public void setQueryCache(QueryCache queryCache) {
        this.queryCache = queryCache;
    }

    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    public void setQueryCachingPolicy(QueryCachingPolicy queryCachingPolicy) {
        this.queryCachingPolicy = Objects.requireNonNull(queryCachingPolicy);
    }

    public QueryCachingPolicy getQueryCachingPolicy() {
        return this.queryCachingPolicy;
    }

    protected LeafSlice[] slices(List<LeafReaderContext> leaves) {
        LeafSlice[] slices = new LeafSlice[leaves.size()];
        for (int i = 0; i < slices.length; ++i) {
            slices[i] = new LeafSlice(leaves.get(i));
        }
        return slices;
    }

    public IndexReader getIndexReader() {
        return this.reader;
    }

    public Document doc(int docID) throws IOException {
        return this.reader.document(docID);
    }

    public void doc(int docID, StoredFieldVisitor fieldVisitor) throws IOException {
        this.reader.document(docID, fieldVisitor);
    }

    public Document doc(int docID, Set<String> fieldsToLoad) throws IOException {
        return this.reader.document(docID, fieldsToLoad);
    }

    public void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
    }

    public Similarity getSimilarity(boolean needsScores) {
        return needsScores ? this.similarity : NON_SCORING_SIMILARITY;
    }

    public int count(Query query2) throws IOException {
        query2 = this.rewrite(query2);
        while (query2 instanceof ConstantScoreQuery) {
            query2 = ((ConstantScoreQuery)query2).getQuery();
        }
        if (query2 instanceof MatchAllDocsQuery) {
            return this.reader.numDocs();
        }
        if (query2 instanceof TermQuery && !this.reader.hasDeletions()) {
            Term term = ((TermQuery)query2).getTerm();
            int count = 0;
            for (LeafReaderContext leaf : this.reader.leaves()) {
                count += leaf.reader().docFreq(term);
            }
            return count;
        }
        CollectorManager<TotalHitCountCollector, Integer> collectorManager = new CollectorManager<TotalHitCountCollector, Integer>(){

            @Override
            public TotalHitCountCollector newCollector() throws IOException {
                return new TotalHitCountCollector();
            }

            @Override
            public Integer reduce(Collection<TotalHitCountCollector> collectors) throws IOException {
                int total = 0;
                for (TotalHitCountCollector collector : collectors) {
                    total += collector.getTotalHits();
                }
                return total;
            }
        };
        return this.search(query2, collectorManager);
    }

    public TopDocs searchAfter(final ScoreDoc after, Query query2, int numHits) throws IOException {
        int limit = Math.max(1, this.reader.maxDoc());
        if (after != null && after.doc >= limit) {
            throw new IllegalArgumentException("after.doc exceeds the number of documents in the reader: after.doc=" + after.doc + " limit=" + limit);
        }
        final int cappedNumHits = Math.min(numHits, limit);
        CollectorManager<TopScoreDocCollector, TopDocs> manager = new CollectorManager<TopScoreDocCollector, TopDocs>(){

            @Override
            public TopScoreDocCollector newCollector() throws IOException {
                return TopScoreDocCollector.create(cappedNumHits, after);
            }

            @Override
            public TopDocs reduce(Collection<TopScoreDocCollector> collectors) throws IOException {
                TopDocs[] topDocs = new TopDocs[collectors.size()];
                int i = 0;
                for (TopScoreDocCollector collector : collectors) {
                    topDocs[i++] = collector.topDocs();
                }
                return TopDocs.merge(0, cappedNumHits, topDocs, true);
            }
        };
        return this.search(query2, manager);
    }

    public TopDocs search(Query query2, int n) throws IOException {
        return this.searchAfter(null, query2, n);
    }

    public void search(Query query2, Collector results) throws IOException {
        this.search(this.leafContexts, this.createNormalizedWeight(query2, results.needsScores()), results);
    }

    public TopFieldDocs search(Query query2, int n, Sort sort, boolean doDocScores, boolean doMaxScore) throws IOException {
        return this.searchAfter(null, query2, n, sort, doDocScores, doMaxScore);
    }

    public TopFieldDocs search(Query query2, int n, Sort sort) throws IOException {
        return this.searchAfter(null, query2, n, sort, false, false);
    }

    public TopDocs searchAfter(ScoreDoc after, Query query2, int n, Sort sort) throws IOException {
        return this.searchAfter(after, query2, n, sort, false, false);
    }

    public TopFieldDocs searchAfter(ScoreDoc after, Query query2, int numHits, Sort sort, boolean doDocScores, boolean doMaxScore) throws IOException {
        if (after != null && !(after instanceof FieldDoc)) {
            throw new IllegalArgumentException("after must be a FieldDoc; got " + after);
        }
        return this.searchAfter((FieldDoc)after, query2, numHits, sort, doDocScores, doMaxScore);
    }

    private TopFieldDocs searchAfter(final FieldDoc after, Query query2, int numHits, final Sort sort, final boolean doDocScores, final boolean doMaxScore) throws IOException {
        int limit = Math.max(1, this.reader.maxDoc());
        if (after != null && after.doc >= limit) {
            throw new IllegalArgumentException("after.doc exceeds the number of documents in the reader: after.doc=" + after.doc + " limit=" + limit);
        }
        final int cappedNumHits = Math.min(numHits, limit);
        CollectorManager<TopFieldCollector, TopFieldDocs> manager = new CollectorManager<TopFieldCollector, TopFieldDocs>(){

            @Override
            public TopFieldCollector newCollector() throws IOException {
                boolean fillFields = true;
                return TopFieldCollector.create(sort, cappedNumHits, after, true, doDocScores, doMaxScore);
            }

            @Override
            public TopFieldDocs reduce(Collection<TopFieldCollector> collectors) throws IOException {
                TopFieldDocs[] topDocs = new TopFieldDocs[collectors.size()];
                int i = 0;
                for (TopFieldCollector collector : collectors) {
                    topDocs[i++] = collector.topDocs();
                }
                return TopDocs.merge(sort, 0, cappedNumHits, topDocs, true);
            }
        };
        return this.search(query2, manager);
    }

    public <C extends Collector, T> T search(Query query2, CollectorManager<C, T> collectorManager) throws IOException {
        if (this.executor == null) {
            Object collector = collectorManager.newCollector();
            this.search(query2, (Collector)collector);
            return collectorManager.reduce(Collections.singletonList(collector));
        }
        ArrayList collectors = new ArrayList(this.leafSlices.length);
        boolean needsScores = false;
        for (int i = 0; i < this.leafSlices.length; ++i) {
            Object collector = collectorManager.newCollector();
            collectors.add(collector);
            needsScores |= collector.needsScores();
        }
        final Weight weight = this.createNormalizedWeight(query2, needsScores);
        ArrayList topDocsFutures = new ArrayList(this.leafSlices.length);
        for (int i = 0; i < this.leafSlices.length; ++i) {
            final LeafReaderContext[] leaves = this.leafSlices[i].leaves;
            final Collector collector = (Collector)collectors.get(i);
            topDocsFutures.add(this.executor.submit(new Callable<C>(){

                @Override
                public C call() throws Exception {
                    IndexSearcher.this.search(Arrays.asList(leaves), weight, collector);
                    return collector;
                }
            }));
        }
        ArrayList collectedCollectors = new ArrayList();
        for (Future future : topDocsFutures) {
            try {
                collectedCollectors.add(future.get());
            }
            catch (InterruptedException e2) {
                throw new ThreadInterruptedException(e2);
            }
            catch (ExecutionException e3) {
                throw new RuntimeException(e3);
            }
        }
        return collectorManager.reduce(collectors);
    }

    protected void search(List<LeafReaderContext> leaves, Weight weight, Collector collector) throws IOException {
        for (LeafReaderContext ctx : leaves) {
            LeafCollector leafCollector;
            try {
                leafCollector = collector.getLeafCollector(ctx);
            }
            catch (CollectionTerminatedException e2) {
                continue;
            }
            BulkScorer scorer = weight.bulkScorer(ctx);
            if (scorer == null) continue;
            try {
                scorer.score(leafCollector, ctx.reader().getLiveDocs());
            }
            catch (CollectionTerminatedException collectionTerminatedException) {}
        }
    }

    public Query rewrite(Query original) throws IOException {
        Query query2 = original;
        Query rewrittenQuery = query2.rewrite(this.reader);
        while (rewrittenQuery != query2) {
            query2 = rewrittenQuery;
            rewrittenQuery = query2.rewrite(this.reader);
        }
        return query2;
    }

    public Explanation explain(Query query2, int doc) throws IOException {
        return this.explain(this.createNormalizedWeight(query2, true), doc);
    }

    protected Explanation explain(Weight weight, int doc) throws IOException {
        int n = ReaderUtil.subIndex(doc, this.leafContexts);
        LeafReaderContext ctx = this.leafContexts.get(n);
        int deBasedDoc = doc - ctx.docBase;
        Bits liveDocs = ctx.reader().getLiveDocs();
        if (liveDocs != null && !liveDocs.get(deBasedDoc)) {
            return Explanation.noMatch("Document " + doc + " is deleted", new Explanation[0]);
        }
        return weight.explain(ctx, deBasedDoc);
    }

    public Weight createNormalizedWeight(Query query2, boolean needsScores) throws IOException {
        query2 = this.rewrite(query2);
        return this.createWeight(query2, needsScores, 1.0f);
    }

    public Weight createWeight(Query query2, boolean needsScores, float boost) throws IOException {
        QueryCache queryCache = this.queryCache;
        Weight weight = query2.createWeight(this, needsScores, boost);
        if (!needsScores && queryCache != null) {
            weight = queryCache.doCache(weight, this.queryCachingPolicy);
        }
        return weight;
    }

    public IndexReaderContext getTopReaderContext() {
        return this.readerContext;
    }

    public String toString() {
        return "IndexSearcher(" + this.reader + "; executor=" + this.executor + ")";
    }

    public TermStatistics termStatistics(Term term, TermContext context) throws IOException {
        return new TermStatistics(term.bytes(), context.docFreq(), context.totalTermFreq());
    }

    public CollectionStatistics collectionStatistics(String field) throws IOException {
        long sumDocFreq;
        long sumTotalTermFreq;
        int docCount;
        assert (field != null);
        Terms terms = MultiFields.getTerms(this.reader, field);
        if (terms == null) {
            docCount = 0;
            sumTotalTermFreq = 0L;
            sumDocFreq = 0L;
        } else {
            docCount = terms.getDocCount();
            sumTotalTermFreq = terms.getSumTotalTermFreq();
            sumDocFreq = terms.getSumDocFreq();
        }
        return new CollectionStatistics(field, this.reader.maxDoc(), docCount, sumTotalTermFreq, sumDocFreq);
    }

    static {
        DEFAULT_CACHING_POLICY = new UsageTrackingQueryCachingPolicy();
        int maxCachedQueries = 1000;
        long maxRamBytesUsed = Math.min(0x2000000L, Runtime.getRuntime().maxMemory() / 20L);
        DEFAULT_QUERY_CACHE = new LRUQueryCache(1000, maxRamBytesUsed);
        defaultSimilarity = new BM25Similarity();
    }

    public static class LeafSlice {
        final LeafReaderContext[] leaves;

        public LeafSlice(LeafReaderContext ... leaves) {
            this.leaves = leaves;
        }
    }
}

