/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DisjunctionScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermScorer;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;

public final class SynonymQuery
extends Query {
    private final Term[] terms;

    public SynonymQuery(Term ... terms) {
        this.terms = (Term[])Objects.requireNonNull(terms).clone();
        String field = null;
        for (Term term : terms) {
            if (field == null) {
                field = term.field();
                continue;
            }
            if (term.field().equals(field)) continue;
            throw new IllegalArgumentException("Synonyms must be across the same field");
        }
        if (terms.length > BooleanQuery.getMaxClauseCount()) {
            throw new BooleanQuery.TooManyClauses();
        }
        Arrays.sort(this.terms);
    }

    public List<Term> getTerms() {
        return Collections.unmodifiableList(Arrays.asList(this.terms));
    }

    @Override
    public String toString(String field) {
        StringBuilder builder = new StringBuilder("Synonym(");
        for (int i = 0; i < this.terms.length; ++i) {
            if (i != 0) {
                builder.append(" ");
            }
            TermQuery termQuery = new TermQuery(this.terms[i]);
            builder.append(((Query)termQuery).toString(field));
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + Arrays.hashCode(this.terms);
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && Arrays.equals(this.terms, ((SynonymQuery)other).terms);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.terms.length == 0) {
            return new BooleanQuery.Builder().build();
        }
        if (this.terms.length == 1) {
            return new TermQuery(this.terms[0]);
        }
        return this;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        if (needsScores) {
            return new SynonymWeight(this, searcher, boost);
        }
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        for (Term term : this.terms) {
            bq.add(new TermQuery(term), BooleanClause.Occur.SHOULD);
        }
        return searcher.rewrite(bq.build()).createWeight(searcher, needsScores, boost);
    }

    static class SynonymScorer
    extends DisjunctionScorer {
        private final Similarity.SimScorer similarity;

        SynonymScorer(Similarity.SimScorer similarity, Weight weight, List<Scorer> subScorers) {
            super(weight, subScorers, true);
            this.similarity = similarity;
        }

        @Override
        protected float score(DisiWrapper topList) throws IOException {
            return this.similarity.score(topList.doc, this.tf(topList));
        }

        final int tf(DisiWrapper topList) throws IOException {
            int tf = 0;
            DisiWrapper w = topList;
            while (w != null) {
                tf += w.scorer.freq();
                w = w.next;
            }
            return tf;
        }
    }

    class SynonymWeight
    extends Weight {
        private final TermContext[] termContexts;
        private final Similarity similarity;
        private final Similarity.SimWeight simWeight;

        SynonymWeight(Query query2, IndexSearcher searcher, float boost) throws IOException {
            super(query2);
            CollectionStatistics collectionStats = searcher.collectionStatistics(SynonymQuery.this.terms[0].field());
            long docFreq = 0L;
            long totalTermFreq = 0L;
            this.termContexts = new TermContext[SynonymQuery.this.terms.length];
            for (int i = 0; i < this.termContexts.length; ++i) {
                this.termContexts[i] = TermContext.build(searcher.getTopReaderContext(), SynonymQuery.this.terms[i]);
                TermStatistics termStats = searcher.termStatistics(SynonymQuery.this.terms[i], this.termContexts[i]);
                docFreq = Math.max(termStats.docFreq(), docFreq);
                if (termStats.totalTermFreq() == -1L) {
                    totalTermFreq = -1L;
                    continue;
                }
                if (totalTermFreq == -1L) continue;
                totalTermFreq += termStats.totalTermFreq();
            }
            TermStatistics pseudoStats = new TermStatistics(null, docFreq, totalTermFreq);
            this.similarity = searcher.getSimilarity(true);
            this.simWeight = this.similarity.computeWeight(boost, collectionStats, pseudoStats);
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            for (Term term : SynonymQuery.this.terms) {
                terms.add(term);
            }
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            int newDoc;
            Scorer scorer = this.scorer(context);
            if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
                float freq;
                if (scorer instanceof SynonymScorer) {
                    SynonymScorer synScorer = (SynonymScorer)scorer;
                    freq = synScorer.tf(synScorer.getSubMatches());
                } else {
                    assert (scorer instanceof TermScorer);
                    freq = scorer.freq();
                }
                Similarity.SimScorer docScorer = this.similarity.simScorer(this.simWeight, context);
                Explanation freqExplanation = Explanation.match(freq, "termFreq=" + freq, new Explanation[0]);
                Explanation scoreExplanation = docScorer.explain(doc, freqExplanation);
                return Explanation.match(scoreExplanation.getValue(), "weight(" + this.getQuery() + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "], result of:", scoreExplanation);
            }
            return Explanation.noMatch("no matching term", new Explanation[0]);
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            Similarity.SimScorer simScorer = this.similarity.simScorer(this.simWeight, context);
            ArrayList<Scorer> subScorers = new ArrayList<Scorer>();
            for (int i = 0; i < SynonymQuery.this.terms.length; ++i) {
                TermState state = this.termContexts[i].get(context.ord);
                if (state == null) continue;
                TermsEnum termsEnum = context.reader().terms(SynonymQuery.this.terms[i].field()).iterator();
                termsEnum.seekExact(SynonymQuery.this.terms[i].bytes(), state);
                PostingsEnum postings = termsEnum.postings(null, 8);
                subScorers.add(new TermScorer(this, postings, simScorer));
            }
            if (subScorers.isEmpty()) {
                return null;
            }
            if (subScorers.size() == 1) {
                return (Scorer)subScorers.get(0);
            }
            return new SynonymScorer(simScorer, this, subScorers);
        }
    }
}

