/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Accountable;

public class RAMFile
implements Accountable {
    protected final ArrayList<byte[]> buffers = new ArrayList();
    long length;
    RAMDirectory directory;
    protected long sizeInBytes;

    public RAMFile() {
    }

    RAMFile(RAMDirectory directory) {
        this.directory = directory;
    }

    public synchronized long getLength() {
        return this.length;
    }

    protected synchronized void setLength(long length) {
        this.length = length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final byte[] addBuffer(int size) {
        byte[] buffer = this.newBuffer(size);
        RAMFile rAMFile = this;
        synchronized (rAMFile) {
            this.buffers.add(buffer);
            this.sizeInBytes += (long)size;
        }
        if (this.directory != null) {
            this.directory.sizeInBytes.getAndAdd(size);
        }
        return buffer;
    }

    protected final synchronized byte[] getBuffer(int index) {
        return this.buffers.get(index);
    }

    protected final synchronized int numBuffers() {
        return this.buffers.size();
    }

    protected byte[] newBuffer(int size) {
        return new byte[size];
    }

    @Override
    public synchronized long ramBytesUsed() {
        return this.sizeInBytes;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(length=" + this.length + ")";
    }

    public int hashCode() {
        int h2 = (int)(this.length ^ this.length >>> 32);
        for (byte[] block : this.buffers) {
            h2 = 31 * h2 + Arrays.hashCode(block);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RAMFile other = (RAMFile)obj;
        if (this.length != other.length) {
            return false;
        }
        if (this.buffers.size() != other.buffers.size()) {
            return false;
        }
        for (int i = 0; i < this.buffers.size(); ++i) {
            if (Arrays.equals(this.buffers.get(i), other.buffers.get(i))) continue;
            return false;
        }
        return true;
    }
}

