/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.foxml;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.FSDirectory;
import org.fcrepo.migration.foxml.CachedContent;
import org.fcrepo.migration.foxml.FileCachedContent;
import org.fcrepo.migration.foxml.InternalIDResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DirectoryScanningIDResolver
implements InternalIDResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalIDResolver.class);
    private final IndexSearcher searcher;

    public DirectoryScanningIDResolver(File cachedIndexDir, File dsRoot) throws IOException {
        File indexDir;
        if (cachedIndexDir == null) {
            File temp = File.createTempFile("tempfile", "basedir");
            temp.delete();
            temp.mkdir();
            indexDir = new File(temp, "index");
            LOGGER.info("No index directory specified.  Creating temporary index at \"" + indexDir.getAbsolutePath() + "\".");
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (DirectoryScanningIDResolver.this.searcher != null) {
                            DirectoryScanningIDResolver.this.searcher.getIndexReader().close();
                        }
                        LOGGER.info("Deleting index directory at \"" + indexDir.getAbsolutePath() + "\"...");
                        FileUtils.deleteDirectory(indexDir);
                    }
                    catch (IOException e2) {
                        LOGGER.error("Unable to delete index directory at \"" + indexDir.getAbsolutePath() + "\"!", e2);
                        e2.printStackTrace();
                    }
                }
            }));
        } else {
            indexDir = cachedIndexDir;
        }
        if (indexDir.exists() && indexDir.list().length > 0) {
            LOGGER.warn("Index exists at \"" + indexDir.getPath() + "\" and will be used.  To clear index, simply delete this directory and re-run the application.");
        } else {
            StandardAnalyzer analyzer = new StandardAnalyzer();
            IndexWriterConfig iwc = new IndexWriterConfig(analyzer);
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            try (FSDirectory dir = FSDirectory.open(indexDir.toPath());
                 IndexWriter writer = new IndexWriter(dir, iwc);){
                LOGGER.info("Building an index of all the datastreams in \"" + dsRoot.getPath() + "\"...");
                this.indexDatastreams(writer, dsRoot);
                writer.commit();
            }
        }
        DirectoryReader reader = DirectoryReader.open(FSDirectory.open(indexDir.toPath()));
        this.searcher = new IndexSearcher(reader);
    }

    @Override
    public CachedContent resolveInternalID(String id) {
        try {
            TopDocs result = this.searcher.search((Query)new TermQuery(new Term("id", id)), 2);
            if (result.totalHits == 1L) {
                return new FileCachedContent(new File(this.searcher.doc(result.scoreDocs[0].doc).get("path")));
            }
            if (result.totalHits < 1L) {
                throw new RuntimeException("Unable to resolve internal ID \"" + id + "\"!");
            }
            throw new IllegalStateException(result.totalHits + " files matched the internal id \"" + id + "\".  (" + this.searcher.doc(result.scoreDocs[0].doc).get("path") + ", " + this.searcher.doc(result.scoreDocs[1].doc).get("path") + "...)");
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private void indexDatastreams(IndexWriter writer, File f) throws IOException {
        if (f.isDirectory()) {
            for (File child : f.listFiles()) {
                this.indexDatastreams(writer, child);
            }
        } else {
            Document doc = new Document();
            doc.add(new StringField("path", f.getPath(), Field.Store.YES));
            doc.add(new StringField("id", this.getInternalIdForFile(f), Field.Store.YES));
            LOGGER.trace("Added \"{}\" for: {}", (Object)this.getInternalIdForFile(f), (Object)f.getPath());
            writer.addDocument(doc);
        }
    }

    protected abstract String getInternalIdForFile(File var1);
}

