/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.handlers;

import org.fcrepo.migration.DatastreamVersion;
import org.fcrepo.migration.ObjectInfo;
import org.fcrepo.migration.ObjectProperties;
import org.fcrepo.migration.ObjectProperty;
import org.fcrepo.migration.StreamingFedoraObjectHandler;

public class ConsoleLoggingStreamingFedoraObjectHandler
implements StreamingFedoraObjectHandler {
    private long start;

    @Override
    public void beginObject(ObjectInfo object) {
        this.start = System.currentTimeMillis();
        System.out.println(object.getPid());
    }

    @Override
    public void processObjectProperties(ObjectProperties properties) {
        System.out.println("  Properties");
        for (ObjectProperty objectProperty : properties.listProperties()) {
            System.out.println("    " + objectProperty.getName() + " = " + objectProperty.getValue());
        }
    }

    @Override
    public void processDatastreamVersion(DatastreamVersion dsVersion) {
        System.out.println("  " + dsVersion.getDatastreamInfo().getDatastreamId() + " version " + dsVersion.getVersionId());
    }

    @Override
    public void processDisseminator() {
        System.out.println("  DISSEMINATOR found and skipped!");
    }

    @Override
    public void completeObject(ObjectInfo object) {
        System.out.println(object.getPid() + " parsed in " + (System.currentTimeMillis() - this.start) + "ms.");
    }

    @Override
    public void abortObject(ObjectInfo object) {
        System.out.println(object.getPid() + " failed to parse in " + (System.currentTimeMillis() - this.start) + "ms.");
    }
}

