/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public abstract class StringUtils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String FOLDER_SEPARATOR = "/";
    private static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    private static final String TOP_PATH = "..";
    private static final String CURRENT_PATH = ".";
    private static final char EXTENSION_SEPARATOR = '.';

    public static boolean isEmpty(@Nullable Object str2) {
        return str2 == null || "".equals(str2);
    }

    public static boolean hasLength(@Nullable CharSequence str2) {
        return str2 != null && str2.length() > 0;
    }

    public static boolean hasLength(@Nullable String str2) {
        return str2 != null && !str2.isEmpty();
    }

    public static boolean hasText(@Nullable CharSequence str2) {
        return str2 != null && str2.length() > 0 && StringUtils.containsText(str2);
    }

    public static boolean hasText(@Nullable String str2) {
        return str2 != null && !str2.isEmpty() && StringUtils.containsText(str2);
    }

    private static boolean containsText(CharSequence str2) {
        int strLen = str2.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str2.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWhitespace(@Nullable CharSequence str2) {
        if (!StringUtils.hasLength(str2)) {
            return false;
        }
        int strLen = str2.length();
        for (int i = 0; i < strLen; ++i) {
            if (!Character.isWhitespace(str2.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWhitespace(@Nullable String str2) {
        return StringUtils.containsWhitespace((CharSequence)str2);
    }

    public static String trimWhitespace(String str2) {
        int beginIndex;
        if (!StringUtils.hasLength(str2)) {
            return str2;
        }
        int endIndex = str2.length() - 1;
        for (beginIndex = 0; beginIndex <= endIndex && Character.isWhitespace(str2.charAt(beginIndex)); ++beginIndex) {
        }
        while (endIndex > beginIndex && Character.isWhitespace(str2.charAt(endIndex))) {
            --endIndex;
        }
        return str2.substring(beginIndex, endIndex + 1);
    }

    public static String trimAllWhitespace(String str2) {
        if (!StringUtils.hasLength(str2)) {
            return str2;
        }
        int len = str2.length();
        StringBuilder sb = new StringBuilder(str2.length());
        for (int i = 0; i < len; ++i) {
            char c = str2.charAt(i);
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String trimLeadingWhitespace(String str2) {
        if (!StringUtils.hasLength(str2)) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimTrailingWhitespace(String str2) {
        if (!StringUtils.hasLength(str2)) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String trimLeadingCharacter(String str2, char leadingCharacter) {
        if (!StringUtils.hasLength(str2)) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2);
        while (sb.length() > 0 && sb.charAt(0) == leadingCharacter) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimTrailingCharacter(String str2, char trailingCharacter) {
        if (!StringUtils.hasLength(str2)) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2);
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == trailingCharacter) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static boolean startsWithIgnoreCase(@Nullable String str2, @Nullable String prefix) {
        return str2 != null && prefix != null && str2.length() >= prefix.length() && str2.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean endsWithIgnoreCase(@Nullable String str2, @Nullable String suffix) {
        return str2 != null && suffix != null && str2.length() >= suffix.length() && str2.regionMatches(true, str2.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static boolean substringMatch(CharSequence str2, int index, CharSequence substring2) {
        if (index + substring2.length() > str2.length()) {
            return false;
        }
        for (int i = 0; i < substring2.length(); ++i) {
            if (str2.charAt(index + i) == substring2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static int countOccurrencesOf(String str2, String sub) {
        int idx;
        if (!StringUtils.hasLength(str2) || !StringUtils.hasLength(sub)) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((idx = str2.indexOf(sub, pos)) != -1) {
            ++count;
            pos = idx + sub.length();
        }
        return count;
    }

    public static String replace(String inString, String oldPattern, @Nullable String newPattern) {
        if (!StringUtils.hasLength(inString) || !StringUtils.hasLength(oldPattern) || newPattern == null) {
            return inString;
        }
        int index = inString.indexOf(oldPattern);
        if (index == -1) {
            return inString;
        }
        int capacity = inString.length();
        if (newPattern.length() > oldPattern.length()) {
            capacity += 16;
        }
        StringBuilder sb = new StringBuilder(capacity);
        int pos = 0;
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString.substring(pos, index));
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    public static String delete(String inString, String pattern) {
        return StringUtils.replace(inString, pattern, "");
    }

    public static String deleteAny(String inString, @Nullable String charsToDelete) {
        if (!StringUtils.hasLength(inString) || !StringUtils.hasLength(charsToDelete)) {
            return inString;
        }
        StringBuilder sb = new StringBuilder(inString.length());
        for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            if (charsToDelete.indexOf(c) != -1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    @Nullable
    public static String quote(@Nullable String str2) {
        return str2 != null ? "'" + str2 + "'" : null;
    }

    @Nullable
    public static Object quoteIfString(@Nullable Object obj) {
        return obj instanceof String ? StringUtils.quote((String)obj) : obj;
    }

    public static String unqualify(String qualifiedName) {
        return StringUtils.unqualify(qualifiedName, '.');
    }

    public static String unqualify(String qualifiedName, char separator) {
        return qualifiedName.substring(qualifiedName.lastIndexOf(separator) + 1);
    }

    public static String capitalize(String str2) {
        return StringUtils.changeFirstCharacterCase(str2, true);
    }

    public static String uncapitalize(String str2) {
        return StringUtils.changeFirstCharacterCase(str2, false);
    }

    private static String changeFirstCharacterCase(String str2, boolean capitalize) {
        char updatedChar;
        if (!StringUtils.hasLength(str2)) {
            return str2;
        }
        char baseChar = str2.charAt(0);
        if (baseChar == (updatedChar = capitalize ? Character.toUpperCase(baseChar) : Character.toLowerCase(baseChar))) {
            return str2;
        }
        char[] chars = str2.toCharArray();
        chars[0] = updatedChar;
        return new String(chars, 0, chars.length);
    }

    @Nullable
    public static String getFilename(@Nullable String path) {
        if (path == null) {
            return null;
        }
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        return separatorIndex != -1 ? path.substring(separatorIndex + 1) : path;
    }

    @Nullable
    public static String getFilenameExtension(@Nullable String path) {
        if (path == null) {
            return null;
        }
        int extIndex = path.lastIndexOf(46);
        if (extIndex == -1) {
            return null;
        }
        int folderIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (folderIndex > extIndex) {
            return null;
        }
        return path.substring(extIndex + 1);
    }

    public static String stripFilenameExtension(String path) {
        int extIndex = path.lastIndexOf(46);
        if (extIndex == -1) {
            return path;
        }
        int folderIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (folderIndex > extIndex) {
            return path;
        }
        return path.substring(0, extIndex);
    }

    public static String applyRelativePath(String path, String relativePath) {
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (separatorIndex != -1) {
            String newPath = path.substring(0, separatorIndex);
            if (!relativePath.startsWith(FOLDER_SEPARATOR)) {
                newPath = newPath + FOLDER_SEPARATOR;
            }
            return newPath + relativePath;
        }
        return relativePath;
    }

    public static String cleanPath(String path) {
        int i;
        if (!StringUtils.hasLength(path)) {
            return path;
        }
        String pathToUse = StringUtils.replace(path, WINDOWS_FOLDER_SEPARATOR, FOLDER_SEPARATOR);
        if (pathToUse.indexOf(46) == -1) {
            return pathToUse;
        }
        int prefixIndex = pathToUse.indexOf(58);
        String prefix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (prefix.contains(FOLDER_SEPARATOR)) {
                prefix = "";
            } else {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            }
        }
        if (pathToUse.startsWith(FOLDER_SEPARATOR)) {
            prefix = prefix + FOLDER_SEPARATOR;
            pathToUse = pathToUse.substring(1);
        }
        String[] pathArray = StringUtils.delimitedListToStringArray(pathToUse, FOLDER_SEPARATOR);
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            String element = pathArray[i];
            if (CURRENT_PATH.equals(element)) continue;
            if (TOP_PATH.equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        for (i = 0; i < tops; ++i) {
            pathElements.add(0, TOP_PATH);
        }
        if (pathElements.size() == 1 && "".equals(pathElements.getLast()) && !prefix.endsWith(FOLDER_SEPARATOR)) {
            pathElements.add(0, CURRENT_PATH);
        }
        return prefix + StringUtils.collectionToDelimitedString(pathElements, FOLDER_SEPARATOR);
    }

    public static boolean pathEquals(String path1, String path2) {
        return StringUtils.cleanPath(path1).equals(StringUtils.cleanPath(path2));
    }

    public static String uriDecode(String source, Charset charset) {
        int length = source.length();
        if (length == 0) {
            return source;
        }
        Assert.notNull((Object)charset, "Charset must not be null");
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        boolean changed = false;
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (ch == '%') {
                if (i + 2 < length) {
                    char hex1 = source.charAt(i + 1);
                    char hex2 = source.charAt(i + 2);
                    int u = Character.digit(hex1, 16);
                    int l = Character.digit(hex2, 16);
                    if (u == -1 || l == -1) {
                        throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
                    }
                    bos.write((char)((u << 4) + l));
                    i += 2;
                    changed = true;
                    continue;
                }
                throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
            }
            bos.write(ch);
        }
        return changed ? new String(bos.toByteArray(), charset) : source;
    }

    @Nullable
    public static Locale parseLocale(String localeValue) {
        String[] tokens2 = StringUtils.tokenizeLocaleSource(localeValue);
        if (tokens2.length == 1) {
            StringUtils.validateLocalePart(localeValue);
            Locale resolved = Locale.forLanguageTag(localeValue);
            if (resolved.getLanguage().length() > 0) {
                return resolved;
            }
        }
        return StringUtils.parseLocaleTokens(localeValue, tokens2);
    }

    @Nullable
    public static Locale parseLocaleString(String localeString) {
        return StringUtils.parseLocaleTokens(localeString, StringUtils.tokenizeLocaleSource(localeString));
    }

    private static String[] tokenizeLocaleSource(String localeSource) {
        return StringUtils.tokenizeToStringArray(localeSource, "_ ", false, false);
    }

    @Nullable
    private static Locale parseLocaleTokens(String localeString, String[] tokens2) {
        int endIndexOfCountryCode;
        String language = tokens2.length > 0 ? tokens2[0] : "";
        String country = tokens2.length > 1 ? tokens2[1] : "";
        StringUtils.validateLocalePart(language);
        StringUtils.validateLocalePart(country);
        String variant = "";
        if (tokens2.length > 2 && (variant = StringUtils.trimLeadingWhitespace(localeString.substring(endIndexOfCountryCode = localeString.indexOf(country, language.length()) + country.length()))).startsWith("_")) {
            variant = StringUtils.trimLeadingCharacter(variant, '_');
        }
        if (variant.isEmpty() && country.startsWith("#")) {
            variant = country;
            country = "";
        }
        return language.length() > 0 ? new Locale(language, country, variant) : null;
    }

    private static void validateLocalePart(String localePart) {
        for (int i = 0; i < localePart.length(); ++i) {
            char ch = localePart.charAt(i);
            if (ch == ' ' || ch == '_' || ch == '-' || ch == '#' || Character.isLetterOrDigit(ch)) continue;
            throw new IllegalArgumentException("Locale part \"" + localePart + "\" contains invalid characters");
        }
    }

    @Deprecated
    public static String toLanguageTag(Locale locale) {
        return locale.getLanguage() + (StringUtils.hasText(locale.getCountry()) ? "-" + locale.getCountry() : "");
    }

    public static TimeZone parseTimeZoneString(String timeZoneString) {
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneString);
        if ("GMT".equals(timeZone.getID()) && !timeZoneString.startsWith("GMT")) {
            throw new IllegalArgumentException("Invalid time zone specification '" + timeZoneString + "'");
        }
        return timeZone;
    }

    public static String[] toStringArray(@Nullable Collection<String> collection) {
        return !CollectionUtils.isEmpty(collection) ? collection.toArray(EMPTY_STRING_ARRAY) : EMPTY_STRING_ARRAY;
    }

    public static String[] toStringArray(@Nullable Enumeration<String> enumeration) {
        return enumeration != null ? StringUtils.toStringArray(Collections.list(enumeration)) : EMPTY_STRING_ARRAY;
    }

    public static String[] addStringToArray(@Nullable String[] array, String str2) {
        if (ObjectUtils.isEmpty(array)) {
            return new String[]{str2};
        }
        String[] newArr = new String[array.length + 1];
        System.arraycopy(array, 0, newArr, 0, array.length);
        newArr[array.length] = str2;
        return newArr;
    }

    @Nullable
    public static String[] concatenateStringArrays(@Nullable String[] array1, @Nullable String[] array2) {
        if (ObjectUtils.isEmpty(array1)) {
            return array2;
        }
        if (ObjectUtils.isEmpty(array2)) {
            return array1;
        }
        String[] newArr = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, newArr, 0, array1.length);
        System.arraycopy(array2, 0, newArr, array1.length, array2.length);
        return newArr;
    }

    @Deprecated
    @Nullable
    public static String[] mergeStringArrays(@Nullable String[] array1, @Nullable String[] array2) {
        if (ObjectUtils.isEmpty(array1)) {
            return array2;
        }
        if (ObjectUtils.isEmpty(array2)) {
            return array1;
        }
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(array1));
        for (String str2 : array2) {
            if (result.contains(str2)) continue;
            result.add(str2);
        }
        return StringUtils.toStringArray(result);
    }

    public static String[] sortStringArray(String[] array) {
        if (ObjectUtils.isEmpty(array)) {
            return array;
        }
        Arrays.sort(array);
        return array;
    }

    public static String[] trimArrayElements(String[] array) {
        if (ObjectUtils.isEmpty(array)) {
            return array;
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            String element = array[i];
            result[i] = element != null ? element.trim() : null;
        }
        return result;
    }

    public static String[] removeDuplicateStrings(String[] array) {
        if (ObjectUtils.isEmpty(array)) {
            return array;
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>(Arrays.asList(array));
        return StringUtils.toStringArray(set);
    }

    @Nullable
    public static String[] split(@Nullable String toSplit, @Nullable String delimiter) {
        if (!StringUtils.hasLength(toSplit) || !StringUtils.hasLength(delimiter)) {
            return null;
        }
        int offset = toSplit.indexOf(delimiter);
        if (offset < 0) {
            return null;
        }
        String beforeDelimiter = toSplit.substring(0, offset);
        String afterDelimiter = toSplit.substring(offset + delimiter.length());
        return new String[]{beforeDelimiter, afterDelimiter};
    }

    @Nullable
    public static Properties splitArrayElementsIntoProperties(String[] array, String delimiter) {
        return StringUtils.splitArrayElementsIntoProperties(array, delimiter, null);
    }

    @Nullable
    public static Properties splitArrayElementsIntoProperties(String[] array, String delimiter, @Nullable String charsToDelete) {
        if (ObjectUtils.isEmpty(array)) {
            return null;
        }
        Properties result = new Properties();
        for (String element : array) {
            String[] splittedElement;
            if (charsToDelete != null) {
                element = StringUtils.deleteAny(element, charsToDelete);
            }
            if ((splittedElement = StringUtils.split(element, delimiter)) == null) continue;
            result.setProperty(splittedElement[0].trim(), splittedElement[1].trim());
        }
        return result;
    }

    public static String[] tokenizeToStringArray(@Nullable String str2, String delimiters) {
        return StringUtils.tokenizeToStringArray(str2, delimiters, true, true);
    }

    public static String[] tokenizeToStringArray(@Nullable String str2, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str2 == null) {
            return EMPTY_STRING_ARRAY;
        }
        StringTokenizer st = new StringTokenizer(str2, delimiters);
        ArrayList<String> tokens2 = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens2.add(token);
        }
        return StringUtils.toStringArray(tokens2);
    }

    public static String[] delimitedListToStringArray(@Nullable String str2, @Nullable String delimiter) {
        return StringUtils.delimitedListToStringArray(str2, delimiter, null);
    }

    public static String[] delimitedListToStringArray(@Nullable String str2, @Nullable String delimiter, @Nullable String charsToDelete) {
        if (str2 == null) {
            return EMPTY_STRING_ARRAY;
        }
        if (delimiter == null) {
            return new String[]{str2};
        }
        ArrayList<String> result = new ArrayList<String>();
        if (delimiter.isEmpty()) {
            for (int i = 0; i < str2.length(); ++i) {
                result.add(StringUtils.deleteAny(str2.substring(i, i + 1), charsToDelete));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str2.indexOf(delimiter, pos)) != -1) {
                result.add(StringUtils.deleteAny(str2.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str2.length() > 0 && pos <= str2.length()) {
                result.add(StringUtils.deleteAny(str2.substring(pos), charsToDelete));
            }
        }
        return StringUtils.toStringArray(result);
    }

    public static String[] commaDelimitedListToStringArray(@Nullable String str2) {
        return StringUtils.delimitedListToStringArray(str2, ",");
    }

    public static Set<String> commaDelimitedListToSet(@Nullable String str2) {
        String[] tokens2 = StringUtils.commaDelimitedListToStringArray(str2);
        return new LinkedHashSet<String>(Arrays.asList(tokens2));
    }

    public static String collectionToDelimitedString(@Nullable Collection<?> coll, String delim, String prefix, String suffix) {
        if (CollectionUtils.isEmpty(coll)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            sb.append(prefix).append(it.next()).append(suffix);
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String collectionToDelimitedString(@Nullable Collection<?> coll, String delim) {
        return StringUtils.collectionToDelimitedString(coll, delim, "", "");
    }

    public static String collectionToCommaDelimitedString(@Nullable Collection<?> coll) {
        return StringUtils.collectionToDelimitedString(coll, ",");
    }

    public static String arrayToDelimitedString(@Nullable Object[] arr, String delim) {
        if (ObjectUtils.isEmpty(arr)) {
            return "";
        }
        if (arr.length == 1) {
            return ObjectUtils.nullSafeToString(arr[0]);
        }
        StringJoiner sj = new StringJoiner(delim);
        for (Object o : arr) {
            sj.add(String.valueOf(o));
        }
        return sj.toString();
    }

    public static String arrayToCommaDelimitedString(@Nullable Object[] arr) {
        return StringUtils.arrayToDelimitedString(arr, ",");
    }
}

