/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import edu.wisc.library.ocfl.api.MutableOcflRepository;
import edu.wisc.library.ocfl.core.OcflRepositoryBuilder;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import edu.wisc.library.ocfl.core.extension.storage.layout.config.HashedTruncatedNTupleConfig;
import edu.wisc.library.ocfl.core.path.mapper.LogicalPathMapper;
import edu.wisc.library.ocfl.core.path.mapper.LogicalPathMappers;
import edu.wisc.library.ocfl.core.storage.OcflStorage;
import edu.wisc.library.ocfl.core.storage.filesystem.FileSystemOcflStorage;
import java.nio.file.Path;
import org.apache.commons.lang3.SystemUtils;
import org.fcrepo.migration.MigrationType;
import org.fcrepo.migration.handlers.ocfl.PlainOcflObjectSessionFactory;
import org.fcrepo.storage.ocfl.CommitType;
import org.fcrepo.storage.ocfl.DefaultOcflObjectSessionFactory;
import org.fcrepo.storage.ocfl.OcflObjectSessionFactory;
import org.fcrepo.storage.ocfl.cache.Cache;
import org.fcrepo.storage.ocfl.cache.NoOpCache;
import org.springframework.beans.factory.FactoryBean;

public class OcflSessionFactoryFactoryBean
implements FactoryBean<OcflObjectSessionFactory> {
    private final Path ocflRoot;
    private final Path stagingDir;
    private final MigrationType migrationType;
    private final String user;
    private final String userUri;

    public OcflSessionFactoryFactoryBean(Path ocflRoot, Path stagingDir, MigrationType migrationType, String user, String userUri) {
        this.ocflRoot = ocflRoot;
        this.stagingDir = stagingDir;
        this.migrationType = migrationType;
        this.user = user;
        this.userUri = userUri;
    }

    public OcflObjectSessionFactory getObject() {
        LogicalPathMapper logicalPathMapper = SystemUtils.IS_OS_WINDOWS ? LogicalPathMappers.percentEncodingWindowsMapper() : LogicalPathMappers.percentEncodingLinuxMapper();
        MutableOcflRepository ocflRepo = new OcflRepositoryBuilder().layoutConfig((OcflExtensionConfig)new HashedTruncatedNTupleConfig()).logicalPathMapper(logicalPathMapper).storage((OcflStorage)FileSystemOcflStorage.builder().repositoryRoot(this.ocflRoot).build()).workDir(this.stagingDir).buildMutable();
        if (this.migrationType == MigrationType.FEDORA_OCFL) {
            ObjectMapper objectMapper = new ObjectMapper().configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).registerModule((Module)new JavaTimeModule()).setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return new DefaultOcflObjectSessionFactory(ocflRepo, this.stagingDir, objectMapper, (Cache)new NoOpCache(), CommitType.NEW_VERSION, "Generated by Fedora 3 to Fedora 6 migration", this.user, this.userUri);
        }
        return new PlainOcflObjectSessionFactory(ocflRepo, this.stagingDir, "Generated by Fedora 3 to Fedora 6 migration", this.user, this.userUri);
    }

    public Class<?> getObjectType() {
        return OcflObjectSessionFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

