/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import edu.wisc.library.ocfl.api.util.Enforce;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.fcrepo.migration.MigrationType;
import org.fcrepo.migration.Migrator;
import org.fcrepo.migration.ObjectSource;
import org.fcrepo.migration.OcflSessionFactoryFactoryBean;
import org.fcrepo.migration.foxml.AkubraFSIDResolver;
import org.fcrepo.migration.foxml.ArchiveExportedFoxmlDirectoryObjectSource;
import org.fcrepo.migration.foxml.LegacyFSIDResolver;
import org.fcrepo.migration.foxml.NativeFoxmlDirectoryObjectSource;
import org.fcrepo.migration.handlers.ObjectAbstractionStreamingFedoraObjectHandler;
import org.fcrepo.migration.handlers.VersionAbstractionFedoraObjectHandler;
import org.fcrepo.migration.handlers.ocfl.ArchiveGroupHandler;
import org.fcrepo.migration.pidlist.PidListManager;
import org.fcrepo.migration.pidlist.ResumePidListManager;
import org.fcrepo.migration.pidlist.UserProvidedPidListManager;
import org.fcrepo.storage.ocfl.OcflObjectSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="migration-utils", mixinStandardHelpOptions=true, sortOptions=false, version={"Migration Utils - 4.4.1.b"})
public class PicocliMigrator
implements Callable<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PicocliMigrator.class);
    @CommandLine.Option(names={"--source-type", "-t"}, required=true, order=1, description={"Fedora 3 source type. Choices: akubra | legacy | exported"})
    private F3SourceTypes f3SourceType;
    @CommandLine.Option(names={"--datastreams-dir", "-d"}, order=2, description={"Directory containing Fedora 3 datastreams (used with --source-type 'akubra' or 'legacy')"})
    private File f3DatastreamsDir;
    @CommandLine.Option(names={"--objects-dir", "-o"}, order=3, description={"Directory containing Fedora 3 objects (used with --source-type 'akubra' or 'legacy')"})
    private File f3ObjectsDir;
    @CommandLine.Option(names={"--exported-dir", "-e"}, order=4, description={"Directory containing Fedora 3 export (used with --source-type 'exported')"})
    private File f3ExportedDir;
    @CommandLine.Option(names={"--target-dir", "-a"}, required=true, order=5, description={"Directory where OCFL storage root and supporting state will be written"})
    private File targetDir;
    @CommandLine.Option(names={"--delete-inactive", "-I"}, defaultValue="false", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=18, description={"Migrate objects and datastreams in the Inactive state as deleted. Default: false."})
    private boolean deleteInactive;
    @CommandLine.Option(names={"--migration-type", "-m"}, defaultValue="FEDORA_OCFL", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=19, description={"Type of OCFL objects to migrate to. Choices: FEDORA_OCFL | PLAIN_OCFL"})
    private MigrationType migrationType;
    @CommandLine.Option(names={"--limit", "-l"}, defaultValue="-1", order=21, description={"Limit number of objects to be processed.\n  Default: no limit"})
    private int objectLimit;
    @CommandLine.Option(names={"--resume", "-r"}, defaultValue="false", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=22, description={"Resume from last successfully migrated Fedora 3 object"})
    private boolean resume;
    @CommandLine.Option(names={"--continue-on-error", "-c"}, defaultValue="false", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=23, description={"Continue to next PID if an error occurs (instead of exiting). Disabled by default."})
    private boolean continueOnError;
    @CommandLine.Option(names={"--pid-file", "-p"}, order=24, description={"PID file listing which Fedora 3 objects to migrate"})
    private File pidFile;
    @CommandLine.Option(names={"--index-dir", "-i"}, order=25, description={"Directory where cached index of datastreams (will reuse index if already exists)"})
    private File indexDir;
    @CommandLine.Option(names={"--extensions", "-x"}, defaultValue="false", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=26, description={"Add file extensions to migrated datastreams based on mimetype recorded in FOXML"})
    private boolean addExtensions;
    @CommandLine.Option(names={"--f3hostname", "-f"}, defaultValue="fedora.info", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=27, description={"Hostname of Fedora 3, used for replacing placeholder in 'E' and 'R' datastream URLs"})
    private String f3hostname;
    @CommandLine.Option(names={"--username", "-u"}, defaultValue="fedoraAdmin", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=28, description={"The username to associate with all of the migrated resources."})
    private String user;
    @CommandLine.Option(names={"--user-uri", "-U"}, defaultValue="info:fedora/fedoraAdmin", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=29, description={"The username to associate with all of the migrated resources."})
    private String userUri;
    @CommandLine.Option(names={"--debug"}, order=30, description={"Enables debug logging"})
    private boolean debug;

    public static void main(String[] args) {
        PicocliMigrator migrator = new PicocliMigrator();
        CommandLine cmd = new CommandLine((Object)migrator);
        cmd.registerConverter(F3SourceTypes.class, F3SourceTypes::toType);
        cmd.setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new PicoliMigrationExceptionHandler(migrator));
        cmd.execute(args);
    }

    private static void setDebugLogLevel() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger logger = loggerContext.getLogger("org.fcrepo.migration");
        logger.setLevel(Level.toLevel((String)"DEBUG"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws Exception {
        ObjectSource objectSource;
        File pidDir;
        File ocflStagingDir;
        File ocflStorageDir;
        File dataDir;
        if (this.debug) {
            PicocliMigrator.setDebugLogLevel();
        }
        Enforce.notNull((Object)this.targetDir, (String)"targetDir must be provided!");
        if (!this.targetDir.exists()) {
            this.targetDir.mkdirs();
        }
        if (!(dataDir = this.targetDir.toPath().resolve("data").toFile()).exists()) {
            dataDir.mkdirs();
        }
        if (!(ocflStorageDir = new File(dataDir, "ocfl-root")).exists()) {
            ocflStorageDir.mkdirs();
        }
        if (!(ocflStagingDir = new File(dataDir, "staging")).exists()) {
            ocflStagingDir.mkdirs();
        }
        if (!(pidDir = new File(this.targetDir, "pid")).exists()) {
            pidDir.mkdirs();
        }
        switch (this.f3SourceType) {
            case EXPORTED: {
                Enforce.notNull((Object)this.f3ExportedDir, (String)"f3ExportDir must be used with 'exported' source!");
                objectSource = new ArchiveExportedFoxmlDirectoryObjectSource(this.f3ExportedDir, this.f3hostname);
                break;
            }
            case AKUBRA: {
                Enforce.notNull((Object)this.f3DatastreamsDir, (String)"f3DatastreamsDir must be used with 'akubra' or 'legacy' source!");
                Enforce.notNull((Object)this.f3ObjectsDir, (String)"f3ObjectsDir must be used with 'akubra' or 'legacy' source!");
                Enforce.expressionTrue((boolean)this.f3ObjectsDir.exists(), (Object)this.f3ObjectsDir, (String)("f3ObjectsDir must exist! " + this.f3ObjectsDir.getAbsolutePath()));
                AkubraFSIDResolver idResolver = new AkubraFSIDResolver(this.indexDir, this.f3DatastreamsDir);
                objectSource = new NativeFoxmlDirectoryObjectSource(this.f3ObjectsDir, idResolver, this.f3hostname);
                break;
            }
            case LEGACY: {
                Enforce.notNull((Object)this.f3DatastreamsDir, (String)"f3DatastreamsDir must be used with 'akubra' or 'legacy' source!");
                Enforce.notNull((Object)this.f3ObjectsDir, (String)"f3ObjectsDir must be used with 'akubra' or 'legacy' source!");
                Enforce.expressionTrue((boolean)this.f3ObjectsDir.exists(), (Object)this.f3ObjectsDir, (String)("f3ObjectsDir must exist! " + this.f3ObjectsDir.getAbsolutePath()));
                LegacyFSIDResolver idResolver = new LegacyFSIDResolver(this.indexDir, this.f3DatastreamsDir);
                objectSource = new NativeFoxmlDirectoryObjectSource(this.f3ObjectsDir, idResolver, this.f3hostname);
                break;
            }
            default: {
                throw new RuntimeException("Should never happen");
            }
        }
        OcflObjectSessionFactory ocflSessionFactory = new OcflSessionFactoryFactoryBean(ocflStorageDir.toPath(), ocflStagingDir.toPath(), this.migrationType, this.user, this.userUri).getObject();
        ArchiveGroupHandler archiveGroupHandler = new ArchiveGroupHandler(ocflSessionFactory, this.migrationType, this.addExtensions, this.deleteInactive, this.user);
        VersionAbstractionFedoraObjectHandler versionHandler = new VersionAbstractionFedoraObjectHandler(archiveGroupHandler);
        ObjectAbstractionStreamingFedoraObjectHandler objectHandler = new ObjectAbstractionStreamingFedoraObjectHandler(versionHandler);
        ResumePidListManager resumeManager = new ResumePidListManager(pidDir, !this.resume);
        UserProvidedPidListManager pidListManager = new UserProvidedPidListManager(this.pidFile);
        List<PidListManager> pidListManagerList = Arrays.asList(pidListManager, resumeManager);
        Migrator migrator = new Migrator();
        migrator.setLimit(this.objectLimit);
        migrator.setSource(objectSource);
        migrator.setHandler(objectHandler);
        migrator.setPidListManagers(pidListManagerList);
        migrator.setContinueOnError(this.continueOnError);
        try {
            migrator.run();
        }
        finally {
            ocflSessionFactory.close();
            FileUtils.deleteDirectory((File)ocflStagingDir);
        }
        return 0;
    }

    private static class PicoliMigrationExceptionHandler
    implements CommandLine.IExecutionExceptionHandler {
        private final PicocliMigrator migrator;

        PicoliMigrationExceptionHandler(PicocliMigrator migrator) {
            this.migrator = migrator;
        }

        public int handleExecutionException(Exception ex, CommandLine commandLine, CommandLine.ParseResult parseResult) {
            commandLine.getErr().println(ex.getMessage());
            if (this.migrator.debug) {
                ex.printStackTrace(commandLine.getErr());
            }
            commandLine.usage(commandLine.getErr());
            return commandLine.getCommandSpec().exitCodeOnExecutionException();
        }
    }

    private static enum F3SourceTypes {
        AKUBRA,
        LEGACY,
        EXPORTED;


        static F3SourceTypes toType(String v) {
            return F3SourceTypes.valueOf(v.toUpperCase());
        }
    }
}

