/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.foxml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.fcrepo.migration.ContentDigest;
import org.fcrepo.migration.DatastreamInfo;
import org.fcrepo.migration.DatastreamVersion;
import org.fcrepo.migration.DefaultContentDigest;
import org.fcrepo.migration.DefaultObjectInfo;
import org.fcrepo.migration.FedoraObjectProcessor;
import org.fcrepo.migration.ObjectInfo;
import org.fcrepo.migration.ObjectProperties;
import org.fcrepo.migration.ObjectReference;
import org.fcrepo.migration.StreamingFedoraObjectHandler;
import org.fcrepo.migration.foxml.CachedContent;
import org.fcrepo.migration.foxml.FileCachedContent;
import org.fcrepo.migration.foxml.FoxmlObjectProperties;
import org.fcrepo.migration.foxml.FoxmlObjectProperty;
import org.fcrepo.migration.foxml.InternalIDResolver;
import org.fcrepo.migration.foxml.MemoryCachedContent;
import org.fcrepo.migration.foxml.URLCachedContent;
import org.fcrepo.migration.foxml.URLFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FoxmlInputStreamFedoraObjectProcessor
implements FedoraObjectProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(FoxmlInputStreamFedoraObjectProcessor.class);
    private static final String FOXML_NS = "info:fedora/fedora-system:def/foxml#";
    private URLFetcher fetcher;
    private String localFedoraServer;
    private InternalIDResolver idResolver;
    private InputStream stream;
    private XMLStreamReader reader;
    private List<File> tempFiles;
    boolean isFedora2 = false;
    private ObjectInfo objectInfo;

    public FoxmlInputStreamFedoraObjectProcessor(InputStream is, URLFetcher fetcher, InternalIDResolver resolver, String localFedoraServer) throws XMLStreamException {
        this.fetcher = fetcher;
        this.idResolver = resolver;
        this.localFedoraServer = localFedoraServer;
        XMLInputFactory factory = XMLInputFactory.newFactory();
        this.stream = is;
        this.reader = factory.createXMLStreamReader(is);
        this.reader.nextTag();
        Map<String, String> attributes = FoxmlInputStreamFedoraObjectProcessor.getAttributes(this.reader, "PID", "VERSION", "FEDORA_URI", "schemaLocation");
        if (attributes.get("VERSION") == null || !attributes.get("VERSION").equals("1.1")) {
            this.isFedora2 = true;
        }
        this.objectInfo = new DefaultObjectInfo(attributes.get("PID"), attributes.get("FEDORA_URI"));
        while (this.reader.next() == 4) {
        }
        this.tempFiles = new ArrayList<File>();
    }

    @Override
    public ObjectInfo getObjectInfo() {
        return this.objectInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processObject(StreamingFedoraObjectHandler handler) {
        handler.beginObject(this.objectInfo);
        Foxml11DatastreamInfo dsInfo = null;
        try {
            handler.processObjectProperties(this.readProperties());
            while (this.reader.hasNext()) {
                if (this.reader.isCharacters()) {
                    if (!this.reader.isWhiteSpace()) {
                        throw new RuntimeException("Unexpected character data! \"" + this.reader.getText() + "\"");
                    }
                } else if (this.reader.isStartElement()) {
                    if (this.reader.getLocalName().equals("datastream") && this.reader.getNamespaceURI().equals(FOXML_NS)) {
                        dsInfo = new Foxml11DatastreamInfo(this.objectInfo, this.reader);
                    } else if (this.reader.getLocalName().equals("datastreamVersion")) {
                        Foxml11DatastreamVersion v = new Foxml11DatastreamVersion(dsInfo, this.reader);
                        handler.processDatastreamVersion(v);
                    } else {
                        if (!this.reader.getLocalName().equals("disseminator") || !this.isFedora2) throw new RuntimeException("Unexpected element! \"" + this.reader.getLocalName() + "\"!");
                        this.readUntilClosed("disseminator", FOXML_NS);
                        handler.processDisseminator();
                    }
                } else if (this.reader.isEndElement() && dsInfo != null && this.reader.getLocalName().equals("datastream")) {
                    dsInfo = null;
                } else {
                    if (!this.reader.isEndElement() || !this.reader.getLocalName().equals("digitalObject")) throw new RuntimeException("Unexpected xml structure! \"" + this.reader.getEventType() + "\" at line " + this.reader.getLocation().getLineNumber() + ", column " + this.reader.getLocation().getColumnNumber() + "!" + (String)(this.reader.isCharacters() ? "  \"" + this.reader.getText() + "\"" : ""));
                    handler.completeObject(this.objectInfo);
                    this.cleanUpTempFiles();
                }
                this.reader.next();
            }
            return;
        }
        catch (Exception e) {
            handler.abortObject(this.objectInfo);
            if (!(e instanceof RuntimeException)) throw new RuntimeException(e);
            throw (RuntimeException)e;
        }
        finally {
            this.cleanUpTempFiles();
            this.close();
        }
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (XMLStreamException e) {
            LOG.warn("Failed to close reader cleanly", (Throwable)e);
        }
        try {
            this.stream.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to close file cleanly", (Throwable)e);
        }
    }

    private void cleanUpTempFiles() {
        for (File f : this.tempFiles) {
            if (!f.exists()) continue;
            f.delete();
        }
    }

    private ObjectProperties readProperties() throws JAXBException, XMLStreamException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{FoxmlObjectProperties.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        JAXBElement p = unmarshaller.unmarshal(this.reader, FoxmlObjectProperties.class);
        FoxmlObjectProperties properties = (FoxmlObjectProperties)p.getValue();
        if (this.isFedora2) {
            for (FoxmlObjectProperty prop : properties.properties) {
                if (!prop.getName().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) continue;
                prop.name = "http://purl.org/dc/terms/type";
            }
        }
        return properties;
    }

    private void readUntilClosed(String name, String namespace) throws XMLStreamException {
        while (this.reader.hasNext()) {
            if (this.reader.isEndElement() && this.reader.getLocalName().equals(name) && this.reader.getNamespaceURI().equals(namespace)) {
                return;
            }
            this.reader.next();
        }
    }

    private static Map<String, String> getAttributes(XMLStreamReader r, String ... allowedNames) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashSet<String> allowed = new HashSet<String>(Arrays.asList(allowedNames));
        for (int i = 0; i < r.getAttributeCount(); ++i) {
            String localName = r.getAttributeLocalName(i);
            String value = r.getAttributeValue(i);
            if (allowed.contains(localName)) {
                result.put(localName, value);
                continue;
            }
            System.err.println("Unexpected attribute: " + localName + " = \"" + value + "\"");
        }
        return result;
    }

    public class Foxml11DatastreamVersion
    implements DatastreamVersion {
        private DatastreamInfo dsInfo;
        private String id;
        private String label;
        private String created;
        private String mimeType;
        private String altIds;
        private String formatUri;
        private long size;
        private ContentDigest contentDigest;
        private CachedContent dsContent;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Foxml11DatastreamVersion(DatastreamInfo dsInfo, XMLStreamReader reader) throws XMLStreamException {
            this.dsInfo = dsInfo;
            Map<String, String> dsAttributes = FoxmlInputStreamFedoraObjectProcessor.getAttributes(reader, "ID", "LABEL", "CREATED", "MIMETYPE", "ALT_IDS", "FORMAT_URI", "SIZE");
            this.id = dsAttributes.get("ID");
            this.label = dsAttributes.get("LABEL");
            this.created = dsAttributes.get("CREATED");
            this.mimeType = dsAttributes.get("MIMETYPE");
            this.altIds = dsAttributes.get("ALT_IDS");
            this.formatUri = dsAttributes.get("FORMAT_URI");
            this.size = dsAttributes.containsKey("SIZE") ? Long.parseLong(dsAttributes.get("SIZE")) : -1L;
            reader.next();
            while (reader.hasNext()) {
                if (reader.isCharacters()) {
                    if (!reader.isWhiteSpace()) {
                        throw new RuntimeException("Unexpected character data! \"" + reader.getText() + "\"");
                    }
                } else if (reader.isStartElement()) {
                    Map<String, String> attributes;
                    String localName = reader.getLocalName();
                    if (localName.equals("contentDigest")) {
                        attributes = FoxmlInputStreamFedoraObjectProcessor.getAttributes(reader, "TYPE", "DIGEST");
                        this.contentDigest = new DefaultContentDigest(attributes.get("TYPE"), attributes.get("DIGEST"));
                    } else {
                        if (localName.equals("xmlContent")) {
                            reader.next();
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            XMLEventReader eventReader = XMLInputFactory.newFactory().createXMLEventReader(reader);
                            XMLEventWriter eventWriter = XMLOutputFactory.newFactory().createXMLEventWriter(baos);
                            while (eventReader.hasNext()) {
                                XMLEvent event = eventReader.nextEvent();
                                if (event.isEndElement() && event.asEndElement().getName().getLocalPart().equals("xmlContent") && event.asEndElement().getName().getNamespaceURI().equals(FoxmlInputStreamFedoraObjectProcessor.FOXML_NS)) {
                                    eventWriter.close();
                                    break;
                                }
                                eventWriter.add(event);
                            }
                            try {
                                this.dsContent = new MemoryCachedContent(new String(baos.toByteArray(), "UTF-8"));
                            }
                            catch (UnsupportedEncodingException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        if (localName.equals("contentLocation")) {
                            attributes = FoxmlInputStreamFedoraObjectProcessor.getAttributes(reader, "REF", "TYPE");
                            if (attributes.get("TYPE").equals("INTERNAL_ID")) {
                                this.dsContent = FoxmlInputStreamFedoraObjectProcessor.this.idResolver.resolveInternalID(attributes.get("REF"));
                            } else {
                                try {
                                    String ref = attributes.get("REF");
                                    if (ref.contains("local.fedora.server")) {
                                        ref = ref.replace("local.fedora.server", FoxmlInputStreamFedoraObjectProcessor.this.localFedoraServer);
                                    }
                                    this.dsContent = new URLCachedContent(new URL(ref), FoxmlInputStreamFedoraObjectProcessor.this.fetcher);
                                }
                                catch (MalformedURLException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        } else {
                            if (!localName.equals("binaryContent")) throw new RuntimeException("Unexpected element! \"" + reader.getLocalName() + "\"!");
                            try {
                                File f = File.createTempFile("decoded", "file");
                                FoxmlInputStreamFedoraObjectProcessor.this.tempFiles.add(f);
                                Base64OutputStream out = new Base64OutputStream((OutputStream)new FileOutputStream(f), false);
                                while (reader.next() == 4) {
                                    out.write(reader.getText().getBytes("UTF-8"));
                                }
                                out.flush();
                                out.close();
                                this.dsContent = new FileCachedContent(f);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            FoxmlInputStreamFedoraObjectProcessor.this.readUntilClosed("binaryContent", FoxmlInputStreamFedoraObjectProcessor.FOXML_NS);
                        }
                    }
                } else {
                    if (!reader.isEndElement()) throw new RuntimeException("Unexpected xml structure! \"" + reader.getEventType() + "\" at line " + reader.getLocation().getLineNumber() + ", column " + reader.getLocation().getColumnNumber() + "!" + (String)(reader.isCharacters() ? "  \"" + reader.getText() + "\"" : ""));
                    if (reader.getLocalName().equals("datastreamVersion")) {
                        return;
                    }
                }
                reader.next();
            }
        }

        @Override
        public DatastreamInfo getDatastreamInfo() {
            return this.dsInfo;
        }

        @Override
        public String getVersionId() {
            return this.id;
        }

        @Override
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public String getCreated() {
            return this.created;
        }

        @Override
        public String getAltIds() {
            return this.altIds;
        }

        @Override
        public String getFormatUri() {
            return this.formatUri;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        public ContentDigest getContentDigest() {
            return this.contentDigest;
        }

        @Override
        public InputStream getContent() throws IOException {
            return this.dsContent.getInputStream();
        }

        @Override
        public String getExternalOrRedirectURL() {
            if (this.dsContent instanceof URLCachedContent) {
                return ((URLCachedContent)this.dsContent).getURL().toString();
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean isFirstVersionIn(ObjectReference obj) {
            List<DatastreamVersion> datastreams = obj.getDatastreamVersions(this.getDatastreamInfo().getDatastreamId());
            return datastreams.indexOf(this) == 0;
        }

        @Override
        public boolean isLastVersionIn(ObjectReference obj) {
            List<DatastreamVersion> datastreams = obj.getDatastreamVersions(this.getDatastreamInfo().getDatastreamId());
            return datastreams.indexOf(this) == datastreams.size() - 1;
        }
    }

    private class Foxml11DatastreamInfo
    implements DatastreamInfo {
        private String id;
        private String controlGroup;
        private String fedoraUri;
        private String state;
        private boolean versionable;
        private ObjectInfo objectInfo;

        public Foxml11DatastreamInfo(ObjectInfo objectInfo, XMLStreamReader reader) {
            this.objectInfo = objectInfo;
            Map<String, String> attributes = FoxmlInputStreamFedoraObjectProcessor.getAttributes(reader, "ID", "CONTROL_GROUP", "FEDORA_URI", "STATE", "VERSIONABLE");
            this.id = attributes.get("ID");
            this.controlGroup = attributes.get("CONTROL_GROUP");
            this.fedoraUri = attributes.get("FEDORA_URI");
            this.state = attributes.get("STATE");
            this.versionable = Boolean.valueOf(attributes.get("VERSIONABLE"));
        }

        @Override
        public ObjectInfo getObjectInfo() {
            return this.objectInfo;
        }

        @Override
        public String getDatastreamId() {
            return this.id;
        }

        @Override
        public String getControlGroup() {
            return this.controlGroup;
        }

        @Override
        public String getFedoraURI() {
            return this.fedoraUri;
        }

        @Override
        public String getState() {
            return this.state;
        }

        @Override
        public boolean getVersionable() {
            return this.versionable;
        }
    }
}

