/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fcrepo.migration.DatastreamVersion;
import org.fcrepo.migration.FedoraObjectHandler;
import org.fcrepo.migration.ObjectInfo;
import org.fcrepo.migration.ObjectProperties;
import org.fcrepo.migration.ObjectReference;
import org.fcrepo.migration.StreamingFedoraObjectHandler;

public class ObjectAbstractionStreamingFedoraObjectHandler
implements StreamingFedoraObjectHandler {
    private FedoraObjectHandler handler;
    private ObjectInfo objectInfo;
    private ObjectProperties objectProperties;
    private List<String> dsIds;
    private Map<String, List<DatastreamVersion>> dsIdToVersionListMap;
    private int disseminatorsSkipped = 0;

    public ObjectAbstractionStreamingFedoraObjectHandler(FedoraObjectHandler objectHandler) {
        this.handler = objectHandler;
        this.dsIds = new ArrayList<String>();
        this.dsIdToVersionListMap = new HashMap<String, List<DatastreamVersion>>();
    }

    @Override
    public void beginObject(ObjectInfo object) {
        this.objectInfo = object;
    }

    @Override
    public void processObjectProperties(ObjectProperties properties) {
        this.objectProperties = properties;
    }

    @Override
    public void processDatastreamVersion(DatastreamVersion dsVersion) {
        List<DatastreamVersion> versions = this.dsIdToVersionListMap.get(dsVersion.getDatastreamInfo().getDatastreamId());
        if (versions == null) {
            this.dsIds.add(dsVersion.getDatastreamInfo().getDatastreamId());
            versions = new ArrayList<DatastreamVersion>();
            this.dsIdToVersionListMap.put(dsVersion.getDatastreamInfo().getDatastreamId(), versions);
        }
        versions.add(dsVersion);
    }

    @Override
    public void processDisseminator() {
        ++this.disseminatorsSkipped;
    }

    @Override
    public void completeObject(ObjectInfo object) {
        try {
            this.handler.processObject(new ObjectReference(){

                @Override
                public ObjectInfo getObjectInfo() {
                    return ObjectAbstractionStreamingFedoraObjectHandler.this.objectInfo;
                }

                @Override
                public ObjectProperties getObjectProperties() {
                    return ObjectAbstractionStreamingFedoraObjectHandler.this.objectProperties;
                }

                @Override
                public List<String> listDatastreamIds() {
                    return ObjectAbstractionStreamingFedoraObjectHandler.this.dsIds;
                }

                @Override
                public List<DatastreamVersion> getDatastreamVersions(String datastreamId) {
                    return ObjectAbstractionStreamingFedoraObjectHandler.this.dsIdToVersionListMap.get(datastreamId);
                }

                @Override
                public boolean hadFedora2Disseminators() {
                    return ObjectAbstractionStreamingFedoraObjectHandler.this.disseminatorsSkipped > 0;
                }
            });
        }
        finally {
            this.cleanForReuse();
        }
    }

    @Override
    public void abortObject(ObjectInfo object) {
        this.cleanForReuse();
    }

    private void cleanForReuse() {
        this.dsIds.clear();
        this.dsIdToVersionListMap.clear();
    }
}

