/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.pidlist;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.fcrepo.migration.pidlist.PidListManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserProvidedPidListManager
implements PidListManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserProvidedPidListManager.class);
    private Set<String> pidList = new HashSet<String>();

    public UserProvidedPidListManager(File pidListFile) {
        if (pidListFile != null) {
            if (!pidListFile.exists() || !pidListFile.canRead()) {
                throw new IllegalArgumentException("File either does not exist or is inaccessible :" + pidListFile.getAbsolutePath());
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(pidListFile));){
                reader.lines().forEach(l -> this.pidList.add((String)l));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean accept(String pid) {
        boolean doAccept = this.pidList.isEmpty() || this.pidList.contains(pid);
        LOGGER.debug("PID: {}, accept? {}", (Object)pid, (Object)doAccept);
        return doAccept;
    }
}

