/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmdline.ArgProc;
import java.util.ArrayList;
import java.util.List;

public class CommandLineBase {
    private List<String> argList = new ArrayList<String>();
    boolean splitTerms = true;

    public CommandLineBase(String[] args) {
        this.setArgs(args);
    }

    public CommandLineBase() {
    }

    public void setArgs(String[] argv) {
        this.argList = this.processArgv(argv);
    }

    protected List<String> getArgList() {
        return this.argList;
    }

    protected String getArg(int i2) {
        if (i2 < 0 || i2 >= this.argList.size()) {
            return null;
        }
        return this.argList.get(i2);
    }

    protected void apply(ArgProc a) {
        a.startArgs();
        for (int i2 = 0; i2 < this.argList.size(); ++i2) {
            String arg = this.argList.get(i2);
            a.arg(arg, i2);
        }
        a.finishArgs();
    }

    private List<String> processArgv(String[] argv) {
        ArrayList<String> argList = new ArrayList<String>();
        boolean positional = false;
        String[] arr$ = argv;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String anArgv;
            String argStr = anArgv = arr$[i$];
            if (positional || !argStr.startsWith("-")) {
                argList.add(argStr);
                continue;
            }
            if (argStr.equals("-") || argStr.equals("--")) {
                positional = true;
                argList.add("--");
                continue;
            }
            if (!argStr.startsWith("--")) {
                argStr = "-" + argStr;
            }
            if (!this.splitTerms) {
                argList.add(argStr);
                continue;
            }
            int j1 = argStr.indexOf(61);
            int j2 = argStr.indexOf(58);
            int j = -1;
            if (j1 > 0 && j2 > 0) {
                j = Math.min(j1, j2);
            } else {
                if (j1 > 0) {
                    j = j1;
                }
                if (j2 > 0) {
                    j = j2;
                }
            }
            if (j < 0) {
                argList.add(argStr);
                continue;
            }
            String argStr1 = argStr.substring(0, j);
            String argStr2 = argStr.substring(j + 1);
            argList.add(argStr1);
            argList.add(argStr2);
        }
        return argList;
    }
}

