/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.mem.BunchMap;
import com.hp.hpl.jena.mem.HashCommon;
import com.hp.hpl.jena.mem.TripleBunch;
import com.hp.hpl.jena.shared.BrokenException;

public class HashedBunchMap
extends HashCommon<Object>
implements BunchMap {
    protected TripleBunch[] values;

    public HashedBunchMap() {
        super(10);
        this.values = new TripleBunch[this.capacity];
    }

    @Override
    protected Object[] newKeyArray(int size) {
        return new Object[size];
    }

    @Override
    public void clear() {
        this.size = 0;
        for (int i2 = 0; i2 < this.capacity; ++i2) {
            this.values[i2] = null;
            this.keys[i2] = null;
        }
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public TripleBunch get(Object key) {
        int slot = this.findSlot(key);
        return slot < 0 ? this.values[~slot] : null;
    }

    @Override
    public void put(Object key, TripleBunch value) {
        int slot = this.findSlot(key);
        if (slot < 0) {
            this.values[slot ^ 0xFFFFFFFF] = value;
        } else {
            this.keys[slot] = key;
            this.values[slot] = value;
            ++this.size;
            if (this.size == this.threshold) {
                this.grow();
            }
        }
    }

    protected void grow() {
        Object[] oldContents = this.keys;
        TripleBunch[] oldValues = this.values;
        int oldCapacity = this.capacity;
        this.growCapacityAndThreshold();
        this.keys = this.newKeyArray(this.capacity);
        this.values = new TripleBunch[this.capacity];
        for (int i2 = 0; i2 < oldCapacity; ++i2) {
            Object key = oldContents[i2];
            if (key == null) continue;
            int j = this.findSlot(key);
            if (j < 0) {
                throw new BrokenException("oh dear, already have a slot for " + key + ", viz " + ~j);
            }
            this.keys[j] = key;
            this.values[j] = oldValues[i2];
        }
    }

    @Override
    protected void removeAssociatedValues(int here) {
        this.values[here] = null;
    }

    @Override
    protected void moveAssociatedValues(int here, int scan) {
        this.values[here] = this.values[scan];
    }
}

