/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3.turtle;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.n3.turtle.TurtleEventHandler;
import com.hp.hpl.jena.n3.turtle.TurtleParseException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Locale;

public class Turtle2NTriples
implements TurtleEventHandler {
    PrintStream out = System.out;
    static boolean applyUnicodeEscapes = true;

    public Turtle2NTriples(PrintStream out) {
        this.out = out;
    }

    @Override
    public void triple(int line, int col, Triple triple) {
        Node s2 = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        if (!s2.isURI() && !s2.isBlank()) {
            throw new TurtleParseException("[" + line + ", " + col + "] : Error: Subject is not a URI or blank node");
        }
        if (!p.isURI()) {
            throw new TurtleParseException("[" + line + ", " + col + "] : Error: Predicate is not a URI");
        }
        if (!(o.isURI() || o.isBlank() || o.isLiteral())) {
            throw new TurtleParseException("[" + line + ", " + col + "] : Error: Object is not a URI, blank node or literal");
        }
        this.outputNode(s2);
        this.out.print(" ");
        this.outputNode(p);
        this.out.print(" ");
        this.outputNode(o);
        this.out.print(" .");
        this.out.println();
        this.out.flush();
    }

    private void outputNode(Node node) {
        if (node.isURI()) {
            this.out.print("<");
            this.out.print(node.getURI());
            this.out.print(">");
            return;
        }
        if (node.isBlank()) {
            this.out.print("_:");
            this.out.print(node.getBlankNodeLabel());
            return;
        }
        if (node.isLiteral()) {
            this.out.print('\"');
            this.outputEsc(node.getLiteralLexicalForm());
            this.out.print('\"');
            if (node.getLiteralLanguage() != null && node.getLiteralLanguage().length() > 0) {
                this.out.print('@');
                this.out.print(node.getLiteralLanguage());
            }
            if (node.getLiteralDatatypeURI() != null) {
                this.out.print("^^<");
                this.out.print(node.getLiteralDatatypeURI());
                this.out.print(">");
            }
            return;
        }
        System.err.println("Illegal node: " + node);
    }

    @Override
    public void startFormula(int line, int col) {
        throw new TurtleParseException("[" + line + ", " + col + "] : Error: Formula found");
    }

    @Override
    public void endFormula(int line, int col) {
        throw new TurtleParseException("[" + line + ", " + col + "] : Error: Formula found");
    }

    @Override
    public void prefix(int line, int col, String prefix, String iri2) {
    }

    private static void writeString(String s2, PrintWriter writer) {
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c = s2.charAt(i2);
            if (c == '\\' || c == '\"') {
                writer.print('\\');
                writer.print(c);
                continue;
            }
            if (c == '\n') {
                writer.print("\\n");
                continue;
            }
            if (c == '\r') {
                writer.print("\\r");
                continue;
            }
            if (c == '\t') {
                writer.print("\\t");
                continue;
            }
            if (c >= ' ' && c < '\u007f') {
                writer.print(c);
                continue;
            }
            String hexstr = Integer.toHexString(c).toUpperCase(Locale.ENGLISH);
            writer.print("\\u");
            for (int pad = 4 - hexstr.length(); pad > 0; --pad) {
                writer.print("0");
            }
            writer.print(hexstr);
        }
    }

    public void outputEsc(String s2) {
        int len = s2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c = s2.charAt(i2);
            if (c == '\\' || c == '\"') {
                this.out.print('\\');
                this.out.print(c);
                continue;
            }
            if (c == '\n') {
                this.out.print("\\n");
                continue;
            }
            if (c == '\t') {
                this.out.print("\\t");
                continue;
            }
            if (c == '\r') {
                this.out.print("\\r");
                continue;
            }
            if (c == '\f') {
                this.out.print("\\f");
                continue;
            }
            if (c >= ' ' && c < '\u007f') {
                this.out.print(c);
                continue;
            }
            String hexstr = Integer.toHexString(c).toUpperCase();
            this.out.print("\\u");
            for (int pad = 4 - hexstr.length(); pad > 0; --pad) {
                this.out.print("0");
            }
            this.out.print(hexstr);
        }
    }
}

