/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.MinCardinalityQRestriction;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.QualifiedRestrictionImpl;

public class MinCardinalityQRestrictionImpl
extends QualifiedRestrictionImpl
implements MinCardinalityQRestriction {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new MinCardinalityQRestrictionImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to MinCardinalityQRestriction");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            return MinCardinalityQRestrictionImpl.isMinCardinalityQRestriction(node, eg);
        }
    };

    public static boolean isMinCardinalityQRestriction(Node node, EnhGraph eg) {
        Profile profile2 = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
        return profile2 != null && profile2.isSupported(node, eg, MinCardinalityQRestriction.class);
    }

    @Override
    public boolean isValid() {
        return super.isValid() && MinCardinalityQRestrictionImpl.isMinCardinalityQRestriction(this.asNode(), this.getGraph());
    }

    public MinCardinalityQRestrictionImpl(Node n, EnhGraph g2) {
        super(n, g2);
    }

    @Override
    public void setMinCardinalityQ(int cardinality) {
        this.setPropertyValue(this.getProfile().MIN_CARDINALITY_Q(), "MIN_CARDINALITY_Q", this.getModel().createTypedLiteral(cardinality));
    }

    @Override
    public int getMinCardinalityQ() {
        return this.objectAsInt(this.getProfile().MIN_CARDINALITY_Q(), "MIN_CARDINALITY_Q");
    }

    @Override
    public boolean hasMinCardinalityQ(int cardinality) {
        return this.hasPropertyValue(this.getProfile().MIN_CARDINALITY_Q(), "MIN_CARDINALITY_Q", this.getModel().createTypedLiteral(cardinality));
    }

    @Override
    public void removeMinCardinalityQ(int cardinality) {
        this.removePropertyValue(this.getProfile().MIN_CARDINALITY_Q(), "MIN_CARDINALITY_Q", this.getModel().createTypedLiteral(cardinality));
    }
}

